<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ListViewColors_FilterRecordStructure_Model extends Settings_ListViewColors_RecordStructure_Model {

	public function getStructure() {

        if(!empty($this->structuredValues)) {
			return $this->structuredValues;
		}
                
		$recordModel = $this->getListViewColorsModel();
		$recordId = $recordModel->getId();

		$values = array();

		$baseModuleModel = $moduleModel = $this->getModule();
		$blockModelList = $moduleModel->getBlocks();
		foreach($blockModelList as $blockLabel=>$blockModel) {
			$fieldModelList = $blockModel->getFields();
			if (!empty ($fieldModelList)) {
				$values[$blockLabel] = array();
				foreach($fieldModelList as $fieldName=>$fieldModel) {
					if($fieldModel->isViewable()) {
						if (in_array($moduleModel->getName(), array('Calendar', 'Events')) && $fieldModel->getDisplayType() == 3) {
							continue;
						}
						if(!empty($recordId)) {
							$fieldValueType = $recordModel->getFieldFilterValueType($fieldName);
							$fieldInfo = $fieldModel->getFieldInfo();
							$fieldInfo['listviewcolor_valuetype'] = $fieldValueType;
							$fieldModel->setFieldInfo($fieldInfo);
						}

						$values[$blockLabel][$fieldName] = clone $fieldModel;
					}
				}
			}
		}

		$this->structuredValues = $values;
		return $values;
	}
}