<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ListViewColors_Save_Action extends Settings_Vtiger_Basic_Action {

    function __construct() {
        parent::__construct();
        $this->exposeMethod('ActualizeColor');
        $this->exposeMethod('Save');
    }

    public function process(Vtiger_Request $request) {
        $mode = $request->getMode();

        if(empty($mode)) $mode = "Save";

        $this->invokeExposedMethod($mode, $request);
    }
    
    public function Save(Vtiger_Request $request) {
        $recordId = $request->get('record');
        $description = $request->get('description');
        $moduleName = $request->get('module_name');
        $conditions = $request->get('conditions');

        if($recordId) {
                $ListViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
        } else {
                $ListViewColorsModel = Settings_ListViewColors_Record_Model::getCleanInstance($moduleName);
        }

        $response = new Vtiger_Response();
        $ListViewColorsModel->set('description', $description);
        $ListViewColorsModel->set('module_name', $moduleName);
        $ListViewColorsModel->set('conditions', $conditions);

        $ListViewColorsModel->transformAdvanceFilterToListViewColorFilter();

        $ListViewColorsModel->save();
        $response->setResult(array('id' => $ListViewColorsModel->get('listviewcolorid'),'record'=>$recordId));
        $response->emit();
    }
    
    public function ActualizeColor(Vtiger_Request $request) {

        $recordId = $request->get('record');
        $color = $request->get('color');
        
        $ListViewColorsModel = Settings_ListViewColors_Record_Model::getInstance($recordId);
        $ListViewColorsModel->set('color', $color);
        $ListViewColorsModel->updateColor();
        
        header("Location:index.php?module=ListViewColors&parent=Settings&view=List");
    }
} 