<?php
/* * *******************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class Settings_ITS4YouQuickSearch_IndexAjax_View extends Settings_Vtiger_Index_View
{
    public function __construct()
    {
        parent::__construct();
        $Methods = array('editLicense');

        foreach ($Methods as $method) {
            $this->exposeMethod($method);
        }
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');

        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    public function editLicense(Vtiger_Request $request)
    {
        $viewer = $this->getViewer($request);
        $qualifiedModule = $request->getModule(false);
        $viewer->assign("TYPE", "activate");
        $key = $request->get('key');
        $viewer->assign("LICENSEKEY", $key);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);

        echo $viewer->view('EditLicense.tpl', $qualifiedModule, true);
    }
}