<?php

/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouQuickSearch_Module_Model extends Settings_Vtiger_Module_Model
{

    public function saveSearchingColumn($params)
    {
        $adb = PearDatabase::getInstance();

        $defaultUserId = 0;

        $select = "SELECT * FROM its4you_quicksearch_settings WHERE gstabid = ? AND user_id = ?";
        $selectResult = $adb->pquery($select, array((int)$params['tabid'], 0));

        $count = $adb->getRowCount($selectResult);

        $tabId = isset($params['tabid']) ? (int)$params['tabid'] : null;
        $value = isset($params['columns']) ? implode(',', $params['columns']) : null;
        if ($count == 0) {
            $insert = "INSERT INTO its4you_quicksearch_settings (gstabid, searchcolumn, turn_off, user_id) VALUES (?, ?, ?, ?)";
            $result = $adb->pquery($insert, array($tabId, $value, 1, $defaultUserId));
        } else {
            $update = "UPDATE its4you_quicksearch_settings LEFT JOIN vtiger_entityname ON vtiger_entityname.tabid = its4you_quicksearch_settings.gstabid SET searchcolumn = ? WHERE tabid = ? AND user_id = ?";
            $result = $adb->pquery($update, array($value, $tabId, $defaultUserId));
        }

        return $adb->getAffectedRowCount($result);
    }

    /**
     * @param int $status
     * @param int $tabId
     * @param int $userId
     *
     * @return bool
     */
    public function updateModuleStatus($status, $tabId, $userId = 0)
    {
        $adb = PearDatabase::getInstance();

        $query = "UPDATE its4you_quicksearch_settings SET turn_off = ? WHERE gstabid = ? AND user_id = ?";

        return $adb->pquery($query, [$status, $tabId, $userId]) ? true : false;
    }

    /**
     * Function to get Settings links
     * @return <Array>
     */
    public function getSettingLinks()
    {
        $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouQuickSearch");
        return $moduleModel->getSettingLinks();
    }
}
