<?php

/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class Settings_ITS4YouQuickSearch_SaveAjax_Action extends Settings_Vtiger_IndexAjax_View
{
    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('processModuleStatus');
        $this->exposeMethod('saveSearchingFields');
    }

    /**
     * @throws Exception
     */
    public function saveSearchingFields(Vtiger_Request $request)
    {
        $params = $request->get('params');
        $moduleId = $params['tabid'];
        $moduleName = getTabModuleName($moduleId);
        $status = 'off' === $request->get('status') ? '1' : '0';

        $integrationModel = ITS4YouQuickSearch_Integration_Model::getInstance($moduleName);
        $integrationModel->setFieldNames($params['columns']);
        $integrationModel->set('turn_off', $status);
        $integrationModel->save();

        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult(
            array(
                'message' => vtranslate('LBL_SAVE_CHANGES_LABEL', $request->getModule(false))
            )
        );
        $response->emit();
    }

    /**
     * @throws Exception
     */
    public function processModuleStatus(Vtiger_Request $request)
    {
        $tabId = (int)$request->get('tabid', null);
        $status = (int)$request->get('value', null);
        $moduleName = getTabModuleName($tabId);
        $responseData = [
            'success' => false
        ];

        if (in_array($status, [0, 1]) && $moduleName) {
            $integrationModel = ITS4YouQuickSearch_Integration_Model::getInstance($moduleName);
            $integrationModel->set('turn_off', $status);

            if ($integrationModel->save()) {
                $responseData = [
                    'success' => true,
                    'message' => vtranslate('LBL_SAVE_CHANGES_SEARCHING', $request->getModule(false))
                ];
            }
        }

        $response = new Vtiger_Response();
        $response->setEmitType(Vtiger_Response::$EMIT_JSON);
        $response->setResult($responseData);

        $response->emit();
    }
}
