<?php
/*+**********************************************************************************
 The content of this file is subject to the ITS4YouGoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_ITS4YouGoogleCalendarSync_UsersList_View extends Settings_Vtiger_Index_View
{
    public function preProcess (Vtiger_Request $request, $display=true) {

        $viewer = $this->getViewer($request);

        if(ITS4YouGoogleCalendarSync_Utils_Helper::isVtiger7()) {
            $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouGoogleCalendarSync");
            $settingLinks = array();
            $moduleSettingLinks = $moduleModel->getSettingLinks();
            foreach ($moduleSettingLinks as $settingsLink) {
                $settingLinks['LISTVIEWSETTING'][] = Vtiger_Link_Model::getInstanceFromValues($settingsLink);
            }

            $viewer->assign('LISTVIEW_LINKS', $settingLinks);
        }

        parent::preProcess($request);
    }

    public function process(Vtiger_Request $request)
    {
        $Users_List = array();
        $qualifiedModule = $request->getModule(false);
        $viewer = $this->getViewer($request);



        $userCredentials = ITS4YouGoogleCalendarSync_UserCredentials_Model::getActiveUsers();
        foreach ($userCredentials as $userId => $userCredential) {

            $user = new Users();
            $user = $user->retrieve_entity_info($userId, 'Users');
            $user = Users_Record_Model::getInstanceFromUserObject($user);

            $userCredential->set("fullname",$user->getName());
            $Users_List[$userId] = $userCredential;
        }

        if(!ITS4YouGoogleCalendarSync_Utils_Helper::isVtiger7()) {
            $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouGoogleCalendarSync");
            $settingLinks = array();
            $moduleSettingLinks = $moduleModel->getSettingLinks();
            foreach ($moduleSettingLinks as $settingsLink) {
                $settingLinks['LISTVIEWSETTING'][] = Vtiger_Link_Model::getInstanceFromValues($settingsLink);
            }

            $viewer->assign('LISTVIEW_LINKS', $settingLinks);
        }

        $viewer->assign("USERS_LIST", $Users_List);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);

        $viewer->view('UsersList.tpl', $qualifiedModule);
    }

    public function getHeaderScripts(Vtiger_Request $request)
    {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $r = "layouts.";

        if(ITS4YouGoogleCalendarSync_Utils_Helper::isVtiger7()) {
            $r .= "v7";
        } else {
            $r .= "vlayout";
        }

        $jsFileNames = array(
            $r.".modules.Settings.$moduleName.resources.UsersList",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}