<?php 
/*+**********************************************************************************
 The content of this file is subject to the ITS4YouGoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_ITS4YouGoogleCalendarSync_Uninstall_View extends Settings_Vtiger_Index_View {  

    public function process(Vtiger_Request $request) {
        $viewer = $this->getViewer($request);

        $moduleName = $request->getModule();
        $viewer->assign('MODULE', $moduleName);

        $qualifiedModule = $request->getModule(false);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);
        $viewer->assign("URL", vglobal("site_URL"));

        $moduleModel = Vtiger_Module_Model::getInstance("ITS4YouGoogleCalendarSync");

        if(!ITS4YouGoogleCalendarSync_Utils_Helper::isVtiger7()) {
            $settingLinks = array();
            $moduleSettingLinks = $moduleModel->getSettingLinks();
            foreach ($moduleSettingLinks as $settingsLink) {
                $settingLinks['LISTVIEWSETTING'][] = Vtiger_Link_Model::getInstanceFromValues($settingsLink);
            }

            $viewer->assign('LISTVIEW_LINKS', $settingLinks);
        }

        $viewer->assign("LICENSE", $moduleModel->GetLicenseKey());
        $viewer->assign("VERSION_TYPE", $moduleModel->GetVersionType());
        $viewer->assign("LICENSE_DUE_DATE", $moduleModel->GetLicenseDueDate(true));
        $viewer->assign("URL", vglobal("site_URL"));

        $viewer->view('Uninstall.tpl', $qualifiedModule);
    }

    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $r = "layouts.";

        if(ITS4YouGoogleCalendarSync_Utils_Helper::isVtiger7()) {
            $r .= "v7";
        } else {
            $r .= "vlayout";
        }

        $jsFileNames = array(
            $r.'.modules.Vtiger.resources.Vtiger',
            $r.'.modules.Settings.'.$moduleName.'.resources.Uninstall',
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}  