<?php
/*+**********************************************************************************
 The content of this file is subject to the ITS4YouGoogleCalendarSync license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_ITS4YouGoogleCalendarSync_IndexAjax_View extends Settings_Vtiger_Index_View
{
    function __construct() {
        parent::__construct();
        $Methods = array('editLicense','editSync');
        foreach ($Methods AS $method){
            $this->exposeMethod($method);
        }
    }

    function process(Vtiger_Request $request) {

        $mode = $request->get('mode');
        if(!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }

        $type = $request->get('type');
    }

    function editLicense(Vtiger_Request $request) {
        $viewer = $this->getViewer($request);
        $qualifiedModule = $request->getModule(false);

        $viewer->assign("TYPE", "activate");

        $key = $request->get('key');
        $viewer->assign("LICENSEKEY", $key);

        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);

        echo $viewer->view('EditLicense.tpl', $qualifiedModule, true);
    }

    function editSync(Vtiger_Request $request) {
        $viewer = $this->getViewer($request);
        $qualifiedModule = $request->getModule(false);
        $moduleName = $request->getModule();

        $viewer->assign('MODULE', $moduleName);
        $viewer->assign('QUALIFIED_MODULE', $qualifiedModule);

        $defaultSyncAttributes = ITS4YouGoogleCalendarSync_Utils_Helper::getSyncAttributesForUser('0');

        $viewer->assign('CLIENTID', $defaultSyncAttributes["client_id"]);
        $viewer->assign('CLIENT_SECRET', $defaultSyncAttributes["client_secret"]);

        echo $viewer->view('EditSync.tpl', $qualifiedModule, true);
    }
}