<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ************************************************************************************/
class Settings_GeoTools_CheckProvider_View extends Settings_Vtiger_IndexAjax_View{
    
    public function process(Vtiger_Request $request) {
        global $log;
        $type = $request->get('type');
        $providerId = $request->get('providerId');
        $response = new Vtiger_Response();

        if($type && $providerId) {
            $providerModel = GeoTools_Provider_Model::getInstanceById($providerId);
            $log->debug(print_r($providerModel,true));

            if($providerModel->hasReqParams()) {
                $log->debug("hasReqParams");
                $viewer = $this->getViewer($request);

                $params = $providerModel->get('params');
                $config = $providerModel->get('config');
                $url = $providerModel->get('url');

                $qualifiedName = $request->getModule(false);
                $viewer->assign('QUALIFIED_MODULE', $qualifiedName);
                $viewer->assign('URL', $url);
                $viewer->assign('TYPE', $type);
                $viewer->assign('PROVIDER_ID', $providerId);
                $viewer->assign('IS_CONF', $providerModel->isConfigured());
                $viewer->assign('PARAMS', $params);
                $viewer->assign('CONFIG', $config);
                
                $log->debug(print_r($viewer,true));
                
                $viewer->view('CheckProvider.tpl', $qualifiedName);
                return;
            } else {
			    $response->setResult(array(true));
            }
        } else {
    	    $response->setError('Invalid Provider parameters');
    	}
        $response->emit();	    
    }

}

