<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class Settings_GeoTools_ModuleEditor_Model extends Settings_GeoTools_CoreEditor_Model {

    var $iconpath = 'modules/GeoTools/assets/markers/';
    
    var $fields = array(
        'tabid' => 'text',
        'modname' => 'text',
        'field_street' => 'field',
        'field_city' => 'field',
        'field_state' => 'field',
        'field_postcode' => 'field',
        'field_country' => 'field',
        'iconpath' => 'icon',
        'icon_picklist' => 'text',
        'default_filter' => 'text'
    );

    /**
     * Function to get Detail view Url
     * @return <String> Url
     */
    public function getDetailViewUrl() {
        //$menuItem = $this->getMenuItem();
        return '?module=GeoTools&parent=Settings&view=ModuleEditor';
    }

    /**
     * Function to get Edit view Url
     * @return <String> Url
     */
    public function getEditViewUrl() {
        //$menuItem = $this->getMenuItem();
        return '?module=GeoTools&parent=Settings&view=ModuleEditor';
    }

    /**
     * Function to generate list of available modules
     * @return <Array>
     */
    public function getAvailableModules() {
        $db = PearDatabase::getInstance();

        $activeModules = array_keys($this->getConfiguredModules());        
        $donotdisplaymodules = array_merge($activeModules, $this->stupidModules);
        $availableModules = array();
        
        $result = $db->pquery("SELECT name, tabid
                        FROM vtiger_tab
                        WHERE name NOT IN (" .  "'" . implode("','", $donotdisplaymodules) . "'" . ")
                        AND presence IN (0, 2)
                        AND isentitytype = 1", array());

        while($row = $db->fetch_array($result)) {
            $availableModules[$row['name']] = $row['tabid'];
        }
        
        // Add Users module
        $tabid = getTabid('Users');
        if(!in_array('Users', $activeModules)){
            $availableModules['Users'] = $tabid;
        }
        
        return $availableModules;
    }
    
    /**
     * Function to generate list of values for each configured module
     * @return <Array>
     */
    public function getConfiguredModules() {
        $db = PearDatabase::getInstance();
        $tableName = $this->moduleTable;
        $fieldsList = $this->getFields();
        $configured_modules = array();
        unset($fieldsList['modname']);
        
        $query = "SELECT * FROM $tableName";
        
        $result = $db->pquery($query, array());
        while($row = $db->fetch_array($result)) {
            $i = 0;
            foreach($fieldsList as $fieldName => $fieldType){
                $fieldArray[$fieldName]['fieldtype'] = $fieldType;
                $fieldArray[$fieldName]['fieldname'] = $fieldName;
                $fieldArray[$fieldName]['fieldlabel'] = vtranslate($fieldName,'GeoTools'); 
                $fieldArray[$fieldName]['fieldid'] = $row[$fieldName];
                if($fieldType == 'field') {
                    $fieldArray[$fieldName]['fieldidlabel'] = $this->getLabel($row[$fieldName]);
                    $fieldArray[$fieldName]['select'] = $this->getFieldSelect($row['tabid'], $row['modname'], $row[$fieldName]);
                } else if($fieldType == 'icon') {
                    $fieldArray[$fieldName]['radio'] = $this->getFieldRadio($row[$fieldName]);
                }
                $i++;
            }
            
            $configured_modules[$row['modname']] = $fieldArray;
        }
        return $configured_modules;
    }
    
    /**
     * Funtion to retrieve the field Label for configured fields
     * @param <String>
     */
    public function getLabel($id){
        $db = PearDatabase::getInstance();
        $query = "SELECT fieldlabel FROM vtiger_field
                  WHERE fieldid = ?";
        $arr = explode('.', $str);
        $result = $db->pquery($query, array($id));
        
        return $db->query_result($result, 0, 'fieldlabel');
    }
    
    /**
     * Function to generate the data for the select/option controls 
     * @param <String> $tabid
     * @param <String> $modname
     * @param <String> $geofield
     *  
     * @return <Array> (value=fieldid, label=translated field label, selected=already in $moduleTable for this field)
     */
    protected function getFieldSelect($tabid, $modname="", $geofield="") {
        $db = PearDatabase::getInstance();
        
        if(!$modname) $modname = 'GeoTools';
        
        $query = "SELECT '0' AS fieldid, 'Not Set' AS fieldlabel
                  UNION
                  SELECT fieldid, fieldlabel
                  FROM vtiger_field
                  WHERE uitype IN ('1', '2', '15', '16', '19', '20', '21', '24', '55', '255')
                  AND presence != '1'
                  AND tabid = ?";
        
        $result = $db->pquery($query, array($tabid));
        
        $select = array();
        $i = 0;
        while($row = $db->fetch_array($result)) {
            $select[$i]['value'] = $row['fieldid'];
            $select[$i]['label'] = vtranslate($row['fieldlabel'], $modname);
            if($geofield == $row['fieldid']) {
                $select[$i]['selected'] = 'selected';
            } else {
                $select[$i]['selected'] = '';
            }
            $i++;
        }
        
        return $select;

    }
    
    /**
     * Function to generate data for the Marker Radio Controls
     * @param<String> $selectedmarker
     * @param <String> $modname
     *
     * @return <array> (value=fieldid (marker list), label=translated field label, checked="checked")
     */
    public function getFieldRadio($marker){
        $icons = $this->getIconMarkers();
        $radios = array();
        $i = 0;
        foreach($icons as $icon){
            $radios[$i]['icon'] = $icon;
            if(strrpos($icon, $marker) === false){
                $radios[$i]['checked'] = 0;
            } else {
                $radios[$i]['checked'] = 1;
            }
            $i++;
        }
        return $radios;
    }
    
    /**
     * Function to save Updated GeoTools Module Configuration
     */
    public function saveUpdates() {
        $db = PearDatabase::getInstance();
        $fieldsList = array_keys($this->getFields());
        $tableName = $this->moduleTable;
        $updatedModules = $this->get('updatedModules');
        
        // Get this data into sensible parts for saving into the table.
        foreach($updatedModules as $key => $value){
            list($module, $fieldname) = explode('__', $key);
            $newUpdatedModules[$module][$fieldname] = $value;
        }

        foreach($newUpdatedModules as $module => $fields){
            $tabid = getTabid($module);
            $query = "INSERT INTO $tableName (" . implode(",", $fieldsList) . ") 
                      VALUES('".$tabid."','".$module."','".$fields[$fieldsList[2]]."','".$fields[$fieldsList[3]]."','".$fields[$fieldsList[4]]."','"
                      .$fields[$fieldsList[5]]."','".$fields[$fieldsList[6]]."','".$fields[$fieldsList[7]]."','".$fields[$fieldsList[8]]."','".$fields[$fieldsList[9]]."') 
                      ON DUPLICATE KEY UPDATE ".$fieldsList[0]."=VALUES(".$fieldsList[0]."), ".$fieldsList[1]."=VALUES(".$fieldsList[1]."), ".$fieldsList[2]."=VALUES(".$fieldsList[2]."), ".$fieldsList[3]."=VALUES(".$fieldsList[3]."), ".$fieldsList[4]."=VALUES(".$fieldsList[4]."),".$fieldsList[5]."=VALUES(".$fieldsList[5]."),".$fieldsList[6]."=VALUES(".$fieldsList[6]."),".$fieldsList[7]."=VALUES(".$fieldsList[7]."),".$fieldsList[8]."=VALUES(".$fieldsList[8]."),".$fieldsList[9]."=VALUES(".$fieldsList[9].")";

            $result = $db->pquery($query, array());
            
            if(!$result) {
                $result .= "An error occured saving $module to the database.\n";
            } else {
                $result = true;
            }
        }

        return $result;

    }
    
    /**
     * Function to save a new module into the GeoTools database
     */
    public function saveNewModule() {
        $db = PearDatabase::getInstance();
        $fieldsList = array_keys($this->getFields());
        $tableName = $this->moduleTable;
        $newModule = explode('__',$this->get('newModule'));
        
        $module = $newModule[0];
        $tabid = $newModule[1];
        
        $query = "INSERT INTO $tableName (" . implode(",", $fieldsList) . ") 
                      VALUES('".$tabid."','".$module."','0','0','0','0','0','','','')";
                      
        $result = $db->pquery($query, array()); 
    
        if(!$result) {
            $result = "An error occured saving $module to the database.\n";
        } else {
            $result = true;
        }
        
        return $result;
    }

    /**
     * Function to delete module and geocode records from system
     */
    public function deleteModule() {
        $db = PearDatabase::getInstance();
        $tableName = $this->moduleTable;
        
        $delModule = $this->get('delModule');
        
        
        $query = "DELETE FROM $tableName WHERE modname = ?";
        
        $result = $db->pquery($query, array($delModule));
        
        if(!$result) {
            $result = "An error occured removing $module from the database.\n";
        } else {
            // Module deleted, remove any associated action links
            $linkids = $this->getLinks($delModule);
            foreach($linkids as $linkid) {
                $this->deleteLink($linkid['id']);
            }
            $result = true;
        }
        
        return $result;        
    
    }
    
    public function addActionLink($label, $src, $target = '', $viewname = '') {
        if($label && $src) {
            include_once('vtlib/Vtiger/Module.php');
            $module = Vtiger_Module::getInstance($src);
    
            if ($module != false){
                $url = 'index.php?module=GeoTools&view=GeoTools&src_module=$MODULE$&src_record=$RECORD$';
                if($target) {
                    $url .= "&geotoolsModule=$target";
                }
                if($viewname) {
                    $url .= "&viewname=$viewname";
                }
                $module->deleteLink('DETAILVIEWBASIC', $label, $url);
                $module->addLink('DETAILVIEWBASIC', $label, $url);
                $result = true;
            }
        } else {
            $result = "Data was missing. Unable to save Action Link.";
        }
        
        return $result;
        
    }
    
    /*
     * function to retrieve our Action Links for deletion
     *
    */
    public function getLinks($module) {
        $links = array();
        if($module) {
            $tabid = getTabid($module);
            $db = PearDatabase::getInstance();
            $url = 'index.php?module=GeoTools&view=GeoTools%';
            $query = "SELECT * FROM vtiger_links
                      WHERE tabid = ?
                      AND linktype = 'DETAILVIEWBASIC'
                      AND linkurl LIKE ?";
            $result = $db->pquery($query, array($tabid, $url));
            $i = 0;
            while($row = $db->fetch_array($result)) {
                $links[$i]['id'] = $row['linkid'];
                $links[$i]['label'] = $row['linklabel'];
                $i++;
            }
        }
        return $links;
    }
    
    public function deleteLink($id) {
        if($id) {
            $db = PearDatabase::getInstance();
            $query = "DELETE FROM vtiger_links
                      WHERE linkid = ?
                      LIMIT 1";
            $result = $db->pquery($query, array($id));
            if(!$result) {
                $result = "An error occured deleting the Link";
            } else {
                $result = true;
            }
        }
        
        return $result;
    }
    
    /**
     * Function to retrieve the available Filters for a given module
     * or the default module if not provided
     */
    public function getFilters($module = false) {
        if(!$module) {
            $moduleModel = Vtiger_Module_Model::getInstance(parent::getDefaultModule());
            $module = $moduleModel->getName();
        }
        if($module == 'Events') {
            $module = 'Calendar';
        }
        $CVRecordModels = CustomView_Record_Model::getAll($module);
        $publicFilters = array();
        foreach($CVRecordModels as $index => $filter) {
            if($filter->get('status') == 0 || $filter->get('status') == 3) {
                $publicFilters[$filter->getId()] = $filter->get('viewname');
            }
        }
        return $publicFilters;
    }
    
    
    /**
     * Function to return the count of records coded vs total for given module
     *
     */
    public function getCount($module) {
        $db = PearDatabase::getInstance();
        $tableName = $this->geocodeTable;
        
        $query = "SELECT COUNT(*) AS coded FROM $tableName WHERE module = ? AND (lat IS NOT NULL OR lng IS NOT NULL)";
        $coded = $db->pquery($query, array($module));
        $coded = $db->query_result($coded, 0, 'coded');

        if($module == 'Users') {
            $query = "SELECT COUNT(*) AS total FROM vtiger_users";
            $result = $db->pquery($query, array());
        } else {
            $query = "SELECT COUNT(*) AS total FROM vtiger_crmentity WHERE setype = ? and deleted = 0";
            // Need different query for Leads for converted
            if($module == 'Leads') {
                $query = "SELECT COUNT(*) AS total FROM vtiger_crmentity 
                          INNER JOIN vtiger_leaddetails
                            ON vtiger_leaddetails.leadid = vtiger_crmentity.crmid
                          WHERE setype = ? and deleted = 0 AND converted = 0";
            }
            if($module == 'Events') {
                $result = $db->pquery($query, array('Calendar'));
            } else {
                $result = $db->pquery($query, array($module));
            }
        }

        $total = $db->query_result($result, 0, 'total');
        
        $count = array('coded' => $coded, 'total' => $total);
        return $count;
    }

    /*
     * Function to return suitable Picklists for
     * user to select which to define Market colours
     *
    */
    public function getPicklistsForModule($module) {
        global $log;
        $presence = array('0','2');
        $picklistFieldModels = array();
        
        // Don't want to do this for users
        if($module == 'Users') {
            return $picklistFieldModels;
        }
        
        $moduleModel = Vtiger_Module_Model::getInstance($module);
        $pickListFields = $moduleModel->getFieldsByType(array('picklist'));

        $i = 0;
        foreach($pickListFields as $picklistFieldName => $picklistFieldModel) {
            if(($picklistFieldModel->get('displaytype') != '1' && $picklistFieldName == 'salutationtype') || !in_array($picklistFieldModel->get('presence'),$presence)) {
                continue;
            }
            $picklistFieldModels[$i]['name'] = $picklistFieldName;
            $picklistFieldModels[$i]['model'] = $picklistFieldModel;
            $picklistFieldModels[$i]['values'] = $picklistFieldModel->getPickListValues();
            $i++;
        }

        return $picklistFieldModels;

    }


    /*
     * Function to add new field to module to show if geocoded or not.
     * This needs work - probably need to register an Event Handler or
     * something to keep the value in sync with the geocoder db table
     *
    */
    public function addGeocodedFieldtoModule($moduleName) {
        include_once 'vtlib/Vtiger/Module.php';
        $module = Vtiger_Module::getInstance($moduleName);
        $allBlocks = Vtiger_Block::getAllForModule($module);
        // Get First Block
        $block = $allBlocks[0];
        $field = Vtiger_Field::getInstance('lsisgeocoded', $module);
        if (!$field && $block) {
            $field = new Vtiger_Field();
            $field->name = 'lsisgeocoded';
            $field->column = $field->name;
            $field->label = 'Geocoded';
            $field->columntype = 'VARCHAR(3)';
            $field->uitype = 56;
            $field->typeofdata = 'C~O';
            $field->displaytype = 2;
            $block->addField($field);
        }
    }


    /**
     * Function to get the instance of module model
     * @return <Settings_GeoTools_ModuleEditor_Model> $moduleModel
     */
    public static function getInstance($name = false) {
        $moduleModel = new self();
        return $moduleModel;
    }

}
