<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions
 * All Rights Reserved.
 *************************************************************************************/

class Settings_GeoTools_CoreEditor_Model extends Settings_Vtiger_Module_Model {

    var $baseTable = 'libertus_geotools_settings';
    var $moduleTable = 'libertus_geotools_module_settings';
    var $geocodeTable = 'libertus_geotools';
    var $iconpath = 'modules/GeoTools/assets/markers/centre/';

    var $fields = array(
        'geocoder'      => 'picklist', // Provider of Geocoding Services
		'mapservice'    => 'picklist', // provider of the map tiles
        'rate'          => 'text',     // Rate limit of geocodes per day
        'defaultmod'    => 'picklist', // Default Module records to show on map
        'radius'        => 'text',     // Default Radius of search area
        'distance'      => 'picklist', // Default unit of Distance (Miles or Kms)
        'zoom'          => 'text',     // Defautl Zoom of map
        'mapcentre'     => 'text',     // Manually entered lat/lng
        'companyloc'    => 'text',     // Company Details address as a lat/lng
        'defaultcentre' => 'picklist', // Default choice of map centre
        'iconpath'      => 'icons',    // Where the marker icons are stored
        'listentries'   => 'text',     // Number of list view entries per page
    );

    var $stupidModules = array(
        'Calendar',
        'Dashboard',
        'Emails',
        'Faq',
        'GeoTools',
        'Home',
        'Integration',
        'ModComments',
        'PBXManager',
        'PriceBooks',
        'SMSNotifier',
        'Webmails',
    );

    var $units = array('Kms' => 'Kms', 'Miles' => 'Miles');

    // Options for default map center
    var $defaultcentre = array(
        '1' => 'LBL LAT/LNG ENTRY',
        '2' => 'LBL COMPANY ADDRESS',
        '3' => 'LBL USER ADDRESS', 
        '4' => 'LBL USER LOCATION', 
        '5' => 'LBL OTHER ENTITY RECORD', 
        '6' => 'LBL MANUAL ENTRY',
    );

    var $fallback = '51.212381,-0.791071'; // If all else fails. Only used if no modules configured

    /**
     * Function to get Detail view Url
     * @return <String> Url
     */
    public function getDetailViewUrl() {
        //$menuItem = $this->getMenuItem();
        return '?module=GeoTools&parent=Settings&view=CoreEditorDetail';
    }

    /**
     * Function to get Edit view Url
     * @return <String> Url
     */
    public function getEditViewUrl() {
        //$menuItem = $this->getMenuItem();
        return '?module=GeoTools&parent=Settings&view=CoreEditorEdit';
    }

    /**
     * Function to get fields
     * @return <Array>
     */
    public function getFields() {
        return $this->fields;
    }

    /**
     * Function to get configured default module
     * @return <String>
     */
    public function getDefaultModule() {
        $db = PearDatabase::getInstance();
        $query = "SELECT defaultmod FROM " . $this->baseTable;
        $result = $db->pquery($query, array());

        if($result){
            return $db->query_result($result, 0, 'defaultmod');
        } else {
            return false;
        }
    }

    /**
     * Function to get picklist values
     * @param <String> $fieldName 
     * @return <Array> list of module names or options
     */
    public function getPicklistValues($fieldName = 'defaultmod') {
        if ($fieldName === 'defaultmod') {
			return $this->getModules();
		} elseif ($fieldName === 'distance') {
			return $this->units; 
		} elseif ($fieldName === 'defaultcentre') {
		    return $this->defaultcentre;
		} elseif ($fieldName === 'geocoder') {
		    return GeoTools_Provider_Model::getProvidersInfo('Geocoder');
		} elseif ($fieldName === 'mapservice') {
		    return GeoTools_Provider_Model::getProvidersInfo('Map');
		}
		return array('true', 'false');
	}

	private function getModules() {
            $db = PearDatabase::getInstance();
            $query = "SELECT tabid, modname FROM " . $this->moduleTable;

            $result = $db->pquery($query, array());
            $numOfRows = $db->num_rows($result);

            $data = array();
            for ($i = 0; $i < $numOfRows; $i++) {
                $row = $db->query_result_rowdata($result, $i);
			$data[$row['tabid']] = $row['modname'];
            }
            return $data;
    }

    /**
     * Function to retrieve available centre icon map markers
     * @return <Array> list of icons with path
     */
    function getIconMarkers() {
        $path = $this->iconpath;
        $iconpaths = array();
        if ($handle = opendir($path)) {
            while (false !== ($entry = readdir($handle))) {
                if ($entry != "." && $entry != ".." && $entry != ".svn" && !is_dir($path.'/'.$entry)) {
                    $iconpaths[] = $path . $entry;
                }
            }
        }
        return $iconpaths;
    }
    /**
     * Function to save GeoTools details
     */
    public function save() {
        $db = PearDatabase::getInstance();
        $fieldsList = $this->getFields();
        $tableName = $this->baseTable;

        $updatedFields = $this->get('updatedFields');

   		$validationInfo = $this->validateFieldValues($updatedFields);
		if ($validationInfo === true) {       
            $params = array();
            $query = "UPDATE $tableName SET";
            foreach ($fieldsList as $fieldName => $fieldType) {
                $params[] = $updatedFields[$fieldName];
                $query .= " `$fieldName` = ?, ";
            }
            $query = rtrim($query, ', ');
            $result = $db->pquery($query, $params);
        }
        return $validationInfo;
        
    }

    /*
     * Function setLastRun() called by the cron routine.
     * Update database with today's date
     * 
     */
    function setLastRun() {
        $db = PearDatabase::getInstance();
        $tableName = $this->baseTable;
        $query = "UPDATE $tableName SET lastrun = CURDATE()";
        $result = $db->pquery($query, array());
    }

	public function validateFieldValues($updatedFields) {
	    $msg = false;

	    $rateOptions        = array('options' => array('default' => 0, 'min_range' => 1, 'max_range' => 2500));
	    $radiusOptions      = array('options' => array('default' => 0, 'min_range' => 1));
   	    $zoomOptions        = array('options' => array('default' => 0, 'min_range' => 1, 'max_range' => 12));
   	    $listentriesOptions = array('options' => array('default' => 0, 'min_range' => 10, 'max_range' => 100));

   	    $latlngRegex =  '/^-?([0-8]?[0-9]|90)\.[0-9]{1,7},-?((1?[0-7]?|[0-9]?)[0-9]|180)\.[0-9]{1,7}$/';
   	    $latlngOptions = array('options' => array('default' => 0, 'regexp' => $latlngRegex));
   	    
		if(array_key_exists('rate', $updatedFields) && !filter_var(ltrim($updatedFields['rate'],'0'), FILTER_VALIDATE_INT, $rateOptions)) {
		    $msg = vtranslate('LBL GEOTOOLS INVALID NUM', 'Settings:GeoTools') . ' ' . vtranslate('rate', 'Settings:GeoTools');
		} elseif(array_key_exists('listentries', $updatedFields) && (!filter_var($updatedFields['listentries'], FILTER_VALIDATE_INT, $listentriesOptions) && $updatedFields['listentries'] != 0)) {
		    $msg = vtranslate('LBL GEOTOOLS INVALID NUM', 'Settings:GeoTools') . ' ' . vtranslate('listentries', 'Settings:GeoTools');
		} elseif(array_key_exists('radius', $updatedFields) && !filter_var(ltrim($updatedFields['radius'],'0'), FILTER_VALIDATE_INT, $radiusOptions)) {
		    $msg = vtranslate('LBL GEOTOOLS INVALID NUM', 'Settings:GeoTools') . ' ' . vtranslate('radius', 'Settings:GeoTools');
  		} elseif(array_key_exists('zoom', $updatedFields) && !filter_var(ltrim($updatedFields['zoom'],'0'), FILTER_VALIDATE_INT, $zoomOptions)) {
		    $msg = vtranslate('LBL GEOTOOLS INVALID NUM', 'Settings:GeoTools') . ' ' . vtranslate('zoom', 'Settings:GeoTools');
  		} elseif(array_key_exists('mapcentre', $updatedFields) && !filter_var(ltrim($updatedFields['mapcentre'],'0'), FILTER_VALIDATE_REGEXP, $latlngOptions)) {
  		    $msg = vtranslate('LBL GEOTOOLS INVALID LATLNG', 'Settings:GeoTools') . ' ' . vtranslate('mapcentre', 'Settings:GeoTools');
   		}
        //validation code has been removed for companyloc

        if($msg) {
            return $msg;    
		}

		return true;
	}

    /**
    * Function to get the instance of module model
    * @return <Settings_GeoTools_CoreEditor_Model> $moduleModel
    */
    public static function getInstance($name = false) {
        $moduleModel = new self();
        $db = PearDatabase::getInstance();
        $tableName = $moduleModel->baseTable;

        $result = $db->pquery("SELECT * FROM $tableName", array());
        if ($db->num_rows($result) == 1) {
            $moduleModel->setData($db->query_result_rowdata($result));
        }
        return $moduleModel;
    }

}
