<?php

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_GeoTools_ModuleEditorSaveAjax_Action extends Settings_Vtiger_Basic_Action {

    public function process(Vtiger_Request $request) {
        
        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);
        $mode = $request->get('mode');

        $moduleModel = Settings_GeoTools_ModuleEditor_Model::getInstance();
        
        if($mode == 'addModule') {
            $newModule = $request->get('addNewModule');
            $moduleModel->set('newModule', $newModule);
            $status = $moduleModel->saveNewModule();
            
            if ($status === true) {
                $response->setResult(array($status));
            } else {
                $response->setError(vtranslate($status, $qualifiedModuleName));
            }
        } else if ($mode == 'addAction') {
            $label = $request->get('actionLabel');
            $src = $request->get('sourceModule');
            $target = $request->get('targetModule');
            $filter = $request->get('targetFilter');
            if($target == 'Default Module') {
                $target = false;
            }
            
            $status = $moduleModel->addActionLink($label, $src, $target, $filter);
            if ($status === true) {
                $response->setResult(array($status));
            } else {
                $response->setError(vtranslate($status, $qualifiedModuleName));
            }
        } else if ($mode == 'getFilterList') {
            $target = $request->get('targetModule');
            if($target == 'Default Module') {
                $target = false;
            }

            $filters = $moduleModel->getFilters($target);
            if($filters && is_array($filters)) {
                $response->setResult($filters);
            } else {
                $status = "No filters found";
                $response->setError(vtranslate($status, $qualifiedModuleName));
            }
        } else if ($mode == 'delAction') {
            $linkid = $request->get('deleteLink');
            $status = $moduleModel->deleteLink($linkid);
           
            if ($status === true) {
                $response->setResult(array($status));
            } else {
                $response->setError(vtranslate($status, $qualifiedModuleName));
            }
        } else if ($mode == 'delModule') {
            $delModule = $request->get('deleteModule');
            $moduleModel->set('delModule', $delModule);
            $status = $moduleModel->deleteModule();
            
            if ($status === true) {
                $response->setResult(array($status));
            } else {
                $response->setError(vtranslate($status, $qualifiedModuleName));
            }
        } else if ($mode == 'updateModules') {
            $updatedModules = $request->get('updatedModules');
            $moduleModel->set('updatedModules', $updatedModules);
            $status = $moduleModel->saveUpdates();

            if ($status === true) {
                $response->setResult(array($status));
            } else {
                $response->setError(vtranslate($status, $qualifiedModuleName));
            } 
        } else {
            $response->setError(vtranslate('LBL_GEOTOOLS_ADD_MODULES_INFO_IS_EMPTY', $qualifiedModuleName));
        }
        
        $response->emit();
    }
}
