<?php

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_GeoTools_CoreEditorSaveAjax_Action extends Settings_Vtiger_Basic_Action {

    public function process(Vtiger_Request $request) {
        global $log;
        $log->debug("In Ajax process");
        
        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);
        $moduleModel = Settings_GeoTools_CoreEditor_Model::getInstance();
		$mode = $request->get('mode');

		if($mode == 'saveCoreEditor') {
		    $updatedFields = $request->get('updatedFields');
            if ($updatedFields) {
                $moduleModel->set('updatedFields', $updatedFields);
                $status = $moduleModel->save();
                $log->debug($status);
                if ($status === true) {
                    $response->setResult(array($status));
                } else {
				        $response->setError(vtranslate($status, $qualifiedModuleName));
                }
            } else {
                $response->setError(vtranslate('LBL_FIELDS_INFO_IS_EMPTY', $qualifiedModuleName));
		    }
		} elseif($mode == 'saveProvider') {
		    $log->debug("In saveProvider mode");
		    if($request->get('type') && $request->get('providerid')) {
		    	$values = $request->getAll();
		    	$providerModel = GeoTools_Provider_Model::getInstanceById($request->get('providerid'));		    	
		    	$params = $providerModel->get('params');
		    	$updateValues = false;
		    	foreach($params['req_params'] as $name) {
		    		if($values[$name]) {
		    			$updateValues['req_params'][$name] = $values[$name];
		    		}
		    	}
		    	foreach($params['opt_params'] as $name) {
		    		if($values[$name]) {
		    			$updateValues['opt_params'][$name] = $values[$name];
		    		}
		    	}
		    	if($updateValues) {
		    		$updateValues['providerid'] = $request->get('providerid');
		    	}
		    	$log->debug(print_r($updateValues,true));
		    			  
		    	$status = $providerModel->update($updateValues);
		    }
		    			    	
		    
		    /*
		     *[type] => geocoder
              [providerid] => 3
              [apikey] => 7945734bcb76a67d895e50a644bbf1d3
              [module] => GeoTools
              [parent] => Settings
              [action] => CoreEditorSaveAjax
              [mode] => saveProvider

		     */
		    
		    if ($status === true) {
			    $response->setResult(array($status));
		    } else {
			    $response->setError(vtranslate($status, $qualifiedModuleName));
		    }
        }
        $response->emit();
    }
}
