<?php

/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * Portions created by Libertus Solutions are Copyright (C) Libertus Solutions.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_GeoTools_CoreEditorGeocodeAjax_Action extends Settings_Vtiger_Basic_Action {

    public function process(Vtiger_Request $request) {
        
        // Get the Core Settings Object
        $GeoToolsCoreSettingsModel = Settings_GeoTools_CoreEditor_Model::getInstance();
		$providerModel = GeoTools_Provider_Model::getInstanceById($GeoToolsCoreSettingsModel->get('geocoder'));
		$providerCode = $providerModel->get('code');
		$className = "GeoTools_".$providerCode."GeoCoder_Model";
				        
        $GeoCoder = new $className();
		$GeoCoder->setParams($providerModel->getData());

        $companyQuery = $GeoCoder->generateCompanyQuery();
        $companyAddress = $GeoCoder->getLocations($companyQuery);
        $companyAddress = $companyAddress[0];

        $response = new Vtiger_Response();
        $qualifiedModuleName = $request->getModule(false);
                            
        $result = $GeoCoder->getGeocode($companyAddress);
		$save = false;
        if($result['status'] == 'OK') {
			$save = true;
		}
		if($result['status'] == 'ZERO_RESULTS') {
			// Try with a reduced dataset
			$companyAddress['field_street'] = '';
			$companyAddress['field_state'] = '';
			$result = $GeoCoder->getGeocode($companyAddress);
			if($result['status'] == 'OK') {
				$save = true;
			}
		}
		if($save == true) {
			$GeoCoder->save($result);
            $coords = $result['lat'] . ',' . $result['lng'];
            $response->setResult(array($coords));
        } else {
            $msg = 'LBL GEOTOOLS UNABLE TO GEOCODE ADDRESS';
            $response->setError(vtranslate($msg, $qualifiedModuleName));
        }
        
        $response->emit();
    }
}
