<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/
global $root_directory;
require_once($root_directory."/modules/EmailCampaigns/autoload_wf.php");

class Settings_EmailCampaigns_EmailCampaignDetails_View extends Settings_Vtiger_Index_View {

	public function process(Vtiger_Request $request) {

		$adb = PearDatabase::getInstance();
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$qualifiedName = $request->getModule(false);
		$data = array();

		$query = "select * from vtiger_emailcampaign_setting where id = 1";
		$result = $adb->query($query);
		if($adb->num_rows($result) > 0){
			$batch = $adb->query_result($result,0,'batch');
			$interval = $adb->query_result($result,0,'interval');
            $unsubscribed = $adb->query_result($result,0,'unsubscribed');
            $subscribed = $adb->query_result($result,0,'subscribed');
			$data = array('batch' => $batch,'interval' => $interval,'unsubscribed'=>$unsubscribed,'subscribed'=>$subscribed);
			$viewer->assign('DATA', $data);
		} else {
			$viewer->assign('DATA', $data);
		}

		$outgoingserverdetail = array();
		$query = "select * from vtiger_emailcampaign_outgoingserverdetail where id = 1";
		$result = $adb->query($query);
		if($adb->num_rows($result) > 0){
            $istrackingenabled = $adb->query_result($result,0,'istrackingenabled');
            $issaveemail = $adb->query_result($result,0,'issaveemail');
            $isremoveduplicate = $adb->query_result($result,0,'isremoveduplicate');
            
            $mapping_cont_id = $adb->query_result($result,0,'mapping_cont');
            $mapping_cont_lbl = $adb->pquery("SELECT fieldlabel FROM vtiger_field where fieldid=?",array($mapping_cont_id))->fields['fieldlabel'];
            $mapping_acc_id = $adb->query_result($result,0,'mapping_acc');
            $mapping_acc_lbl = $adb->pquery("SELECT fieldlabel FROM vtiger_field where fieldid=?",array($mapping_acc_id))->fields['fieldlabel'];
            $mapping_lead_id = $adb->query_result($result,0,'mapping_lead');
            $mapping_lead_lbl = $adb->pquery("SELECT fieldlabel FROM vtiger_field where fieldid=?",array($mapping_lead_id))->fields['fieldlabel'];

			$outgoingserverdetail = array('istrackingenabled'=>$istrackingenabled,"issaveemail"=>$issaveemail,"isremoveduplicate"=>$isremoveduplicate,'mapping_cont'=>$mapping_cont_lbl,'mapping_acc'=>$mapping_acc_lbl,'mapping_lead'=>$mapping_lead_lbl);
			$viewer->assign('OUTGOINGSERVERDETAIL', $outgoingserverdetail);
		} else {
			$outgoingserverdetail = array('istrackingenabled'=>1,"issaveemail"=>0,"isremoveduplicate"=>0);
			$viewer->assign('OUTGOINGSERVERDETAIL', $outgoingserverdetail);
		}

		$moduleModel = Vtiger_Module_Model::getInstance("EmailCampaigns");
    	
    	$as2df = new \EmailCampaigns\SWExtension\GenKey("EmailCampaigns", $moduleModel->version);
    
    	if(false === $as2df->g2cf6f21f6f16ffceae4870055decae0a9a427c81()) {
      		$viewer->assign('LICENSE', 'false');
    	}else{
      		$viewer->assign('LICENSE', 'true');
    	}


		$viewer->assign('VIEW', $action);
		$viewer->assign('MODULE', $moduleName);
		$viewer->assign('QUALIFIED_MODULE', 'EmailCampaigns');

		echo $viewer->view('ListContents.tpl', $qualifiedName,true);
	}
}