<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Settings_EmailCampaigns_EditEmailCampaignSettings_View extends Settings_Vtiger_Index_View {

	public function process(Vtiger_Request $request) {
		$adb = PearDatabase::getInstance();
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$qualifiedName = $request->getModule(false);
		$data = array();

		$query = "select * from vtiger_emailcampaign_setting where id = 1";
		$result = $adb->query($query);
		if($adb->num_rows($result) > 0){
			$batch = $adb->query_result($result,0,'batch');
			$interval = $adb->query_result($result,0,'interval');
			$unsubscribed = $adb->query_result($result,0,'unsubscribed');
            $subscribed = $adb->query_result($result,0,'subscribed');
			$data = array('batch' => $batch,'interval' => $interval,'unsubscribed'=>$unsubscribed,'subscribed'=>$subscribed);
			$viewer->assign('DATA', $data);
		} else {
			$viewer->assign('DATA', $data);
		}

		$outgoingserverdetail = array();
		$query = "select * from vtiger_emailcampaign_outgoingserverdetail where id = 1";
		$result = $adb->query($query);
		if($adb->num_rows($result) > 0){
		
			$istrackingenabled = $adb->query_result($result,0,'istrackingenabled');
            $issaveemail = $adb->query_result($result,0,'issaveemail');
            $isremoveduplicate = $adb->query_result($result,0,'isremoveduplicate');
            $mapping_cont_id = $adb->query_result($result,0,'mapping_cont');
            $mapping_acc_id = $adb->query_result($result,0,'mapping_acc');
            $mapping_lead_id = $adb->query_result($result,0,'mapping_lead');

			$outgoingserverdetail = array('istrackingenabled'=>$istrackingenabled,"issaveemail"=>$issaveemail,"isremoveduplicate"=>$isremoveduplicate);

			$viewer->assign('OUTGOINGSERVERDETAIL', $outgoingserverdetail);
		} else {
			$outgoingserverdetail = array('istrackingenabled'=>1,"issaveemail"=>1,"isremoveduplicate"=>1);
			$viewer->assign('OUTGOINGSERVERDETAIL', $outgoingserverdetail);
		}


		$query = "select fieldlabel,fieldid from vtiger_field where uitype = 13 and tabid=4";
		$contactfields = $adb->query($query);
		$cfields = array();
		while($row = $adb->fetch_array($contactfields)){
			$cfields[] =array("label"=>$row["fieldlabel"],"id"=>$row["fieldid"]);
		}

		$query = "select fieldlabel,fieldid from vtiger_field where uitype = 13 and tabid=6";
		$accountfields = $adb->query($query);
		$afields = array();
		while($row = $adb->fetch_array($accountfields)){
			$afields[] =array("label"=>$row["fieldlabel"],"id"=>$row["fieldid"]);
		}

		$query = "select fieldlabel,fieldid from vtiger_field where uitype = 13 and tabid=7";
		$leadfields = $adb->query($query);
		$lfields = array();
		while($row = $adb->fetch_array($leadfields)){
			$lfields[] =array("label"=>$row["fieldlabel"],"id"=>$row["fieldid"]);
		}

		$viewer->assign('cfields', $cfields);
		$viewer->assign('cfields_selected', $mapping_cont_id);
		$viewer->assign('afields', $afields);
		$viewer->assign('afields_selected', $mapping_acc_id);
		$viewer->assign('lfields', $lfields);
		$viewer->assign('lfields_selected', $mapping_lead_id);



		$detail_view_url = "?module=EmailCampaigns&parent=Settings&view=EmailCampaignDetails";
		$viewer->assign('DETAIL_VIEW_URL', $detail_view_url);
		$viewer->assign('VIEW', $action);
		$viewer->assign('MODULE', $moduleName);
		//$viewer->assign('QUALIFIED_MODULE', 'Settings:Vtiger');
		$viewer->assign('QUALIFIED_MODULE', 'EmailCampaigns');

		echo $viewer->view('EditContents.tpl', $qualifiedName,true);
	}
}