<?php
include_once('modules/Vtiger/CRMEntity.php');

class SecurityManager extends Vtiger_CRMEntity {

  public function vtlib_handler($moduleName, $eventType) {

    if ($eventType == 'module.postinstall') {

      $this->initialSettings();
      $this->handlePackaged();
      $this->addFields();
      $this->setMenu();
    }
    elseif($eventType == 'module.postupdate') {

      // TODO Handle actions after this module is updated.
    } 
  }

  private function addFields()  {

    Vtiger_Utils::AddColumn('vtiger_loginhistory', 'browser', 'varchar(25) DEFAULT NULL');
    Vtiger_Utils::AddColumn('vtiger_loginhistory', 'unblock', 'tinyint(1) DEFAULT 0');
  }

  private function initialSettings() {

    global $adb;

    // initial settings
    $adb->pquery("INSERT INTO `vtiger_bruteforce` (`attempsnumber`, `timelock`, `active`) VALUES ('5', '5', '1');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('min_length', '6');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('max_length', '12');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('small_letters', 'true');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('big_letters', 'true');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('numbers', 'true');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('special', 'true');");
    $adb->pquery("INSERT INTO `vtiger_password` (`type`, `val`) VALUES ('pass_expire', '30');");
  }

  private function setMenu() {

    global $adb;

    $securityManagerResult = $adb->pquery('SELECT blockid FROM vtiger_settings_blocks WHERE label=?', array('LBL_SECURITY_MANAGEMENT'));

    // create if not found
    if ($adb->num_rows($securityManagerResult)) {

      // nothing
    }
    else {

      $securityManagerBlockId = $adb->getUniqueID('vtiger_settings_blocks');
      $adb->pquery('INSERT INTO vtiger_settings_blocks(blockid, label, sequence) VALUES(?, ?, ?)', array($securityManagerBlockId, 'LBL_SECURITY_MANAGEMENT', 10));
    }

    $linkName = 'LBL_PASSWORD_CONF';
    $linkURL = 'index.php?module=Password&parent=Settings&view=Index';

    // $moduleName not given ->  menu item LBL_OTHER_SETTINGS
    vtlib_addSettingsLink($linkName, $linkURL, 'LBL_SECURITY_MANAGEMENT');

    $linkName = 'LBL_BRUTEFORCE';
    $linkURL = 'index.php?module=BruteForce&parent=Settings&view=Show';

    // $moduleName not given ->  menu item LBL_OTHER_SETTINGS
    vtlib_addSettingsLink($linkName, $linkURL, 'LBL_SECURITY_MANAGEMENT');
  }

  private function handlePackaged() {

    $packagedFiles = array(
                           array('src' => 'Login.tpl',
                                 'dst' => 'Login.tpl',
                                 'path' => 'layouts/v7/modules/Users/'
                           ),
                           array('src' => 'Detail.js',
                                 'dst' => 'Detail.js',
                                 'path' => 'layouts/v7/modules/Users/resources/'
                           ),
                           array('src' => 'Forcechangepopup.php',
                                 'dst' => 'Forcechangepopup.php',
                                 'path' => 'modules/Users/views/'
                           ),
                           array('src' => 'Forcechangepopup.php',
                                 'dst' => 'Forcechangepopup.php',
                                 'path' => 'modules/Users/views/'
                           ),
                           array('src' => 'Forcechange.php',
                                 'dst' => 'Forcechange.php',
                                 'path' => 'modules/Users/views/'
                           ),
                           array('src' => 'UsersLogin.php',
                                 'dst' => 'Login.php',
                                 'path' => 'modules/Users/views/'
                           ),
                           array('src' => 'SaveAjax.php',
                                 'dst' => 'SaveAjax.php',
                                 'path' => 'modules/Users/actions/'
                           ),
                           array('src' => 'ActionsLogin.php',
                                 'dst' => 'Login.php',
                                 'path' => 'modules/Users/actions/'
                           ),
                           array('src' => 'Module.php',
                                 'dst' => 'Module.php',
                                 'path' => 'modules/Users/models/'
                           ),
                           array('src' => 'LanguageHandler.php',
                                 'dst' => 'LanguageHandler.php',
                                 'path' => 'includes/runtime/'
                           ),
                           array('src' => 'UsersVEBCustom.php',
                                 'dst' => 'UsersVEBCustom.php',
                                 'path' => 'languages/nl_nl/'
                           ),
                           array('src' => 'VtigerVEBCustom.php',
                                 'dst' => 'VtigerVEBCustom.php',
                                 'path' => 'languages/nl_nl/Settings/'
                           )
       );

    foreach($packagedFiles as $packagedFile) {

      // test if directory exists
      if (!file_exists($packageFile['path'])) mkdir($packageFile['path'], 0755, true);

      if (file_exists($packagedFile['path'] . $packagedFile['dst'])) {

        // check the hash
        $sha1org = sha1_file('modules/SecurityManager/packaged/' . $packagedFile['src']);
        $sha1dst = sha1_file($packagedFile['path'] . $packagedFile['dst']);

        // no overwrite needed if hash is equal
        if ($sha1org == $sha1dst) continue;

        if (file_exists($packagedFile['path'] . $packagedFile['dst'] . '.orig')) {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '_before' . date('Ymd'));
        }
        else {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '.orig');
        }
      }

      // ok to override
      $src = 'modules/SecurityManager/packaged/' . $packagedFile['src'];
      $dst = $packagedFile['path'] . $packagedFile['dst'];
      copy($src, $dst);
    }
  }
}
