<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

/**
 * Vtiger Module Model Class
 */
class Relations_Module_Model extends Vtiger_Module_Model {

        protected $blocks = false;
        protected $nameFields = false;
        protected $moduleMeta = false;
        protected $fields = false;
        protected $relations = null;


        /**
         * Function to save a given record model of the current module
         * @param Relations_Record_Model $recordModel
         */
        public function saveRecord(Relations_Record_Model $recordModel) {

                global $adb;
                $moduleName = $this->get('name');
                $focus = $recordModel->getEntity();
                $fields = $focus->column_fields;

                foreach($fields as $fieldName => $fieldValue) {

                        $fieldValue = $recordModel->get($fieldName);

                        if(is_array($fieldValue)) {

                                $focus->column_fields[$fieldName] = $fieldValue;
                        }
			elseif ($fieldValue !== null) {

                                /*
                                 * for ajax edit, in Vtiger_SaveAjax_Action we are setting relatedContact to 
                                 * the record model which is an object
                                 * Note : decode_html expects only strings
                                 */
                                $value = is_string($fieldValue) ? decode_html($fieldValue) : $fieldValue;
                                $focus->column_fields[$fieldName] = $value;
                        }
                }

                $focus->mode = $recordModel->get('mode');
                $focus->id = $recordModel->getId();
                $focus->save($moduleName);

                //Technokrafts -- Starts
                $entityId1 = $fields['actor_a'];
                $entityId2 = $fields['actor_b'];

                if(($entityId1 || $entityId2) && $focus->id) {

                        $adb->pquery("DELETE FROM vtiger_crmentityrel WHERE crmid = ? OR relcrmid = ?", array($focus->id, $focus->id));

                        if($entityId1) {

                                $result         = $adb->pquery("SELECT setype FROM vtiger_crmentity WHERE crmid=?", array($entityId1));
                                $setype         = $adb->query_result($result,0,"setype");
                                $on_focus       = CRMEntity::getInstance('Relations');
                                $no             = $entityId1;
                                $on_focus->save_related_module('Relations',$focus->id, $setype, $no);
                                unset($result);
                        }

                        if($entityId2) {

                                $result         = $adb->pquery("SELECT setype FROM vtiger_crmentity WHERE crmid=?", array($entityId2));
                                $setype         = $adb->query_result($result,0,"setype");
                                unset($result);
                                $on_focus       = CRMEntity::getInstance('Relations');
                                $no             = $entityId2;
                                $on_focus->save_related_module('Relations',$focus->id, $setype, $no);
                        }
                }
                //Technokrafts -- Ends

                return $recordModel->setId($focus->id);
        }

        public function getModuleIcon() {

                $moduleName = $this->getName();
                $lowerModuleName = strtolower($moduleName);
                $title = vtranslate($moduleName, $moduleName);

                $moduleIcon = "<i class='vicon-$lowerModuleName' title='$title'></i>";

                if ($this->source == 'custom') {

                        $moduleShortName = mb_substr(trim($title), 0, 2);
                        $moduleIcon = "<i class='vicon-meeting' title='$title'></i>";
                }

                $imageFilePath = 'layouts/'.Vtiger_Viewer::getLayoutName()."/modules/$moduleName/$moduleName.png";

                if (file_exists($imageFilePath)) {

                        $moduleIcon = "<img src='$imageFilePath' title='$title' style='width: 35px;margin: -5px;'  />";
                }

                return $moduleIcon;
        }
}
