<?php
/* ***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ************************************************************************************/

class RelationHandler extends VTEventHandler {

	function handleEvent($eventName, $entityData) {

		$moduleName = $entityData->getModuleName();

		if ($eventName == 'vtiger.lead.convertlead' && $moduleName == 'Leads') {

		 	// need to figure out the relations for this Lead
			RelationHandler::handleLeadRelation($entityData);
		}
	}

	/*
	 * Wel relevant is welke vinkjes hier worden gezet (Acc + Con + Pot? )
	 *
	 * Als Actor A wordt geconverteerd:
	 * Gaat de relatie van Lead (Meestal Actor A) naar ACC + CON + POT (dus worden dan 3 relation lines in de database!). 
	 * Actor B blijft gelijk.
	 *
	 * Als Actor B wordt geconverteerd:
	 * Gaat de relatie van Lead (Actor B) naar ACC + CON + POT (dus worden dan 3 relation lines in de database!). 
	 * Actor A blijft gelijk.
	 */
	function handleLeadRelation($entityData) {

		global $adb;

		// record id converted lead
		$convertedLeadId = $entityData->getId();

		// core code aanpassing!
		$entityIds = $entityData->getEntityIds();

		// need to figure out if relation exists for this lead id (can be either actor_a or actor_b)
		$query = 'SELECT * FROM vtiger_relations WHERE actor_a = ? OR actor_b = ?';
		$params = array($convertedLeadId, $convertedLeadId);
		$result = $adb->pquery($query,$params);

                if ($adb->num_rows($result) == 0) {

			// nothing to do
			return;
		}

		$rows = array();
		while($row = $adb->fetchByAssoc($result)) {
			$rows[] = $row;
		}

		// could be multiple relations
		foreach($rows as $row) {

                        // so update it and create the rest if needed
			/*
			 *  'entityIds' => 
  			 * array (
   	 		 *	'Accounts' => '11x85',
			 *	'Contacts' => '12x86',
			 *	'Potentials' => '13x87',
			 * ),
			 */
                        $index = 0;

                	foreach($entityIds as $moduleName => $entityId) {

				list($wsModuleId, $recordId) = explode('x', $entityId);

				$focus = CRMEntity::getInstance('Relations');

				if ($index == 0) {

					$focus->retrieve_entity_info($row['relationsid'], 'Relations');

					$focus->mode = 'edit';
					$focus->id = $row['relationsid'];

					// remove the existing relations for this relationsid
                        		$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE crmid = ? OR relcrmid = ?", array($focus->id, $focus->id));

					$index += 1;
				}
				else {

					foreach($row as $fieldname => $value) {

						$focus->column_fields[$fieldname] = $value;
					}
				}

				if ($row['actor_a'] == $convertedLeadId) {

				        $focus->column_fields['actor_a'] = $recordId;
					$reverseId = $focus->column_fields['actor_b'];
				}

				if ($row['actor_b'] == $convertedLeadId) {

				        $focus->column_fields['actor_b'] = $recordId;
					$reverseId = $focus->column_fields['actor_a'];
				}

                                // and save it
				$focus->saveentity('Relations');

				// get it to the related list table vtiger_crmentityrel
				// from converted entity to relations
                                $focus->save_related_module('Relations', $focus->id, $moduleName, $recordId);

				// from the entity related to in relations
                                $result = $adb->pquery("SELECT setype FROM vtiger_crmentity WHERE crmid=?", array($reverseId));
                                $seType = $adb->query_result($result,0,"setype");
                                $focus->save_related_module('Relations', $focus->id, $seType, $reverseId);
			}
		}
	}

}

