<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class Relations extends Vtiger_CRMEntity {
    var $table_name = 'vtiger_relations';
    var $table_index= 'relationsid';

    /**
     * Mandatory table for supporting custom fields.
     */
    var $customFieldTable = array('vtiger_relationscf', 'relationsid');

    /**
     * Mandatory for Saving, Include tables related to this module.
     */
    var $tab_name = array('vtiger_crmentity', 'vtiger_relations', 'vtiger_relationscf');

    /**
     * Mandatory for Saving, Include tablename and tablekey columnname here.
     */
    var $tab_name_index = array(
        'vtiger_crmentity' => 'crmid',
        'vtiger_relations' => 'relationsid',
        'vtiger_relationscf'=>'relationsid');

    /**
     * Mandatory for Listing (Related listview)
     */
    var $list_fields = array (
        'LBL_REL_NO' => array('relations', 'rel_no'),
        'LBL_ACTOR_A' => array('relations', 'actor_a'),
        'LBL_ACTOR_B' => array('relations', 'actor_b'),
        'LBL_RELATION_TYPE' => array('relations', 'relation_type'),
        'LBL_ENDDATE' => array('relations', 'enddate'),

    );
    var $list_fields_name = array (
        'LBL_REL_NO' => 'rel_no',
        'LBL_ACTOR_A' => 'actor_a',
        'LBL_ACTOR_B' => 'actor_b',
        'LBL_RELATION_TYPE' => 'relation_type',
        'LBL_ENDDATE' => 'enddate',

    );

    // Make the field link to detail view
    var $list_link_field = '';

    // For Popup listview and UI type support
    var $search_fields = array(
        'LBL_REL_NO' => array('relations', 'rel_no'),
        'LBL_ACTOR_A' => array('relations', 'actor_a'),
        'LBL_ACTOR_B' => array('relations', 'actor_b'),
        'LBL_RELATION_TYPE' => array('relations', 'relation_type'),
        'LBL_ENDDATE' => array('relations', 'enddate'),

    );
    var $search_fields_name = array (
        'LBL_REL_NO' => 'rel_no',
        'LBL_ACTOR_A' => 'actor_a',
        'LBL_ACTOR_B' => 'actor_b',
        'LBL_RELATION_TYPE' => 'relation_type',
        'LBL_ENDDATE' => 'enddate',

    );

    // For Popup window record selection
    var $popup_fields = array ('');

    // For Alphabetical search
    var $def_basicsearch_col = '';

    // Column value to use on detail view record text display
    var $def_detailview_recname = '';

    // Used when enabling/disabling the mandatory fields for the module.
    // Refers to vtiger_field.fieldname values.
    var $mandatory_fields = array('','assigned_user_id');

    var $default_order_by = '';
    var $default_sort_order='ASC';

    /**
    * Invoked when special actions are performed on the module.
    * @param String Module name
    * @param String Event Type
    */
    function vtlib_handler($moduleName, $eventType) {

        global $adb;

         if($eventType == 'module.postinstall') {

            // TODO Handle actions after this module is installed.
            $entity= new CRMEntity();
            $entity->setModuleSeqNumber('configure', 'Relations', 'REL', 1);

            // Mark the module as Standard module
            $adb->pquery('UPDATE vtiger_tab SET customized=0 WHERE name=?', array($moduleName));
             
            $relationsInstance = Vtiger_Module::getInstance('Relations');

            //adds sharing accsess
            Vtiger_Access::setDefaultSharing($relationsInstance);

            // get relation field to actor_a
            $relationsFieldInstance = Vtiger_Field_Model::getInstance('actor_a', $relationsInstance);
            $fieldId = $relationsFieldInstance->getId();

            // accounts related tab
            $relatedInstance = Vtiger_Module::getInstance('Accounts');
            $relatedInstance->setRelatedlist($relationsInstance, 'Relations', array(ADD), 'get_related_list',$fieldId);

            // contacts related tab
            $relatedInstance = Vtiger_Module::getInstance('Contacts');
            $relatedInstance->setRelatedlist($relationsInstance, 'Relations', array(ADD), 'get_related_list',$fieldId);

            // leads related tab
            $relatedInstance = Vtiger_Module::getInstance('Leads');
            $relatedInstance->setRelatedlist($relationsInstance, 'Relations', array(ADD), 'get_related_list',$fieldId);

            // potentials related tab
            $relatedInstance = Vtiger_Module::getInstance('Potentials');
            $relatedInstance->setRelatedlist($relationsInstance, 'Relations', array(ADD), 'get_related_list', $fieldId);

            // the update tab
            $relationsTabId = $relationsInstance->getId();
            $adb->pquery("INSERT INTO `vtiger_modtracker_tabs` (`tabid`, `visible`) VALUES (?, ?);", array($relationsTabId,1));

            // modcomments on summary tab
            $modCommentsInstance = Vtiger_Module::getInstance('ModComments');
            $modCommentsFieldInstance = Vtiger_Field_Model::getInstance('related_to', $modCommentsInstance);
            $fieldId = $modCommentsFieldInstance->getId();

            $adb->pquery("INSERT INTO `vtiger_fieldmodulerel` (`fieldid`, `module`, `relmodule`, `status`, `sequence`)
                          VALUES (?, 'ModComments', 'Relations', NULL, NULL);", array($fieldId));

            // registering event handler for converting a lead
            $em = new VTEventsManager($adb);
            $em->registerHandler('vtiger.lead.convertlead', 'modules/Relations/handlers/RelationHandler.php', 'RelationHandler');

        } else if($eventType == 'module.disabled') {
            // TODO Handle actions before this module is being uninstalled.
        } else if($eventType == 'module.preuninstall') {
            // TODO Handle actions when this module is about to be deleted.
        } else if($eventType == 'module.preupdate') {
            // TODO Handle actions before this module is updated.
        } else if($eventType == 'module.postupdate') {
            //Delete duplicates from all picklist
            static::deleteDuplicatesFromAllPickLists($moduleName);
        }        
     }

    /**
     * Delete doubloons from all pick list from module
     */
    public static function deleteDuplicatesFromAllPickLists($moduleName)
    {
        global $adb,$log;

        $log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...START");

        //Deleting doubloons
        $query = "SELECT columnname FROM `vtiger_field` WHERE uitype in (15,16,33) "
                . "and tabid in (select tabid from vtiger_tab where name = '$moduleName')";
        $result = $adb->pquery($query, array());

        $a_picklists = array();
        while($row = $adb->fetchByAssoc($result))
        {
            $a_picklists[] = $row["columnname"];
        }
        
        foreach ($a_picklists as $picklist)
        {
            static::deleteDuplicatesFromPickList($picklist);
        }
        
        $log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...DONE");
    }
    
    public static function deleteDuplicatesFromPickList($pickListName)
    {
        global $adb,$log;
        
        $log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...START");
    
        //Deleting doubloons
        $query = "SELECT {$pickListName}id FROM vtiger_{$pickListName} GROUP BY {$pickListName}";
        $result = $adb->pquery($query, array());
    
        $a_uniqueIds = array();
        while($row = $adb->fetchByAssoc($result))
        {
            $a_uniqueIds[] = $row[$pickListName.'id'];
        }
    
        if(!empty($a_uniqueIds))
        {
            $query = "DELETE FROM vtiger_{$pickListName} WHERE {$pickListName}id NOT IN (".implode(",", $a_uniqueIds).")";
            $adb->pquery($query, array());
        }
        
        $log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...DONE");
    }
}
