<?php

/* A function to take a date in ($date) in specified date() format (eg mm/dd/yy for 12/08/10) and 
 * return date in $outFormat (eg d.m.Y for 20.10.1208; )
 *  datum $date - Datum containing the literal date that will be modified
 *  string $outFormat - String containing the desired date output, format the same as date()
 * 
 * [CUSTOMFUNCTION|veb_years_since|$year|CUSTOMFUNCTION]
 */

if (!function_exists('veb_years_since')) {

    /**
     * @param string $date
     * @param string $outFormat
     * @return string
     * @throws Exception
     */
    function veb_years_since($year)
    {
        if ($year) {
            if (strlen($year) < 2) {
                $year = "20".$year;
            }

            return date("Y") - $year;
        }

        return '';
    }
}
