<?php
/**
 * [CUSTOMFUNCTION|veb_getInternalInfo|$QUOTES_CRMID$|intro|14px|CUSTOMFUNCTION]
 */

global $renvooi;

// ===========================================================================
/**
 * This function returns HTML representation of textfield
 *  
 * @param $crmid	ID of the CRM entity
 * @param $size			(optional) font size - default 12px
 * @return	string containing formatted textblock
 **/ 
function veb_getInternalInfo($crmid,$size = '12px')
{
	global $adb, $PDFMaker_template_id;
	global $renvooi;

	if (!$renvooi) return "";

	$return = "";
	
	// get name of the partner from the potential
	
	$aPot = veb_getInternal_POT($crmid);

	$aAcc = veb_getInternal_ACC($crmid);
	$aQuo = veb_getInternal_QUO($crmid);
	$aRel = veb_getInternal_REL($crmid);
	
	// add text
	$return = "";
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><td style=\"border: 1px solid red;\">";
	$return .= '<h1 style="color: red;">INTERNE INFORMATIE</h1>';
	
	$return .= '<h2 style="color: red;">Interesse/Omgeving:</h2>';
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><th>ACC</th><th width=150 >King versie</th><td width=650 >{$aAcc['c_king_details']}</td></tr>";
	$return .= "<tr><th>POT</th><th>Interesse</th><td>{$aPot['c_lead_solutions']}/{$aPot['c_lead_products']}</td></tr>";
	$return .= "<tr><th>ACC</th><th>Concurrentiesituatie</th><td>{$aAcc['c_competitive']}</td></tr>";	
	$return .= "</table>";

	$return .= '<h2 style="color: red;">Prospect:</h2>';
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><th>ACC</th><th width=150 >Branche</th><td width=650 >{$aAcc['c_industry_particular']}</td></tr>";
	$return .= "<tr><th>ACC</th><th>Accountplan</th><td>{$aAcc['c_accountplan']}</td></tr>";
	$return .= "<tr><th>ACC</th><th>Omzettotaal (all year)</th><td>{$aAcc['c_total_revenue']}</td></tr>";
	$return .= "</table>";


	$return .= '<h2 style="color: red;">Commercieel:</h2>';
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><th>ACC</th><th width=150 >King-dealer</th><td>{$aPot['kingdealer']}</td></tr>";
	$return .= "<tr><th>POT</th><th width=150 >Commissiepartner</th><td width=650>{$aPot['c_commisionpartner']}</td></tr>";
	$return .= "<tr><th>POT</th><th width=150 >Lead bron</th><td width=650>{$aPot['leadsource']} {$aPot['c_lead_source_bg']}</td></tr>";
	
	$return .= "<tr><th>QUO</th><th width=150 >Provisieafspraken</th><td width=650>".nl2br($aQuo['c_commision_agreements'])."</td></tr>";
	$return .= "<tr><th>QUO</th><th>Contractafspraken</th><td>".nl2br($aQuo['c_contract_agreements'])."</td></tr>";
	$return .= "</table>";

	$return .= '<h2 style="color: red;">Notities:</h2>';
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><th>ACC</th><th width=150 >Notities</th><td width=650>".nl2br($aAcc['c_initiative_notes'])."</td></tr>";
	$return .= "<tr><th>POT</th><th>Notities</th><td>".nl2br($aPot['c_initiative_notes'])."</td></tr>";
	$return .= "</table>";

	$return .= '<h2 style="color: red;">Relaties:</h2>';
	$return .= "<table border=1 width=100% style=\"width: 100%;\">";
	$return .= "<tr><th>REL</th><th width=150 >Notities</th><td width=650>".print_r($aRel, true)."</td></tr>";
	$return .= "</table>";	

//	$return .= "<table border=1 style=\"width: 100%;\">";
//	$return .= "<tr><th>ACC</th><td>".print_r($aAcc, true)."</td></tr>";	
//	$return .= "<tr><th>POT</th><td>".print_r($aPot, true)."</td></tr>";
//	$return .= "<tr><th>QUO</th><td>".print_r($aQuo, true)."</td></tr>";
//	$return .= "</table>";
	$return .= "</td></tr>";
	$return .= "</table>";
	
	return $return;
}


function veb_getInternal_ACC($crmid)
{
	global $adb;
	
	// get switches from object
	$result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
	$row = $adb->fetchByAssoc($result);
	$my_focus = CRMEntity::getInstance($row['setype']);
	$my_focus->id = $crmid;
	$my_focus->retrieve_entity_info($crmid,$row['setype']);
	
	$fields = $my_focus->column_fields;

	unset($my_focus,$result,$row);
	
	if (!$fields['account_id']) die('- Er is geen Account gekoppeld, maak deze eerst aan');
	
	$sql="SELECT * FROM vtiger_account WHERE accountid=?";
	$result2 = $adb->pquery($sql,array($fields['account_id']));
	$data = $adb->fetchByAssoc($result2);

//	print_r($data);
	
	unset ($sql, $fields, $result2);
	
	return $data;
}


function veb_getInternal_POT($crmid)
{
	global $adb;
	
	// get switches from object
	$result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
	$row = $adb->fetchByAssoc($result);
	
	$my_focus = CRMEntity::getInstance($row['setype']);
	$my_focus->id = $crmid;
	$my_focus->retrieve_entity_info($crmid,$row['setype']);
	
	$fields = $my_focus->column_fields;

	unset($my_focus,$result,$row);
	
	if (!$fields['potential_id']) die('- Er is geen Verkoopkans gekoppeld, maak deze eerst aan');
	
	$sql="SELECT * FROM vtiger_potential WHERE potentialid=?";
	$result2 = $adb->pquery($sql,array($fields['potential_id']));
	$data = $adb->fetchByAssoc($result2);

	//	print_r($data);
	
	unset ($sql, $fields, $result2);
	
	return $data;
}

function veb_getInternal_QUO($crmid)
{
	global $adb;
	
	$sql = "SELECT * 
	        FROM vtiger_quotes AS q 
	        INNER JOIN vtiger_quotescf AS qc
	        ON q.quoteid = qc.quoteid 
	        WHERE q.quoteid=$crmid";
	        
//	print $sql;
	$result = $adb->query($sql);
//	print_r($adb);
	$data = $adb->fetchByAssoc($result);
	return $data;
}


function veb_getInternal_REL($crmid)
{
	global $adb;
	
	$sql = "select * from vtiger_relations where actor_a=$crmid OR actor_b=$crmid";
	//print $sql;
	$result = $adb->query($sql);
	$data = $adb->fetchByAssoc($result);
	return $data;
}
