<?php

/**
 *
 * @see veb_layout
 */
if (!function_exists('veb_prepare_url'))
{

    function veb_prepare_url($url, $type)
    {
        $parsed_url = parse_url($url);
        $scheme = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : '';
        $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';
        $port = isset($parsed_url['port']) ? ':' . $parsed_url['port'] : '';
        $user = isset($parsed_url['user']) ? $parsed_url['user'] : '';
        $pass = isset($parsed_url['pass']) ? ':' . $parsed_url['pass'] : '';
        $pass = ($user || $pass) ? "$pass@" : '';
        $path = isset($parsed_url['path']) ? $parsed_url['path'] : '';
        $query = isset($parsed_url['query']) ? '?' . $parsed_url['query'] : '';
        $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : '';

        if ("$scheme$host" == '' && $type = 'img')
        {
            $newurl = 'https://castellum.vicus.nl/img/' . $path;
        } else
        {
            $newurl = "$scheme$user$pass$host$port$path$query$fragment";
        }

        return $newurl;
    }

}

if (!function_exists('veb_url_productflyer'))
{

    function veb_url_productflyer($url, $productid)
    {
        if ($url != '') {
            $link = veb_url_add_trackingcodes($url, array(
                'utm_campaign' => 'pdcflyer', // product/diensten catalogus
                'utm_term' => 'product_'.$productid,
                'productid' => $productid
            ));
            
            return '<a href="'.$link.'">'.$url.'</a>';
        }
        return $url;
    }
}

if (!function_exists('veb_url_serviceflyer'))
{

    function veb_url_serviceflyer($url, $serviceid)
    {
        if ($url != '') {
            $link = veb_url_add_trackingcodes($url, array(
                'utm_campaign' => 'pdcflyer', // product/diensten catalogus
                'utm_term' => 'service_'.$serviceid,
                'serviceid' => $serviceid
            ));
            
            return '<a href="'.$link.'">'.$url.'</a>';
        }
        return $url;
    }
}



/**
 *
 * @see veb_layout
 */
if (!function_exists('veb_url_add_trackingcodes'))
{

    function veb_url_add_trackingcodes($url, $params)
    {
    
    
        $parsed_url = parse_url($url);
        $scheme = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : '';
        $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';
        $path = isset($parsed_url['path']) ? $parsed_url['path'] : '';
        $query = isset($parsed_url['query']) ? $parsed_url['query'] : '';
        $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : '';

        if (substr($scheme, 0, 7) != 'http://' && substr($scheme, 0, 8) != 'https://')
        {
            $scheme = 'https://';
        }

        $newParam = array();
        
        $rawQueryArray = explode('&', $query);
        foreach($rawQueryArray as $idNr => $valueSet) {
            $values = explode('=',$valueSet);
            $id = $values[0];
            $queryArray[$id] = $values[1];
            $newParam[$id] = "$id=".$values[1];
        }

        if ($params['refno'] != '')
        {
            $newParam['refno'] = 'refNo=' . $params['refno'];
        }
        if ($params['accountid'] != '')
        {
            $newParam['wva_accid'] = 'wva_accid=' . $params['accountid'];
        }
        if ($params['contactid'] != '')
        {
            $newParam['wva_conid'] = 'wva_conid=' . $params['contactid'];
            $newParam['cid'] = 'cid=' . $params['contactid'];
        }
        if ($params['quoteid'] != '')
        {
            $newParam['wva_quoid'] = 'wva_quoid=' . $params['quoteid'];
        }
        if ($params['productid'] != '')
        {
            $newParam['productid'] = 'wva_prodid=' . $params['productid'];
        }

        if ($params['serviceid'] != '')
        {
            $newParam['serviceid'] = 'wva_servid=' . $params['serviceid'];
        }

        $newParam['utm_source'] = (isset($queryArray['utm_source']) AND ! empty($queryArray['utm_source']) ) ? 'utm_source=' . $queryArray['utm_source'] : 'utm_source=crm';
        $newParam['utm_medium'] = (isset($queryArray['utm_medium']) AND ! empty($queryArray['utm_medium']) ) ? 'utm_medium=' . $queryArray['utm_medium'] : 'utm_medium=pdf';
        $newParam['utm_campaign'] = (isset($queryArray['utm_campaign']) AND ! empty($queryArray['utm_campaign']) ) ? 'utm_campaign=' . $queryArray['utm_campaign'] : 'utm_campaign=offerte';
        $newParam['utm_content'] = (isset($queryArray['utm_content']) AND ! empty($queryArray['utm_content']) ) ? 'utm_content=' . $queryArray['utm_content'] : 'utm_content=textlink';

        if ($params['utm_campaign'] != '')
        {
            $newParam['utm_campaign'] = 'utm_campaign=' . $params['utm_campaign'];
        }
        if ($params['utm_term'] != '')
        {
            $newParam['utm_term'] = 'utm_term=' . $params['utm_term'];
        }

        $query = '?' . implode('&', $newParam);
        return "$scheme$host$path$query$fragment";
    }

}