<?php

/**
 * [CUSTOMFUNCTION|veb_getTextBlock|$QUOTES_CRMID$|intro|14px|CUSTOMFUNCTION]
 */
global $textblock, $renvooi;

// include_once('veb_pdfm_config.php');
include_once('data_textblocks.inc');

//print_r($textblock);
// ===========================================================================
/**
 * This function returns HTML representation of textfield 
 *  
 * @param $crmid  ID of the CRM entity
 * @param $docSection  section of the document (e.g. conditions, introduction, etc)
 * @param $size      (optional) font size - default 12px
 * @param $ForceNewPage      (optional) to force a new page if something was printed
 * @return  string containing formatted textblock
 * */
function veb_getTextBlock($crmid, $docSection, $size = '12px', $ForceNewPage = False)
{

    global $adb, $textblock, $PDFMaker_template_id, $renvooi;

    // get switches from object
    $result = $adb->query("select setype from vtiger_crmentity where crmid = $crmid");
    $row = $adb->fetchByAssoc($result);
    $my_focus = CRMEntity::getInstance($row['setype']);
    $my_focus->id = $crmid;
    $my_focus->retrieve_entity_info($crmid, $row['setype']);

    $fields = $my_focus->column_fields;

    $pdfmConfig = new pdfmConfig($fields['c_picklist_settings']);

    unset($my_focus, $result, $row);

    if ($fields['quotestage'] == 'Concept renvooi')
    {
        $renvooi = true;
    } else
    {
        $renvooi = false;
    }

    $renvooiTextBlock = true;

    // defaults
    $newText = '';
    $printedSomething = false;

    /** pagebreak: 

     */
//      print_r($fields); die();
    if ($docSection == 'termijnen')
    {
        // if any value
        if (!empty($fields['cf_1883']))
        {
            $printedSomething = true;
            $newText .= '<h3>Toeslag bij termijnbetaling</h3>';
            $newText .= "<p>Als je de jaarkosten in termijnen wilt betalen dan kun je dat hieronder aangeven:</p>";
            if ($fields['cf_1883'] === 'Kwartaal-termijnen')
            {
                $newText .= "<p>&nbsp;&nbsp;&nbsp;[    ] Ik wil de abonnementskosten per kwartaal via FACTUUR betalen en betaal een toeslag van 5%</p>";
            }
            if ($fields['cf_1883'] === 'Maand-termijnen')
            {
                $newText .= "<p>&nbsp;&nbsp;&nbsp;[    ] Ik wil de abonnementskosten per maand via AUTOMATISCHE INCASSO betalen en betaal geen toeslag</p>";
                $newText .= "<p>&nbsp;&nbsp;&nbsp;[    ] Ik wil de abonnementskosten per maand via FACTUUR betalen en betaal een toeslag van 8%</p>";
                $newText .= "<p>&nbsp;&nbsp;&nbsp;[    ] Ik wil de abonnementskosten per kwartaal via FACTUUR betalen en betaal een toeslag van 5%</p>";
            }
//      $newText .= "<br />";
        }
    } elseif (isset($textblock[$docSection]))
    {
        foreach ($textblock[$docSection] as $label => $content)
        {

            if ($pdfmConfig->getPicklistValue($label))
            {
                $printedSomething = true;
                if ($textblock[$docSection][$label]['title'] AND ! empty($textblock[$docSection][$label]['title']))
                {
                    // can be that it is false or empty
                    if ($textblock[$docSection][$label]['level'] == 1 AND ! empty($textblock[$docSection][$label]['level']))
                    {
//                        $newText .= "<pagebreak />"; // we assume we start on a new page see how it ends
// @change lro 250131
		    	$newText .= '[PAGEBREAK]';
                        $newText .= '<h1><bookmark content="' . $textblock[$docSection][$label]['title'] . '" level="0"></bookmark>' . $textblock[$docSection][$label]['title'] . '</h1>';
                    } elseif ($textblock[$docSection][$label]['level'] == 2 AND ! empty($textblock[$docSection][$label]['level']))
                    {
                        $newText .= '<h2><bookmark content="' . $textblock[$docSection][$label]['title'] . '" level="1"></bookmark>' . $textblock[$docSection][$label]['title'] . '</h2>';
                    } else
                    {
                        $newText .= '<h3>' . $textblock[$docSection][$label]['title'] . '</h3>';
                    }
                    // $newText .= '<strong><em>'.$textblock[$docSection][$label]['title'].'</em></strong>';
                }

                // @change lro added if 160324 hope to remove some whitespaces between paragraphs
                // helpt niet (maar schaadt ook niet, dus houden we er toch in)
                if ($textblock[$docSection][$label]['text'] != '')
                {
                    $newText .= veb_getHTMLtext($textblock[$docSection][$label]['text'], $size, $renvooiTextBlock);
                }
            }
        }
    } else
    {
        @mail("sales@vicus.nl", __FILE__, "ERROR - er wordt een documentsectie aangeroepen die nog niet bestaat docSection = $docSection. Controleer ook het bestand data_textblocks.inc");
    }

    // if any was printed we go to a new page // afterwards !
    if ($printedSomething && $ForceNewPage)
    {
    	$newText .= '[PAGEBREAK]';
    /**
    	// @change lro 250125 optimize 
    	
        // @change lro 140510  // see http://mpdf1.com/manual/index.php?tid=108
        // get pagebreak settings
        $sql = "SELECT orientation, margin_left, margin_top, margin_right, margin_bottom
    FROM vtiger_pdfmaker_settings
    WHERE templateid=?";
        $result2 = $adb->pquery($sql, array($PDFMaker_template_id));
        $data = $adb->fetchByAssoc($result2);
        $newText .= '<pagebreak orientation="' . $data["orientation"] . '" margin-left="' . ($data["margin_left"] * 10) . 'mm" margin-right="' . ($data["margin_right"] * 10) . 'mm" margin-top="0mm" margin-bottom="0mm" margin-header="' . ($data["margin_top"] * 10) . 'mm" margin-footer="' . ($data["margin_bottom"] * 10) . 'mm" />';

        // $newText .= "<div style='page-break-after: always;'><span style='display: none;'>&nbsp;</span></div>";
        // $newText .= "<pagebreak />PAGEBREAK";
        unset($result, $data, $sql);

        // $newText .= '<div style="page-break-after: always;"><span style="display: none;">&nbsp;</span></div>';
*/
    }

    unset($printedSomething, $ForceNewPage);

    $renvooiTextBlock = false; // tell getHTMLtext that we are not in a block anymore

    if ($renvooi)
    {
        // $newText = "<br />[START VARIABEL TEKSTBLOK VOOR $docSection]".$newText."[EINDE VARIABEL TEKSTBLOK]<br />";
        $style = " color: rgb(255,0,0); ";
        $newText = '<br /><span style="' . $style . '">[' . $docSection . ']</span>' . $newText . '<span style="' . $style . '" >[/' . $docSection . ']</span><br />';
    }
    
    // add pagebreaks if any
    // only do query if required
	$pos = stripos($newText, '[PAGEBREAK]');
	if ($pos !== false) {
		$pagebreak = getPageBreaks(1);
		$newText = str_replace('[PAGEBREAK]',$pagebreak,$newText);
	}
//print $newText; die();

    return $newText; //htmlspecialchars(, ENT_QUOTES);
}
