<?php

/** 
 * Gets the Producs AND services 
 * as part of the bundle
 */
function veb_subproducts_formatted($productid, $website = '', $index=true)
{
//    $productid=$prodInfo['hdnProductId'.$key];
    $subproducts = getSubProducts($productid);
    $subservices = getSubServices($productid);
    $return = '';
    
    $subproductsRaw = array_merge($subproducts, $subservices);
//        print_r($subproducts); die();
    
    // @change 2505-09 lro sorteren op clustercode moet nog
    // eerst clustercode in id verwerken, dan sorteren
    // clustercode kan vaker voorkomen dus id er achter zetten
    $subproducts = array();
    foreach ($subproductsRaw as $key => $data) {
	    $subproducts[$data['clustercode'].$key] = $data;
    }
    
    ksort($subproducts);
    
    if (count($subproducts) > 0)
    {
    
        if ($index) {
            $tempText = 'Dit pakket bestaat uit de volgende onderdelen:';
            $tempText .= "\n".'<ol>';
            foreach ($subproducts as $id => $subProdInfo) {
                $tempText .= '<li>'.$subProdInfo['productname'];
                $tempText .= ($subProdInfo['tagline']) ? ' - '.$subProdInfo['tagline'] : '';
                $tempText .= '</li>';
            }
            $tempText .= '</ol>'."\n";
        }
        
        //				print_r($subproducts); die();
        $nummer = 0;
        foreach ($subproducts as $id => $subProdInfo) {
            $nummer++;
            $tempText .= '<h3>Onderdeel '.$nummer.': <bookmark content="'.$subProdInfo['productname'].'" level="2"></bookmark>'.$subProdInfo['productname'].'</h3>'."\n";
        	$tempText .= !empty($subProdInfo['description']) ? $subProdInfo['description']."\n" : '';
        	$tempText .= !empty($subProdInfo['inclusief']) ? "Inclusief:\n".$subProdInfo['inclusief']."\n" : '';
        	$tempText .= !empty($subProdInfo['uitgangspunten']) ? "Aandachtspunten:\n".$subProdInfo['uitgangspunten']."\n" : '';
        	$tempText .= !empty($subProdInfo['voordelen']) ? "Voordelen:\n".$subProdInfo['voordelen']."\n" : '';
        	if ($website != $subProdInfo['website']) {
        		$tempText .= !empty($subProdInfo['website']) ? 'Zie: '.$subProdInfo['website']."\n" : '';
        	}
        }
        $tempText = str_ireplace("\n\n","\n",$tempText); // cleanup some shit
        $tempText = veb_getHTMLtext($tempText);
        $tempText = str_ireplace("<p><ol>","<ol>",$tempText); // cleanup some shit
        $tempText = str_ireplace("</ol></p>","</ol>",$tempText); // cleanup some shit
        $tempText = str_ireplace("<p><h3>","<h3>",$tempText); // cleanup some shit
        $tempText = str_ireplace("</h3></p>","</h3>",$tempText); // cleanup some shit
       
        $tempText = str_ireplace("<p></p>","",$tempText); // cleanup some shit
        $return = $tempText;
//        if ($return) die($return);
    }

    return $return;
}


function getSubProducts($parentId)
{
    global $adb;
    $subProductArray = array();

    $sql = "SELECT 
                                    p.productid,
                                    p.productname,
                                    p.productcategory,
                                    p.c_tagline AS tagline,
                                    p.c_clustercode as clustercode,
                                    p.c_principles AS uitgangspunten,
                                    pc.cf_2072 AS inclusief,
                                    pc.cf_1592 AS voordelen,
                                    ce.description,
                                    r.quantity
                                    FROM vtiger_seproductsrel AS r
                                    LEFT JOIN vtiger_products AS p
                                    ON r.crmid = p.productid
                                    LEFT JOIN vtiger_crmentity AS ce
                                    ON ce.crmid = p.productid
                                    LEFT JOIN vtiger_productcf AS pc
                                    ON pc.productid = p.productid
                                    WHERE r.productid=?
                                    AND r.setype='Products';";
                                    
//    print '<li>'.$sql. ', parentId='.$parentId;
    
    $sub_prod_query = $adb->pquery($sql, array($parentId));

    $subProductCount = $adb->num_rows($sub_prod_query);

    if ($subProductCount > 0)
    {
        for ($j = 0; $j < $subProductCount; $j++)
        {
            $productid = $adb->query_result($sub_prod_query, $j, 'productid');
            $subProductArray[$productid] = array(
                'productid' => $productid,
                'productname' => $adb->query_result($sub_prod_query, $j, 'productname'),
                'productcategory' => $adb->query_result($sub_prod_query, $j, 'productcategory'),
                'description' => $adb->query_result($sub_prod_query, $j, 'description'),
                'inclusief' => $adb->query_result($sub_prod_query, $j, 'inclusief'),
                'voordelen' => $adb->query_result($sub_prod_query, $j, 'voordelen'),
                'uitgangspunten' => $adb->query_result($sub_prod_query, $j, 'uitgangspunten'),
                'quantity' => $adb->query_result($sub_prod_query, $j, 'quantity'),
                'tagline' => $adb->query_result($sub_prod_query, $j, 'tagline'),
                'clustercode'  => $adb->query_result($sub_prod_query, $j, 'clustercode')
            );
        }
    }
//    print_r($subProductArray);
    return $subProductArray;
}

function getSubServices($parentId)
{
    global $adb;
    $subServiceArray = array();

/*
wel in product, niet in dienst
s.c_principles AS uitgangspunten, //
sc.cf_2072 AS inclusief,
sc.cf_1592 AS voordelen,
*/

    $sql = "SELECT 
                                    s.serviceid,
                                    s.servicename,
                                    s.servicecategory,
                                    s.c_tagline AS tagline,
                                    s.c_clustercode as clustercode,
                                    ce.description,
                                    r.quantity
                                    FROM vtiger_seproductsrel AS r
                                    LEFT JOIN vtiger_service AS s
                                    ON r.crmid = s.serviceid
                                    LEFT JOIN vtiger_crmentity AS ce
                                    ON ce.crmid = s.serviceid
                                    LEFT JOIN vtiger_servicecf AS sc
                                    ON sc.serviceid = s.serviceid
                                    WHERE r.productid=?
                                    AND r.setype='Services';";

//    print '<li>'.$sql. ', parentId='.$parentId;
    
    $sub_prod_query = $adb->pquery($sql, array($parentId));

    $subServiceCount = $adb->num_rows($sub_prod_query);

    if ($subServiceCount > 0)
    {
        for ($j = 0; $j < $subServiceCount; $j++)
        {
            $serviceid = $adb->query_result($sub_prod_query, $j, 'serviceid');
            $subServiceArray[$serviceid] = array(
                'productid' => $serviceid,
                'productname' => $adb->query_result($sub_prod_query, $j, 'servicename'),
                'productcategory' => $adb->query_result($sub_prod_query, $j, 'servicecategory'),
                'description' => $adb->query_result($sub_prod_query, $j, 'description'),
                'inclusief' => '',
                'voordelen' => '',
                'uitgangspunten' => '',
                'quantity' => $adb->query_result($sub_prod_query, $j, 'quantity'),
                'tagline' => $adb->query_result($sub_prod_query, $j, 'tagline'),
                'clustercode'  => $adb->query_result($sub_prod_query, $j, 'clustercode')
            );
        }
    }

    return $subServiceArray;
}
