<?php

/**
 * This function executes if-else statement based on given parameters
 *  
 * @param $param1 first parameter of comparation
 * @param $comparator comparation sign - one of ==,!=,<,>,<=,>=
 
 * HRI: string comparators add <> (contains) and >< (does not contain)
 
 * @param $param2 second parameter of comparation
 * @param $whatToReturn1 value returned when comparation succeded
 * @param $whatToReturn2 value returned when comparation not succeded
 * */
if (!function_exists('veb_stringcompare')) {

    function veb_stringcompare($param1, $comparator, $param2, $whatToReturn1, $whatToReturn2 = '') {
        global $default_charset;
        $param1 = htmlentities($param1, ENT_QUOTES, $default_charset);
        $comparator = html_entity_decode($comparator, ENT_COMPAT, 'utf-8');
        $param2 = htmlentities($param2, ENT_QUOTES, $default_charset);

        switch ($comparator) {
            case "=":
                $comparator = '==';
                break;
            case "<>":
                $comparator = '!=';
                break;
            case "=>":
                $comparator = '>=';
                break;
            case "=<":
                $comparator = '<=';
                break;
        }


        if (in_array($comparator, array('cont', 'excl'))){

		// Test if $param1 contains $param2
			switch ($comparator){
				case "cont":
					$pos = strpos($param1, $param2);
					if (!$pos)
						return $whatToReturn2;
					else
						return $whatToReturn1;
					break;
		// Test if $param1 does not contain $param2
				case "excl":
					$pos = strpos($param1, $param2);
					if (!$pos)
						return $whatToReturn1;
					else
						return $whatToReturn2;
					break;
			}
		}
        elseif (in_array($comparator, array('==', '!=', '>=', '<=', '>', '<'))){
			$whatToReturn1 = htmlentities($whatToReturn1, ENT_QUOTES, $default_charset);
			$whatToReturn2 = htmlentities($whatToReturn2, ENT_QUOTES, $default_charset);
			return nl2br(html_entity_decode(eval("if('$param1' $comparator '$param2'){return '$whatToReturn1';} else {return '$whatToReturn2';}"), ENT_COMPAT, $default_charset));
		}
		else
            return "Error! second parameter must be one from following: ==,!=,<,>,<=,>=,<>,><";
    }

}
