<?php

/**
 * This function returns HTML representation table with specifications
 *  
 * @param $text text to be processed
 * @param $headerText text to be processed as header if filled
 * @change added 
 *
 * */
include_once('veb_vicusinterneinfo.php');
include_once('veb_getpicklist.php');

error_reporting(E_ALL & ~(E_STRICT | E_NOTICE));

function veb_spectable($crmid, $size = '12px', $novalidation = false)
{
    global $adb, $PDFMaker_template_id;
    global $renvooi;

    // @change lro 180713 gaan we deze tabel tonen?
    $renvooiColor = " color: rgb(0,0,255); ";

    $style = ($renvooi) ? 'font-size: ' . $size . "; " . $renvooiColor : 'font-size: ' . $size . "; ";

    $aQuo = veb_getInternal_QUO($crmid);
    $aQuoAll = $aQuo;

//  print_r($aQuo); die();
    $toontabel = stristr($aQuo['c_lead_solutions'], 'Toon specificatietabel') !== FALSE ? true : false;

    if (!$toontabel)
        return false;

    // no table when only vtiger
    if ($aQuo['cf_1873'] == 'Vtiger CRM')
        return '';

    $magento = stristr($aQuo['cf_1873'], 'Magento webshop(s)') !== FALSE ? true : false;
    $mage2erp = stristr($aQuo['cf_1873'], 'Koppeling Magento-ERP') !== FALSE ? true : false;

    $vtiger = stristr($aQuo['cf_1873'], 'Vtiger') !== FALSE ? true : false;
    $vtiger2erp = stristr($aQuo['cf_1873'], 'Koppeling Vtiger-ERP') !== FALSE ? true : false;

    $woocommerce = stristr($aQuo['cf_1873'], 'Koppeling WooCommerce-ERP') !== FALSE ? true : false;
    $king = stristr($aQuo['cf_1934'], 'King') !== FALSE ? true : false;

//	echo "magento=$magento, vtiger=$vtiger, woocommerce=$woocommerce, mage2erp=$mage2erp"; die();
    // will be shown in this order in the table!
    $fieldsToInclude = array(
        'cf_1785', 'cf_1869', 'cf_1871', 'cf_1803', 'cf_1799', 'cf_1775', 'cf_1795', 'cf_1777',
        'cf_1779', 'cf_1781', 'cf_1797', 'cf_1823', 'cf_1783', 'cf_1787', 'cf_1859', 'cf_1805', 'cf_1924', 'cf_1791',
        'cf_1793', 'cf_1801', 'cf_1807', 'cf_1809', 'cf_1811', 'cf_1813', 'cf_1815', 'cf_1817', 'cf_1819', 'cf_1821', 'cf_1825', 'cf_1827', 'cf_1934',
        'cf_1829', 'cf_1879', 'cf_1831', 'cf_1875', 'cf_1833', 'cf_1881', 'cf_1835', 'cf_1877', // media files (type, aantal)
        'cf_1837', 'cf_1839', 'cf_1841', 'cf_1843', 'cf_1845', 'cf_1847', 'cf_1849',
        'cf_1873', 'cf_1851', 'cf_1853', 'cf_1855', 'cf_1857', 'cf_1863', 'cf_1865', 'cf_1867', 'cf_1932'
    );
    // 250814 lro removed: 'cf_1861', 

    if (!$king)
    {
        $key = array_search('cf_1934', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1803', $fieldsToInclude);  // debiteuren regime
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1829', $fieldsToInclude); // Afbeeldingen van ERP naar Shop  
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1831', $fieldsToInclude); // Video van ERP naar Shop  
        unset($fieldsToInclude[$key]);
         $key = array_search('cf_1835', $fieldsToInclude); // Audio van ERP naar Shop  
        unset($fieldsToInclude[$key]);       
        $key = array_search('cf_1833', $fieldsToInclude); // PDF van ERP naar Shop  
        unset($fieldsToInclude[$key]);      
    }

    if (!$magento and !$mage2erp)
    {
        $key = array_search('cf_1779', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1781', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1783', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1797', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1823', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1799', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1801', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1803', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1807', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1809', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1837', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1811', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
//        $key = array_search('cf_1861', $fieldsToInclude);
//        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1829', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1831', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1833', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1835', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1849', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1851', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
//    $key = array_search('cf_1859', $fieldsToInclude); unset($fieldsToInclude[$key]);
        $key = array_search('cf_1853', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1865', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1865', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1867', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1869', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1871', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1875', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1877', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1879', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1881', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1924', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1793', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1863', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
    }

    if (!$magento and $mage2erp)
    {
        $key = array_search('cf_1779', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1807', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
        $key = array_search('cf_1811', $fieldsToInclude);
        unset($fieldsToInclude[$key]); // Klantwaarderingssysteem
        $key = array_search('cf_1847', $fieldsToInclude);
        unset($fieldsToInclude[$key]); // Toon voorraad
    }

    if (!$vtiger)
    {
        $key = array_search('cf_1787', $fieldsToInclude);
        unset($fieldsToInclude[$key]);
    }

    /**     uitleg

      $textToAdd        - voegt tekst toe onder aan de tabel als betreffende waarde in veld is gekozen.
      $modulesToBuy     - voegt een lijstje toe van aan te schaffen modules, maar zet deze niet in de begroting!!
      $servicesRequired - controleert of de geconfigureerde service(s) zijn toegevoegd aan de offerte
      $productsRequired - controleert of de geconfigureerde service(s) zijn toegevoegd aan de offerte

     */
    // Webshop
    // ======================================
    if ($magento)
    {
        $textToAdd['cf_1779'] = "Magento bevat standaard zoeken in de shop via auto-suggestie-zoektermen, op basis van eerder ingetikte termen dus al een resultaat van artikelen laten zien indien men een deel van het woord intikt. Plug-ins bieden aanvullende functionaliteit.";
    }
    $textToAdd['cf_1869']['Bouw en onderhoud bij derde'] = "Als Vicus de webshop niet in beheer heeft zitten wij 'tussen King en de webshop' in. Dat betekent in de praktijk dat er veelvuldig vragen worden gesteld over hoe King en/of de webshop in te richten. Voor King vragen is de King dealer beschikbaar, voor webshop vragen is de webbouwer beschikbaar. Uit de aard van de opdracht vloeit voort dat Vicus GEEN mening heeft over de inrichtingskeuzes binnen King en de webshop. Het is de primaire taak van Vicus om met de koppeling optimaal de inrichtingskeuzes in King en webshop te ondersteunen. Inrichtingsadviezen worden alleen gegeven als die de optimale werking van de koppeling ondersteunen. Let op! Straat en Huisnummer moeten in de webshop zijn gesplitst (nodig voor ERP-koppeling).";
    $textToAdd['cf_1869']['U doet bouw en onderhoud zelf'] = "Als Vicus de webshop niet in beheer heeft zitten wij 'tussen King en de webshop' in. Dat betekent in de praktijk dat er veelvuldig vragen worden gesteld over hoe King en/of webshop in te richten. Voor King vragen is de King dealer beschikbaar, voor webshop vragen is uw eigen webbouwer beschikbaar. Op basis van nacalculatie helpen wij je graag met het verbeteren van uw webshop. Let op! Straat en Huisnummer moeten in de webshop zijn gesplitst (nodig voor ERP-koppeling).";
    $servicesRequired['cf_1869']['Bouw en onderhoud bij derde'] = 'support-webbouwer';
    $servicesRequired['cf_1869']['U doet bouw en onderhoud zelf'] = 'support-webbouwer';

    $textToAdd['cf_1871']['Vervangt bestaande Webshop'] = "Daar de webshop een bestaande webshop gaat vervangen wordt (de koppeling met) de huidige webshop in overleg op een gezamenlijk te bepalen passend moment stilgelegd.";

    // Toegankelijkheid
    if ($magento || $woocommerce)
    {
        $uitleg = 'Bij een open webshop zijn de prijzen van producten direct zichtbaar zonder in te loggen. Bij een gesloten winkel moet eerst een account worden aangevraagd en pas na toekenning kan de bezoeker de shop zien (Een nieuwe klant kan online een account aanmaken. Bestellen kan pas na controle en accreditatie). Bij een half open winkel worden wel productspecificaties maar geen prijzen getoond, ook hier is bestellen pas mogelijk na inlog.';
        $textToAdd['cf_1799']['Open winkel'] = $uitleg;
        $textToAdd['cf_1799']['Halfopen winkel'] = $uitleg;
        $textToAdd['cf_1799']['Gesloten winkel'] = $uitleg;
        $modulesToBuy['cf_1799']['Gesloten winkel'] = 'Magento community add-on: Gesloten webwinkel';
    }

    // Debiteuren
    // ======================================
    if ($magento)
    {
        $servicesRequired['cf_1785']['Zakelijke klanten (B2B)'] = 'mag-bas-b2b';
        $productsRequired['cf_1801']['1'] = 'vo-m2k-cowoa'; // Check Out Without Account
        $productsRequired['cf_1803']['Meerdere contactpersonen per debiteur'] = 'vo-m2k-b2bcontact';
        $textToAdd['cf_1803']['1 Contactpersoon per debiteur'] = "Magento kent 1 inlogaccount per Debiteur met 1 contactpersoon. Dit regime kan tegen meerprijs binnen de koppeling worden aangepast zodat er meerdere contactpersonen per debiteur kunnen inloggen en bestellen.";
    }


// - Uitgesloten - Normaliseren (bv rouge->rood) of verrijken van de gegevens via de koppeling.
    // Logistiek dienstverlener
    // ======================================
//  $productsRequired['cf_1783']['Afhalen bij de balie'] = 'mag-ispm';
//    $modulesToBuy['cf_1783']['DPD'] = 'Magento community add-on: DPD Module';
    $modulesToBuy['cf_1783']['DHL'] = 'Magento community add-on: DHL Module';
    $modulesToBuy['cf_1783']['PostNL'] = 'Magento community add-on: PostNL Module';
    $modulesToBuy['cf_1783']['GLS'] = 'Magento community add-on: GLS Module';
    $modulesToBuy['cf_1783']['Eigen magazijn'] = 'configuratie: Inrichten Eigen magazijn';
    $modulesToBuy['cf_1783']['Extern magazijn'] = 'maatwerk: Extern magazijn koppelen is alleen onderdeel van deze offerte als dat expliciet als post in deze offerte is opgenomen.';
    $modulesToBuy['cf_1783']['Dropshipment'] = 'maatwerk: koppelen met dropshopment partner, is alleen onderdeel van deze offerte als dat expliciet als post in deze offerte is opgenomen.';

    // Talen = special - gaat om aantal extra -1
    // ======================================
    if ($magento)
    {
        $productsRequired['cf_1777']['Nederlands'] = 'vo-m2k-taal';
        $productsRequired['cf_1777']['Engels'] = 'vo-m2k-taal';
        $productsRequired['cf_1777']['Frans'] = 'vo-m2k-taal';
        $textToAdd['cf_1777'] = 'Later extra landen en talen toevoegen vergt dan aanpassingen (is meerwerk).';
    }
    if ($vtiger)
    {
        $productsRequired['cf_1777']['Nederlands'] = 'vt-lang-dutch-7';
        $textToAdd['cf_1777'] .= 'De Engelse taal is standaard geinstalleerd in vtiger.';
    }


// Merk op dat eventueel ook e-mailtemplates, pdf-templates, selectieboxen en andere onderdelen in meerdere talen moeten worden gemaakt/vertaald.
    // Betaalmethoden, regime en PSP
    // ======================================
    if ($magento)
    {
        $productsRequired['cf_1781']['MultiSafepay'] = 'mag-msp';
        $productsRequired['cf_1781']['Buckaroo'] = 'ma-psp-buckaroo';
        $productsRequired['cf_1781']['Sisow'] = 'ma-psp-sisow';
        $productsRequired['cf_1781']['Ingenico'] = 'ma-psp-ogo';

//        $modulesToBuy['cf_1861']['OneStepCheckout'] = 'Magento community add-on: OneStepCheckout - aanschafprijs va &eur&nbsp;245';
//        $modulesToBuy['cf_1823']['Instelbaar per klantgroep'] = 'Magento community add-on: Betaalmethode Instelbaar per klantgroep';
    }

    // Prijsafspraken en staffels
    // ======================================
    if ($magento && $king)
    {
        $productsRequired['cf_1859']['1 Korting per Debiteur op Artikel'] = 'vo-m2k-pa1-deb-art';
        $productsRequired['cf_1859']['2 Korting per Debiteur op Opbrengstgrp'] = 'vo-m2k-pa2-deb-opbgr';
        $productsRequired['cf_1859']['3 Korting per Debiteurgrp op Artikel'] = 'vo-m2k-pa3-debgrp-art';
        $productsRequired['cf_1859']['4 Korting per Debiteurgrp op Opbrengstgrp'] = 'vo-m2k-pa4-debgr-opgr';
        $productsRequired['cf_1859']['5 Orderkorting per Debiteur'] = 'vo-m2k-pa5-orderperc-deb';
        $productsRequired['cf_1859']['6 Orderkorting per Debiteurgroep'] = 'vo-m2k-pa6-orderperc-debgr';
        // Staffelprijzen
        $productsRequired['cf_1805']['1'] = 'vo-m2k-pastaffel';
    }
    if ($woocommerce)
    {
        //$productsRequired['cf_1805']['1'] = 'vo-w2k-pastaffel';
        $textToAdd['cf_1805'] = 'De module Staffelprijzen is voor WooCommerce niet beschikbaar.';
    }

    // Artikelen
    // ======================================
    if ($magento && $king)
    {
    	$productsRequired['cf_1803']['ERP-systeem'] = 'vo-m2k-metadata';
    }
    
// - Product stamgegevens zult u zelf beheren in King. Web productgegevens (commercile product beschrijvingen, categorien, configurabele producten, e.d.) kunt u zowel beheren in Magento als in King, het definitieve regime zal in de ready2go implementatiesessie worden afgesproken.
    // Categorie-regime id of ranking
    // ======================================
    if ($magento && $king)
    {
        $productsRequired['cf_1837']['Categorie id en ranking invoeren in ERP'] = 'vo-m2k-catranking';
    }
    if ($woocommerce && $king)
    {
        $productsRequired['cf_1837']['Categorie id en ranking invoeren in ERP'] = 'vo-w2k-catranking';
    }

    // Afbeeldingen en media
    // ======================================
    if ($magento && $king)
    {
        $productsRequired['cf_1829']['Extra afbeeldingen'] = 'vo-m2k-xafbeeldingen'; // Afbeeldingen
        $productsRequired['cf_1831']['YouTube'] = 'vo-m2k-youtube'; // Video
        $productsRequired['cf_1833']['Productsheets'] = 'vo-m2k-pdffile'; // PDF
        $productsRequired['cf_1833']['Certificaten'] = 'vo-m2k-pdffile'; // PDF
        $productsRequired['cf_1835']['MP3-bestanden'] = 'vo-m2k-mp3file'; // Audio

        $productsRequired['cf_1875']['Extra afbeeldingen'] = 'vo-m2k-afbextra'; // Afbeeldingen
        $productsRequired['cf_1877']['YouTube'] = 'vo-m2k-afbextra'; // Video
        $productsRequired['cf_1879']['Productsheets'] = 'vo-m2k-pdfextra'; // PDF
        $productsRequired['cf_1879']['Certificaten'] = 'vo-m2k-pdfextra'; // PDF
        $productsRequired['cf_1881']['MP3-bestanden'] = 'vo-m2k-mp3extra'; // Audio
    }
    if ($woocommerce && stristr($aQuo['cf_1833'], 'Productsheets' !== FALSE))
    {
        $textToAdd['cf_1833'] = 'De link naar de productsheets worden opgenomen als vrije rubriek en doorgegeven aan de webshop. De webbouwer zorgt voor presentatie.'; // PDF
    }

    $modulesToBuy['cf_1831']['YouTube'] = 'Magento Vicus add-on: YouTube video presenteren';
    $modulesToBuy['cf_1833']['Productsheets'] = 'Magento community add-on: PDF Productsheets presenteren';
    $modulesToBuy['cf_1833']['Certificaten'] = 'Magento community add-on: PDF Certificaten  presenteren';
    $modulesToBuy['cf_1835']['MP3-bestanden'] = 'Magento community add-on: MP3 audio afspelen';

    // Bijzondere artikelen
    // ======================================
    $modulesToBuy['cf_1841']['Emballage'] = 'Maatwerk/Inrichten/regelen Emballage'; // 
    $modulesToBuy['cf_1841']['Volgartikelen'] = 'Maatwerk/Inrichten/regelen Volgartikelen'; // 
    $modulesToBuy['cf_1841']['Montagekosten'] = 'Maatwerk/Inrichten/regelen Montagekosten'; // 
    $modulesToBuy['cf_1841']['Verwijderingsbijdrage'] = 'Maatwerk/Inrichten/regelen Verwijderingsbijdrage'; // 
    $modulesToBuy['cf_1841']['Statiegeld'] = 'Maatwerk/Inrichten/regelen Statiegeld'; // 
    $modulesToBuy['cf_1841']['Andere heffingen'] = 'Maatwerk/Inrichten/regelen Andere heffingen'; // 

    // Artikelrelaties
    // ======================================
    if ($magento && $king)
    {
        $productsRequired['cf_1843']['Bundels'] = 'vo-m2k-orderbundel';
        $productsRequired['cf_1843']['Gerelateerde artikelen'] = 'vo-m2k-crossup';
        $productsRequired['cf_1843']['Cross Sell/Upsell'] = 'vo-m2k-crossup';
        $productsRequired['cf_1843']['Clusters met maten en kleuren'] = 'vo-m2k-crossup';
        $productsRequired['cf_1843']['Clusters obv andere varianten'] = 'vo-m2k-crossup';
        $productsRequired['cf_1843']['Configurabele producten'] = 'vo-m2k-crossup';
        $productsRequired['cf_1843']['Producten met opties'] = 'vo-m2k-crossup';
    }

    if ($woocommerce)
    {
        //$productsRequired['cf_1843']['Gerelateerde artikelen'] = 'vo-w2k-crossup';
        //$productsRequired['cf_1843']['Cross Sell/Upsell'] = 'vo-w2k-crossup';
        //$productsRequired['cf_1843']['Clusters met maten en kleuren'] = 'vo-w2k-crossup';
        //$productsRequired['cf_1843']['Clusters obv andere varianten'] = 'vo-w2k-crossup';
        //$productsRequired['cf_1843']['Configurabele producten'] = 'vo-w2k-crossup';
        //$productsRequired['cf_1843']['Producten met opties'] = 'vo-w2k-crossup';
        $textToAdd['cf_1843'] = 'De module Gerelateerde artikelen, Cross Sell/Upsell, Clusters, Configurabele producten en Producten met opties is voor WooCommerce nog niet beschikbaar.';
    }

    // Transformers    
    // ======================================
//    $servicesRequired['cf_1861']['Attributen normaliseren'] = '???';
//    $servicesRequired['cf_1861']['Kleuren normaliseren'] = '???';

    $modulesToBuy['cf_1793']['Volledig binnen de webshop'] = 'Magento community add-on: ';

    // Externe feeds aansluiten
    // ======================================
    $modulesToBuy['cf_1809']['Bol.com'] = 'Magento community add-on: feed naar Bol.com';
    $modulesToBuy['cf_1809']['Google Shopping'] = 'Magento community add-on: feed naar Google Shopping';
    $modulesToBuy['cf_1809']['Marktplaats'] = 'Magento community add-on: feed naar Marktplaats';

    // Klantwaarderingssysteem
    // ======================================
    $modulesToBuy['cf_1811']['Feedback Company'] = 'Magento community add-on: Feedback Company';

    // Koppeling Magento - WordPress
    // ======================================
    if ($magento)
    {
        $modulesToBuy['cf_1849']['Producten publiceren in WordPress'] = 'Magento community add-on: Producten publiceren in WordPress';
    }

    // Magazijnen en Voorraad
    // ======================================
    $uitleg = ' Welke voorraadpositie (bv. plankvoorraad, economische voorraad) uit welk(e) magazijn(en) wordt gebruikt wordt tijdens de workshop bepaald.';
    if ($king) {
	    $textToAdd['cf_1845']['1 Magazijn van 1 bedrijfsadministratie'] = 'Vicus configureert in de koppeling aansluiting bij 1 specifiek magazijn van 1 administratie.' . $uitleg;
	    $textToAdd['cf_1845']['Meerdere magazijnen van 1 bedrijfsadministratie'] = 'Vicus configureert in de koppelingaansluiting bij een aantal specifieke magazijnen van 1 administratie.' . $uitleg;
	    $textToAdd['cf_1845']['Alle magazijnen in 1 bedrijfsadministratie'] = 'Vicus configureert in de koppeling aansluiting bij alle magazijnen van 1 administratie.' . $uitleg;
    }

    $textToAdd['cf_1!!!!869']['Beschikbaarheid als stoplicht'] = "Beschikbaarheid van een artikel tonen als stoplicht (groen = voldoende voorraad, oranje = beperkte voorraad, rood = geen voorraad) - Grenswaarden tijdens project af te spreken.";

    $sql = "SELECT fieldname, fieldlabel, block, uitype
	        FROM vtiger_field
	        WHERE tablename = 'vtiger_quotescf' and columnname IN ('" . implode("','", $fieldsToInclude) . "'); ";

//	print $sql;
    $fieldlabels = array();
    $result = $adb->query($sql);
    //print_r($adb);

    while ($fieldspecs = $adb->fetchByAssoc($result)) {
//  print_r($fieldspecs);
        $fieldlabels[$fieldspecs['fieldname']] = array(
            'label' => $fieldspecs['fieldlabel'],
            'uitype' => $fieldspecs['uitype'],
            'block' => $fieldspecs['block'],
            'permissiblevalues' => getpicklist($fieldspecs['fieldname'])
        );
    }

    $sql = "SELECT blockid, blocklabel, sequence FROM vtiger_blocks ORDER BY sequence";

//	print $sql;
    $blocklabels = array();
    $result = $adb->query($sql);
//  print_r($adb);

    while ($blockpecs = $adb->fetchByAssoc($result)) {
//    print_r($blockpecs);
        $blocklabels[$blockpecs['blockid']] = array(
            'label' => $blockpecs['blocklabel'],
            'sequence' => $blockpecs['sequence']
        );
    }

    $rows = array();
//  $newtext = '';
    $newtext = array();
    $textAsArray = array();
    $requireProducts = array();
    $requireServices = array();
    $requireModules = array();
    $noteCounter = 0;
    $notes = '';

    // ============================================================================================== Correction on required
    // do not force module for some fields if we have koppeling only!

    if ($mage2erp)
    {
        $skipfields = array('cf_1781'); // PSP
        foreach ($skipfields as $id1 => $skipfieldname)
        {
            unset($productsRequired[$skipfieldname]);
        }

        $skipfields = array('cf_1785'); // Zakelijk
        foreach ($skipfields as $id2 => $skipfieldname)
        {
            unset($servicesRequired[$skipfieldname]);
        }
    }

    // Alleen als er meer dan 1 mediabestand besteld wordt dan moeten extra kosten per mediabestand worden berekend!  
    $skipfields = array('cf_1877', 'cf_1879', 'cf_1881');
    foreach ($skipfields as $id => $skipfieldname)
    {
        if ($aQuo[$skipfieldname] < 2)
        {
            unset($productsRequired[$skipfieldname]);
        }
    }

    // taal is aantal -1
//    if (count($aQuo['cf_1777']) < 2)
    if ( is_array($aQuo['cf_1777']) && (count($aQuo['cf_1777']) < 2) )
    {
        unset($productsRequired['cf_1777']);
    }


    // Voor afbeeldingen is het ingewikkelder
    // hoeveel afbeeldingen willen we in totaal? dat staat in 'cf_1879', 
    $totalAfb = $aQuo['cf_1879'];
    // hebben we een standaard met 2 afbeeldingen? dat staat in cf_1829 als Standaard 2 afbeeldingen
    $standard2Afb = (strpos($aQuo['cf_1829'], 'Standaard 2 afbeeldingen') === FALSE) ? FALSE : TRUE;
    // hebben we extra afbeeldingen? dat staat in cf_1829 als Extra afbeeldingen
    $extraAfb = (strpos($aQuo['cf_1829'], 'Extra afbeeldingen') === FALSE) ? FALSE : TRUE;
    // vervolgens 1 basismodule incl 1 afbeelding als product? --> dat is verplicht als gekozen!
    // en dan nog aanvulend? als product?
//  print_r($aQuo[cf_1829]); print "std: {$standard2Afb}, extra {$extraAfb}, total: {$totalAfb} "; die();  
    // ==>
    // ==> continues where we check the productslines
    // ==>
    // ============================================================================================== controle of de juiste producten in de offerte wel gekoppeld zijn!!

    foreach ($fieldsToInclude as $fieldid => $fieldname)
    {

        $text = $aQuo[$fieldname];
        $permissiblevalues = $fieldlabels[$fieldname]['permissiblevalues']['values'];
        if (empty($permissiblevalues))
            $permissiblevalues = array();

        $uitype = $fieldlabels[$fieldname]['uitype'];

        if ($uitype == 33 || $uitype == 16)
        {
            $textAsArray = explode(' |##| ', $text);
            $permissiblevalues[] = 'Overig';
        } else
        {
            $textAsArray[] = $text;
        }

        $valuesNOT = array_diff($permissiblevalues, $textAsArray);

        // te bedienen landen een beetje opschonen in voorkomende gevallen
        // if Europa/Eurozone then remove the specific countries
        if ($fieldname == 'cf_1775' && array_search('Europa/Eurozone', $textAsArray))
        {
            $removeArray = array('België', 'Belgi&euml;', 'Frankrijk', 'Duitsland', 'Engeland', 'Nederland');
            $textAsArray = array_diff($textAsArray, $removeArray);
            $valuesNOT = array_diff($valuesNOT, $removeArray);
            $text = implode(' |##| ', $textAsArray);
            // print_r ($textAsArray); print '<hr>'; print_r ($valuesNOT);
        }

        $textNOT = implode(', ', array_values($valuesNOT));

        if (isset($productsRequired[$fieldname]))
        {
            $intersect = array_intersect($textAsArray, array_keys($productsRequired[$fieldname]));
            foreach ($intersect as $kid => $value)
            {
                $requireProducts = array_merge($requireProducts, explode(',', $productsRequired[$fieldname][$value]));
            }
        }
        if (isset($servicesRequired[$fieldname]))
        {
            $intersect = array_intersect($textAsArray, array_keys($servicesRequired[$fieldname]));
            foreach ($intersect as $kid => $value)
            {
                $requireServices = array_merge($requireServices, explode(',', $servicesRequired[$fieldname][$value]));
            }
        }
        if (isset($modulesToBuy[$fieldname]))
        {
            $intersect = array_intersect($textAsArray, array_keys($modulesToBuy[$fieldname]));
            foreach ($intersect as $kid => $value)
            {
                $requireModules = array_merge($requireModules, explode(',', $modulesToBuy[$fieldname][$value]));
            }
        }

        // formatting of text we want to publish
        if ($uitype == 33)
            $text = str_replace(' |##| ', ', ', $text);
        if ($uitype == 56)
            $text = ($text == 1) ? $text = 'ja' : $text = 'n.v.t.';
        if ($uitype == 7)
            $textNOT = 'Meer dan ' . $text;
        if ($text == "")
            $text = "n.v.t.";
        $noteTxt = ' ';

        if (isset($textToAdd[$fieldname]))
        {
            if (is_array($textToAdd[$fieldname]))
            {
                // but only if a value exists in the field
                foreach ($textToAdd[$fieldname] as $id => $crap)
                {
                    if ($text == $id)
                    {
                        $noteCounter++;
                        $notes .= "<li style=\"{$style}\"><b>{$fieldlabels[$fieldname]['label']}</b> ({$id}): " . $textToAdd[$fieldname][$id] . '</li>';  //  {$text} -- {$id} -- {$fieldname}
                        $noteTxt .= $noteCounter . ') ';
                    } else
                    {
//            $notes .= "<li>'{$text}' <> '{$id}'</li>";
                    }
                }
            } else
            {
                // so if the field exists!
                $noteCounter++;
                $notes .= "<li style=\"{$style}\"><b>{$fieldlabels[$fieldname]['label']}</b>: " . $textToAdd[$fieldname] . '</li>'; // $text.' -- '.$fieldname.
                $noteTxt .= $noteCounter . ') ';
            }
        } else
        {
            $noteTxt = '';
        }

//   print_r($fieldlabels[$fieldname]['permissiblevalues']['values']);
//  {$fieldname} {$uitype}
        $rows[$fieldlabels[$fieldname]['block']][] = "<tr><th style=\"width: 30%;\">{$fieldlabels[$fieldname]['label']}{$noteTxt}</th><td style=\"width: 35%; {$style}\">{$text}</td><td style=\"width: 35%; {$style}\">{$textNOT}</td></tr>";
    }

    foreach ($rows as $blockid => $blockdata)
    {
        if (count($blockdata) > 0)
        {
            $return = "<table border=1 style=\"autosize:1; page-break-inside:avoid; width: 100%; {$style}\">";
            $return .= "<tr><th colspan=2>{$blocklabels[$blockid]['label']}</th><th>Uitgesloten</th></tr>";
            $return .= implode("\n", $blockdata);
            $return .= "</table><br />";
            $newtext[$blocklabels[$blockid]['sequence']] = $return;
//     print $return; 
        }
    }

    if (!empty($newtext))
    {
        $newtext[0] = "<p>Waar in de onderstaande lijst 'n.v.t.' staat of een onderdeel in de kolom 'uitgesloten' staat, wordt bedoeld dat Vicus dat wel graag voor je wil implementeren, maar dat het geen onderdeel uitmaakt van deze fase van het project.</p>";
    }

    ksort($newtext);

    $errorsFound = FALSE;

    // ============================================================================================== Validate Product Lines

    $productlines = getProductLinesFromQuote($crmid, 'Products');

    $missingP = array_diff_key(array_flip($requireProducts), $productlines);


    $qtyExtraAfbBasis = $productlines['vo-m2k-xafbeeldingen']['productqty'];
    $qtyExtraAfbExtra = $productlines['vo-m2k-afbextra']['productqty'];
    $qtyExtraAfbExtraFree = $productlines['vo-m2k-afbextra-free']['productqty'];

    // $totalAfb comes from above
    // 2 comes from standard in King
    if ($totalAfb > 0 && $mage2erp != '' && $king)
    {
        if ($totalAfb <> ($qtyExtraAfbBasis + $qtyExtraAfbExtra + $qtyExtraAfbExtraFree + 2))
        {
            print __FUNCTION__ . " mist afbeeldingen: qtyExtraAfbBasis={$qtyExtraAfbBasis} + qtyExtraAfbExtra={$qtyExtraAfbExtra} + qtyExtraAfbExtraFree={$qtyExtraAfbExtraFree}+ King=2 <> totalAfb={$totalAfb}";
            $errorsFound = TRUE;
        } elseif ($totalAfb > 0)
        {
            $noteTxt = "";

            if ($king)
            {
                $noteTxt .= "Totaal {$totalAfb} afbeeldingen is in de begroting terug te vinden als ";
                $noteTxt .= "2 standaard in de King koppeling";
                $noteTxt .= ($qtyExtraAfbBasis > 0) ? ", {$qtyExtraAfbBasis}x in de 'Mage2King: 1 Extra afbeelding van King naar Shop'" : '';
                $noteTxt .= ($qtyExtraAfbExtra > 0) ? ", {$qtyExtraAfbExtra}x als 'Mage2King: Extra afbeelding (per extra afbeelding)'" : '';
                $noteTxt .= ($qtyExtraAfbExtraFree > 0) ? ", {$qtyExtraAfbExtraFree}x als 'Mage2King: 1 gratis extra afbeelding (per extra afbeelding)'" : '';
                $noteTxt .= ". ";
            }
            $noteTxt .= "De afbeelding is NIET taal of webshop afhankelijk! Dezelfde afbeelding staat altijd overal bij hetzelfde artikel";
            $notes .= "<li style=\"{$style}\"><b>Afbeeldingen</b>: {$noteTxt}.</li>";
        }
    }


    if (!empty($missingP) && $_GET['overrule'] != 'y')
    {
//        print __FUNCTION__ . " missing productlines: " . implode(" - ", array_flip($missingP));
        $errorsFound = TRUE;
    }

    // ============================================================================================== Validate Service Lines

    $servicelines = getProductLinesFromQuote($crmid, 'Services');

    $missingS = array_diff_key(array_flip($requireServices), $servicelines);

    if (!empty($missingS) && $_GET['overrule'] != 'y')
    {
//        print __FUNCTION__ . " missing servicelines: " . implode(" - ", array_flip($missingS));
        $errorsFound = TRUE;
    }

    if ($errorsFound and $novalidation != 'novalidation')
    {
//        die();
    }

    // ============================================================================================== Add footer of table  
    if ($requireModules AND 1==2)
    {
        //$newtext['xxxxx999'] = "<ul><li>" . implode("</li><li>", $requireModules) . "</li></ul>";
        $mailbody = implode("\n-", $requireModules) . "\n";
        $mailbody .= var_dump($aQuo);
        mail ( 'sales@vicus.nl' , 'benodigde modules' , $mailbody);
    }

    if ($notes)
    {
        $newtext['yyyyy999'] = "<h4 style={$style}>Opmerkingen</h4><ol>{$notes}</ol>";
    }

    // ============================================================================================== table with all for test
    // store for test
    $allLabels = '<ul>';
    foreach ($aQuoAll as $fieldname => $text)
    {
        $allLabels .= "<li>$fieldname ( {$fieldlabels[$fieldname]['label']} ) = $text</li>";
    }
    $allLabels .= '</ul>';

//  $newtext['zzzzzz'] = $allLabels;
    // ============================================================================================== return result
//  print implode("",$newtext); print_r($newtext, true); die('crmid = '.$crmid);
    return implode("", $newtext);
}

function getProductLinesFromQuote($crmid, $entity = false)
{
    global $adb;

    // have all products & services associated to quote
    $result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
    $row = $adb->fetchByAssoc($result);
    $my_focus = CRMEntity::getInstance($row['setype']);
    $my_focus->id = $crmid;
    $my_focus->retrieve_entity_info($crmid, $row['setype']);
    $associated_prod = getAssociatedProducts($row['setype'], $my_focus);
    $associated_prod = lroGetProductDetails($associated_prod);

    $data = array();
    $data['Products'] = array();
    $data['Services'] = array();

    foreach ($associated_prod as $id => $productInfo)
    {
        $productid = $productInfo['hdnProductId' . $id];
        $producttype = $productInfo['entityType' . $id];
        $productcode = $productInfo['productcode' . $id];
        $productqty = $productInfo['qty' . $id];
        $productname = $productInfo['productName' . $id];
        $type = $productInfo['entityType' . $id];

        //print "{$productqty} x {$productid} - {$producttype} - {$productcode}<br />";
        // check if we have 1+ lines!
//    print_r($productInfo);
        if (isset($data[$type][$productcode]))
        {
            $productqty = (int) $productqty + (int) $data[$type][$productcode]['productqty'];
//            echo "<br>dubbel {$productcode}";
        }

        $data[$type][$productcode] = array(
            'productid' => $productid,
            'productname' => $productname,
            'producttype' => $producttype,
            'productcode' => $productcode,
            'productqty' => $productqty,
        );

//    print_r(  $productInfo );
    }

    return $data[$entity];
}
