<?php
/**
 * [CUSTOMFUNCTION|veb_getPricelist|$QUOTES_CRMID$|12px|CUSTOMFUNCTION]
 */

include_once('veb_pdfm_config.php');

/**
 * This function returns HTML representation of textfields 
 *  
 * @param $crmid	ID of the CRM entity
 * @param $size			(optional) font size - default 12px
 * @return	string containing formatted textblock
 **/ 
function veb_getPricelist($crmid,$size = '12px')
{
	global $adb, $PDFMaker_template_id;

	$style = 'font-size:'.$size;

	// defaults
	$newText = '';
	$printedSomething = false;
	
	// have all products & services associated to quote
	$result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
	$row = $adb->fetchByAssoc($result);
	$my_focus = CRMEntity::getInstance($row['setype']);
	$my_focus->id = $crmid;
	$my_focus->retrieve_entity_info($crmid,$row['setype']);
	$associated_prod = getAssociatedProducts($row['setype'], $my_focus);
	
        $pdfmConfig = new pdfmConfig($my_focus->fields['c_picklist_settings']);

	$service_category = $pdfmConfig->service_category;
	$service_order = $pdfmConfig->service_order;
	$product_category = $pdfmConfig->product_category;
	$product_order = $pdfmConfig->product_order;
	
	// get info from products and services, incl custom fields
	// sort them by order as defined
	foreach($associated_prod as $key=>$prod_info)
	{
		if($prod_info['entityType'.$key]=='Products') 
		{
			$vebType = 'p';
			$res = $adb->query("select ".$product_order." as ord, ".$product_category." as section, cf_1681 as speclink from vtiger_productcf where productid=".$prod_info['hdnProductId'.$key]);
//			$res = $adb->query("select * from vtiger_productcf where productid=".$prod_info['hdnProductId'.$key]);
			$res2 = $adb->query("select usageunit, website, productcode from vtiger_products where productid=".$prod_info['hdnProductId'.$key]);
			$res3 = $adb->query("select description from vtiger_crmentity where crmid=".$prod_info['hdnProductId'.$key]);
		} else {
			$vebType = 's';
			$res = $adb->query("select ".$service_order." as ord, c_partsnumber as productcode, ".$service_category." as section from vtiger_servicecf where serviceid=".$prod_info['hdnProductId'.$key]);
			$res2 = $adb->query("select service_usageunit AS usageunit, website from vtiger_service where serviceid=".$prod_info['hdnProductId'.$key]);
			$res3 = $adb->query("select description from vtiger_crmentity where crmid=".$prod_info['hdnProductId'.$key]);
		}
		$row = $adb->fetchByAssoc($res);
		$row2 = $adb->fetchByAssoc($res2);
		$row3 = $adb->fetchByAssoc($res3);
//		print_r($row2);
		$images = getInventoryImages($prod_info['hdnProductId'.$key]);

//		if($row['ord']=='' || $row['ord']==0)
		if($row['ord']=='')
			$row['ord'] = '9999999';
		if($merge){
			if($prod_info['entityType'.$key]=='Products' && strtolower($row[$product_category])!='--geen--' && trim($row[$product_category]!='')) {
				$row['ord'] = '99999999'.$Pick[$row[$product_category]];
			}
		}
		
		// row
		$associated_prod[$key]['sortorder'.$key] = $row['ord'];
		$associated_prod[$key]['section'.$key] = $row['section'];
		$associated_prod[$key]['speclink'.$key] = $row['speclink'];
		
		// row 2 website, manufacturer, productcode, manufacturer, serialno, productname
		$associated_prod[$key]['usageunit'.$key] = $row2['usageunit'];
		$associated_prod[$key]['website'.$key] = $row2['website'];


		if($prod_info['entityType'.$key]=='Products') 
		{
			$associated_prod[$key]['productcode'.$key] = $row2['productcode'];
		} else {
			$associated_prod[$key]['productcode'.$key] = $row['productcode'];
		}

		// row 3 description
		$associated_prod[$key]['description'.$key] = $row3['description'];
		
		$associated_prod[$key]['vebtype'.$key] = $vebType;

		// images
		$associated_prod[$key]['image'.$key] = $images[$prod_info['hdnProductId'.$key].'_1'];

		swapAssociatedProducts($associated_prod,$key);
//print '<pre>';print_r($associated_prod);

		// prepare separate sorting loop
		// by category
		// by sortorder
		$associated_prod_tmp[$prodInfo['section'.$key]][$prodInfo['sortorder'.$key]] = $prod_info;
	}
	
//	$newText .= '<table>';
	foreach ($associated_prod_tmp as $section => $sortedInfo)
	{
		asort($sortedInfo);
		foreach( $sortedInfo as $order => $prodInfo)
		{
			$associated_prod_ord[] = $prodInfo;
		}
	}

	foreach ($associated_prod_ord as $key => $prodInfo) 
	{ 
		$printedSomething = true;
//		$newText .= '<tr><td>';
		$allowedSites = array( 'vicus.nl', 'vtiger-experts.nl', 'zencart-experts.nl', 'vosba.nl' );
		$allowedSite = false;
		$productid = $prodInfo['hdnProductId'.$key];
		
		foreach ($allowedSites as $siteId => $domain) {

//			if (str_instr($domain, $prodInfo['website'.$key])) 
			if (stristr($prodInfo['website'.$key], $domain) )
			{
				$allowedSite = true;
				continue; // step out of the loop, we're done
			}
		}

		if (!empty($prodInfo['website'.$key]) && $allowedSite) 
		{
			// ensure we will only include websites that are Vicus related, don't make people smarter than necessary!
			// - will be parsed to unorderd list :-)
			$website = "\n- zie: ".$prodInfo['website'.$key];
		} else {
			$website = '';
		}
		$newText .= '<!-- start keep together block --><div style="page-break-inside: avoid;">'."\n";
		
		if(!empty($prodInfo['image'.$key]))
		{
			$newText .= '<table><tr><td width="100%">';
			$newText .= '<h2><bookmark content="'.$prodInfo['productName'.$key].'"></bookmark>['.$prodInfo['vebtype'.$key].'-'.strtolower($prodInfo['productcode'.$key]).'] '.$prodInfo['productName'.$key].' ('.$prodInfo['section'.$key].')</h2>'."\n";
			$newText .= '<td width="100px">';
			$width="";
			$height="";
			if($prodInfo['image'.$key]["width"]>0)
				$width=" width='".$prodInfo['image'.$key]["width"]."' ";
			if($prodInfo['image'.$key]["height"]>0)
				$height=" height='".$prodInfo['image'.$key]["height"]."' ";
			$newText .= "<img style='float:right;' src='".$prodInfo['image'.$key]["src"]."' ".$width.$height."/>\n";
			$newText .= '</td></tr></table>';
		} else {
			$newText .= '<h2><bookmark content="'.$prodInfo['productName'.$key].'"></bookmark>['.$prodInfo['vebtype'.$key].'-'.strtolower($prodInfo['productcode'.$key]).'] '.$prodInfo['productName'.$key].' ('.$prodInfo['section'.$key].')</h2>'."\n";
		}
		
		$newText .= veb_getHTMLtext($prodInfo['description'.$key].$website,$size)."\n";
		$newText .= '</div> <!-- end keep together block -->'."\n\n";
//		$newText .= '</td></tr>'."\n";
	}
//	$newText .= '</table>';

// print __FILE__ . '<hr>' . $docSection; print($newText);

    return $newText; //htmlspecialchars(, ENT_QUOTES);
}
