<?php
/**
 * [CUSTOMFUNCTION|veb_getPDlistprice|SERxxx or PROxx|Timeunit|qty|CUSTOMFUNCTION]
 */

// ===========================================================================
/**
 * This function returns actual product or service price with 2 decimals
 * @since	2024-12-23
 * @author	Luuk Roovers
 *  
 * @param $serprod	prodno or serno
 * @param $timeunit	hour|10min|year
 * @return	string containing formatted price
 **/ 
if (!function_exists('veb_getPDlistprice')) {

	function veb_getPDlistprice($serprod, $timeunit = 'hour', $qty = 1)
	{
		global $adb;
		
		$listprice = '';
		$usageunit = '';
		
		$type = substr($serprod,0,3);
	
		switch ($type) {
			case 'SER':
				$sql="SELECT unit_price, service_usageunit FROM vtiger_service WHERE service_no=?";
				$result = $adb->pquery($sql,array($serprod));

				$data = $adb->fetchByAssoc($result);

				$usageunit = strtolower($data['service_usageunit']);

				switch ($timeunit) {
					case 'year':
						switch ($usageunit) {
							case 'maanden':
								$listprice = $data['unit_price'] * 12;
								break;
							default:
								$listprice = $data['unit_price'];
						}
						break;
						
					case 'month':
						switch ($usageunit) {
							case 'jaar':
								$listprice = $data['unit_price'] / 12;
								break;
							default:
								$listprice = $data['unit_price'];
						}
						break;
						
					default:
						$listprice = $data['unit_price'];
				}
				
				break;
				
			case 'PRO':	
				$sql="SELECT unit_price,c_annual_maintenance FROM vtiger_products WHERE product_no=?";
				$result = $adb->pquery($sql,array($serprod));

				$data = $adb->fetchByAssoc($result);
				
				switch ($timeunit) {
					case 'year':
						$listprice = $data['c_annual_maintenance'];
						break;
					case 'month':
						$listprice = $data['c_annual_maintenance'] / 12;
						break;
					default:
						$listprice = $data['unit_price'];
				}
				
				break;
			default: 
				$listprice = '';
		}

		// if digits = ,00 we might want to show ,= (not implemented)

		$listprice = $listprice * $qty;
		if ($listprice != '') {
			if ($timeunit == '10min') {
				$listprice = $listprice / 6;

				return number_format($listprice, 2, ',', '.');
			} else {

				return number_format($listprice, 2, ',', '.');
			}
			
		} else {
			return "PM";
		}
	}
}