<?php
/**
 * This function returns HTML representation of textfield 
 *  
 * @param $text text to be processed
 * @param $headerText text to be processed as header if filled
 * @change added 
 * @since 190315 table formatting added
 *
 * [- open table
 * [!text!] header cel (<th>text</th>)
 * [text] cel (<td>text</td>)
 * [^text] cel (<td class="center">text</td>)
 * -] close table
 *
 **/ 
function veb_getHTMLtext($text, $size = '12px', $renvooiTextBlock = FALSE, $headerText = "", $headerLvl= "")
{
  global $renvooi;
  
    switch(strtolower($headerLvl)) 
    {
        case 'h1': $hlvl2 = 'h2'; $hlvl3 = 'h3'; break;
        case 'h2': $hlvl2 = 'h3'; $hlvl3 = 'h4'; break;
        case 'h3': $hlvl2 = 'h4'; $hlvl3 = 'h5'; break;
        case 'h4': $hlvl2 = 'h5'; $hlvl3 = 'h6'; break;
        default:
            $hlvl2 = 'h2';
            $hlvl3 = 'h3';
    }

  $renvooiColor = ($renvooiTextBlock) ? " color: rgb(255,0,0); " : " color: rgb(0,0,255); ";

	// @since 190315 we dont use the size anymore 
	// it is set by css styling
	//  $style = ($renvooi) ? 'font-size: '.$size.";".$renvooiColor : 'font-size: '.$size.";";
  $style = ($renvooi) ? $renvooiColor : "";
  
  // first have real paragraphs
  if ($text == '' || $text == '</span>' || $text == false) 
  { 
    return '<!--veb_getHTMLtext-leeg-->';
  }
  else
  {
    $newText = nl2br($text);
  }

  $newText = str_ireplace('<br>','<br />',$newText);
  $newText = str_ireplace('<br/>','<br />',$newText);
  $newTextArray = explode('<br />',$newText);

/*    

  var_dump($newText);

    var_dump($newTextArray);  
  die(__FILE__);
*/

  $ulBlockStarted = false;
  $ulBlockClosed = true;

  $olBlockStarted = false;
  $olBlockClosed = true;

  $tableActive = false;

  $newText = '';
  
  foreach ($newTextArray as $rowId => $textLine) 
  {
    $textLine = str_replace("\r\n",'',$textLine);
    $textLine = str_replace("\n\r",'',$textLine);
    $textLine = str_replace("\n",'',$textLine);
    $textLine = str_replace("\r",'',$textLine);
    $textLine = trim($textLine);

    //file_put_contents('/home/cs1002/public_html/modules/PDFMaker/resources/functions/veb_layout_log.txt', $textLine."\n\n", FILE_APPEND);

// URL parsen
//    $textLine = str_replace("[URL]",'<a href="',$textLine);
//    $textLine = str_replace("[/URL]",'">',$textLine);

    // Image imagetoke by image
    // [IMG]url[/IMG]
    if (substr($textLine,0,5) == "[IMG]") {
        $url = trim(substr($textLine,5));
        $url = str_ireplace('[/IMG]','',$url);
        $textLine = veb_layout_img($url);
//        die($textLine);
    }

    // Table
    if (substr($textLine,0,2) == "[-") {
	$textLine = '';
	$newText .= "\n".'<table class="specificaton">'."\n";
	$tableActive = true;
    } 
    elseif (substr($textLine,0,2) == "-]") {
	$textLine = '';
	$newText .= "\n".'</table>'."\n";
	$tableActive = false;
    } 
    elseif ($tableActive == true) {

		if (substr($textLine,0,1) == "[") {
			$textLine = '<tr><td>'.substr($textLine,1);
			$textLine = str_replace('][','</td><td>',$textLine);
			$textLine = str_replace(']','</td></tr>',$textLine);
			// can be meant to be a th
			$textLine = str_replace('<td>!','<th>',$textLine);
			$textLine = str_replace('!</td>','</th>',$textLine);
			$textLine = str_replace('<td>^','<td class="center" style="text-align:center;" align="center">',$textLine);
			$textLine = str_replace('<td>&euro;','<td class="right" style="text-align:right;width:100px;" align="right">&euro;',$textLine);
			$textLine = str_replace('<td>#','<td class="right" style="text-align:right;width:100px;" align="right">',$textLine);
		}
		
	}

    if (substr($textLine,0,3) == "===" && substr($textLine,-3) == "===")
    {
      $textLine = "<{$hlvl3}>".trim(substr($textLine,3));
      $len = strlen($textLine);
      $len = $len-3;
      $textLine = trim(substr($textLine,0,$len));
      $textLine .= "</{$hlvl3}>";

    }

    // vreemd maar waar dit komt soms ineens voor
    if (substr($textLine,0,4) == " ===" && substr($textLine,-3) == "===")
    {
      $textLine = "<{$hlvl3}>".trim(substr($textLine,4));
      $len = strlen($textLine);
      $len = $len-3;
      $textLine = trim(substr($textLine,0,$len));
      $textLine .= "</{$hlvl3}>";
    }


    if (substr($textLine,0,2) == "==" && substr($textLine,-2) == "==")
    {
      $textLine = "<{$hlvl2}>".trim(substr($textLine,2));
      $len = strlen($textLine);
      $len = $len-2;
      $textLine = trim(substr($textLine,0,$len));
      $textLine .= "</{$hlvl2}>";

    }

    // vreemd maar waar dit komt soms ineens voor
    if (substr($textLine,0,3) == " ==" && substr($textLine,-2) == "==")
    {
      $textLine = "<{$hlvl2}>".trim(substr($textLine,3));
      $len = strlen($textLine);
      $len = $len-2;
      $textLine = trim(substr($textLine,0,$len));
      $textLine .= "</{$hlvl2}>";
    }
    
    if (substr($textLine,0,4) == "  - ")
    {
      if (!$ulBlockStarted)
      {
        $newText .= "\n".'<ul>'."\n";
      }

      $ulBlockStarted = true;
      $ulBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,4))."</li>\n";
    }
    elseif (substr($textLine,0,3) == " - ")
    {
      if (!$ulBlockStarted)
      {
        $newText .= "\n".'<ul>'."\n";
      }

      $ulBlockStarted = true;
      $ulBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,3))."</li>\n";
    }
    elseif (substr($textLine,0,2) == "- ")
    {
      if (!$ulBlockStarted)
      {
        $newText .= '<ul>'."\n";
      }

      $ulBlockStarted = true;
      $ulBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,2))."</li>\n";
    }
    elseif (substr($textLine,0,1) == "-")
    {
      if (!$ulBlockStarted)
      {
        $newText .= '<ul>'."\n";
      }

      $ulBlockStarted = true;
      $ulBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,1))."</li>\n";

      // @change lro 150618 added for ol
    }
    elseif (substr($textLine,0,3) == " # ")
    {
      if (!$olBlockStarted)
      {
        $newText .= '<ol>'."\n";
      }

      $olBlockStarted = true;
      $olBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,3))."</li>\n";
    }
    elseif (substr($textLine,0,2) == "# ")
    {
      if (!$olBlockStarted)
      {
        $newText .= '<ol>'."\n";
      }

      $olBlockStarted = true;
      $olBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,2))."</li>\n";
    }
    elseif (substr($textLine,0,1) == "#")
    {
      if (!$olBlockStarted)
      {
        $newText .= '<ol>'."\n";
      }

      $olBlockStarted = true;
      $olBlockClosed = false;

      $newText .= '<li style="'.$style.'">'.trim(substr($textLine,1))."</li>\n";
    }
    elseif (substr($textLine,0,2) == "<t" || substr($textLine,0,2) == "</" )
    {
      // probably a html table / or end command, so do't wrap the line in <p></p>
      $newText .= $textLine."\n";
    }
    else
    {
      if ($ulBlockStarted)
      {
        $newText .= "</ul>\n";
        $ulBlockClosed = true;
      }

      $ulBlockStarted = false; 
 
      if ($olBlockStarted)
      {
        $newText .= "</ol>\n";
        $olBlockClosed = true;
      }

      $olBlockStarted = false; 

    // @change lro deze regel stond uit en de volgende regel vervangt de hele inhoud van de nieuwtext ipv er iets bij te zetten
    // effect was dat de content niet meer in de offerte zichtbaar was
    // @change lro 190302 return '' if no content (no empty paragraph
    $textLine = trim($textLine);
    $styleText = ($style) ? ' style="'.$style.'"' : '';
    	
	if (!empty($textLine)) {
		$newText .= '<p'.$styleText.'>'.$textLine."</p>\n";
	} 
//      $newText = $textLine;
//      $newText .= $textLine;
    }




  }
/*  
  var_dump($newText);
  die(__FILE__);
*/
  if (!$ulBlockClosed)
  {
    $newText .= "</ul>\n";
    $ulBlockClosed = true;
  }

  if (!$olBlockClosed)
  {
    $newText .= "</ol>\n"; $olBlockClosed = true;
  }

  // @change lro 130325 add header in quote tekst. Use only for short / summary quotes !
  if ($newText && $headerText)
  {
	$styleText = ($style) ? ' style="'.$style.'"' : '';

    switch(strtolower($headerLvl)) 
    {
        case 'h1':
        case 'h2':
        case 'h3':
        case 'h4':
            $newText= '<'.$headerLvl.'>'.trim($headerText).'</'.$headerLvl.'>'."\n".$newText;
            break;
        default:
            $newText = '<p'.$styleText.'><b>'.trim($headerText).':</b></p>'."\n".$newText;
    }
  }

  if ( $renvooi )
  {
    if ($renvooiTextBlock)
    {
     //$newText = "[>".$newText."<]";
    } else {
     //$newText = "[START EIGEN TEKST]".$newText."[EINDE EIGEN TEKST]";
    }
  }
  
  // final cleanup
  $newText = str_replace('<p><ol>','<ol>',$newText);
  $newText = str_replace('</ol></p>','</ol>',$newText);
  $newText = str_replace('<p><h3>','<h3>',$newText);
  $newText = str_replace('</h3></p>','</h3>',$newText);
  $newText = str_replace('<p><p>','<p>',$newText);
  $newText = str_replace('</p></p>','</p>',$newText);  
  $newText = str_replace('<p><ul></p>','<ul>',$newText);
  $newText = str_replace('<p><li','<li',$newText);
  $newText = str_replace('</li></p>','</li>',$newText);
  
 //  mail('lro@vicus.nl', 'HTMLtext: ' . $headerText,var_export($newText,true));
//  file_put_contents('/home/cs1002/public_html/modules/PDFMaker/resources/functions/veb_layout_log.txt', $newText."\n\n", FILE_APPEND);
//   die($newText);
// @change lro 250123
	$pos = stripos($newText, '[PAGEBREAK]');
	if ($pos !== false) {
		$pagebreak = getPageBreaks(1);
		$newText = str_replace('[PAGEBREAK]',$pagebreak,$newText);
	}

	// EM
	$emstyle = '<em style="color:#DC7B34;">';
	$newText = str_replace('<em>',$emstyle,$newText);

  return $newText;
}

/**
 * $url = ../img.png?size=120x240&align=left
 */
function veb_layout_img($url)
{
    $width = 1024;
    $height = 768;

    // split on ? to get the size
    $url = str_ireplace('&amp;','&',$url);
    $query = parse_url($url, PHP_URL_QUERY );

    parse_str($query, $output);
//    echo "<li>".print_r($output);
    if (isset($output['size']) ) { 
        $sizes = explode('x',$output['size']);
        $width = ($sizes[0] >0) ? $sizes[0] : '';
        $height = ($sizes[1] >0) ? $sizes[1] : '';
    }

//print '/home/cs1002/public_html/img/'.parse_url($url, PHP_URL_PATH );
    $imagepath = 'img/'.parse_url($url, PHP_URL_PATH );
    $image = getimagesize($imagepath);
    
    if ($width > 0) {
        $cssWidth =  ' width:'.$width.'px; ';
    } else {
        $r = $image[1] / $height;
        $w = round($image[0] / $r,0);
        $cssWidth = " width:{$w} px; ";
    }
    
    if ($height > 0) {
        $cssHeight = ' height:'.$height.'px; ';
    } else {
        $r = $image[0] / $width;
        $h = round($image[1] / $r,0);
        $cssHeight = " height:{$h}px; ";
    }
    
    $align = ( in_array($output['align'], array('left','right','middle') )) ? $output['align'] : 'middle';
    
    // remove $query from url
    $url = str_ireplace($query,'',$url);
    $url = veb_prepare_url($url, 'img');

    $return = '<img style="padding:0; margin:0; border:1px solid grey; float:'.$align.';'.$cssWidth.$cssHeight.'" src="'.$url.'" >';
    return $return;
}