<?php
/*
 * [CUSTOMFUNCTION|veb_faseProducts|$QUOTES_CRMID$|projectaanpak_k|12px|CUSTOMFUNCTION]
 *
 */
// include_once('veb_pdfm_config.php');

function veb_faseProducts($crmid, $docSection, $size = '12px')
{
  global $adb, $textblock;

  // @change 150616 lro added
  // get switches from object
  $result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
  $row = $adb->fetchByAssoc($result);
  $my_focus = CRMEntity::getInstance($row['setype']);
  $my_focus->id = $crmid;
  $my_focus->retrieve_entity_info($crmid,$row['setype']);

  $fields = $my_focus->column_fields;

  // get the config switches
  $pdfmConfig = new pdfmConfig($fields['c_picklist_settings']);

  unset($my_focus,$result,$row);

  $newText = '';
  $keywords = preg_split("/_/", $docSection);

  if (in_array(strtoupper($keywords[1]), array('A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','X') ) )
  {
    $productDetailsTable = array();

    // we are handling a project block that needs product/servcies details
    $result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
    $row = $adb->fetchByAssoc($result);
    $my_focus = CRMEntity::getInstance($row['setype']);
    $my_focus->id = $crmid;
    $my_focus->retrieve_entity_info($crmid,$row['setype']);
    $associated_prod = getAssociatedProducts($row['setype'], $my_focus);

// print '<pre>'; print_r($associated_prod); die();
    $associated_prod = lroGetProductDetails($associated_prod);
// print '<pre>'; print_r($associated_prod); die(__FILE__);

    foreach ($associated_prod as $id => $productInfo)
    {
      $sortcode = ucfirst($productInfo['sortorder'.$id]);

      if ( substr($sortcode,0,1) == strtoupper($keywords[1] ) )
      {
        // we have a hit! so add the info for the table with details
        // need to add uniq id to prevent clustering duplicates
        $productDetailsTable[$productInfo['phase'.$id].$productInfo['sortorder'.$id].$productInfo['productcode'.$id].$id] = array(
          'entityType' => $productInfo['entityType'.$id],
          'qty' => $productInfo['qty'.$id],
          'usageunit' => $productInfo['usageunit'.$id],
          'productcode' => $productInfo['productcode'.$id],
          'productName' => $productInfo['productName'.$id],
          'section' => $productInfo['section'.$id],
          'listPrice' => $productInfo['listPrice'.$id],
          'productTotal' => $productInfo['productTotal'.$id],
          'phase' => $productInfo['phase'.$id],
          'comment' => $productInfo['comment'.$id],
          'tagline' => $productInfo['tagline'.$id],
        );
      }
    }

    ksort($productDetailsTable);

    if (!empty ($productDetailsTable))
    {
      if ($pdfmConfig->getPicklistValue('budgettbls') === true)
      {
        $newText .=  '<table border="0" cellpadding="5" cellspacing="0" width="100%" autosize="1.0" style="page-break-inside:avoid;">';
        $newText .=  '<tr>';
        // $newText .=  '<th width="80px" align="left" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Productcode</th>';
        // $newText .=  '<th width="80px" align="left" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Id</th>';
        $newText .=  '<th width="43%" align="left" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Omschrijving</th>';
        $newText .=  '<th width="20%" align="left" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Kostensoort</th>';
        $newText .=  '<th width="10%" align="right" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Prijs p/e</th>';
        $newText .=  '<th width="7%" align="right" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Aantal</th>';
        $newText .=  '<th width="10%" align="left" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Eenheid</th>';
        $newText .=  '<th width="10%" align="right" style="border-top: 1px solid #777;border-bottom: 1px solid #777;">Totaal</th>';
        $newText .=  '</tr>';

        foreach ($productDetailsTable as $id => $prodLine)
        {
          $phaseText = ($prodLine['phase']) ? ' - Fase '.$prodLine['phase'] : "";

          $newText .=  '<tr>';
          // $newText .=  '<td align="left" style="padding: 5px 0 0 5px; border-bottom: 1px solid #777;"><span style="font-size: 10px;">'.$prodLine['productcode'].'</td>';
          // $newText .=  '<td align="left" style="padding: 5px 0 0 5px; border-bottom: 1px solid #777;"><span style="font-size: 10px;">'.$id.'</td>';
          $newText .= '<td align="left" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;">'.$prodLine['productName'].'</td>';
          $newText .= '<td align="left" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;">'.$prodLine['section'].$phaseText.'</td>';
          $newText .= '<td align="right" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;">&euro;&nbsp;'.formatNumberToPDF($prodLine['listPrice']).'</td>';
          $newText .= '<td align="right" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;" >'.number_format($prodLine['qty'], 1, ',', '.').'</td>';
          $newText .= '<td align="left" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;" >'.getTranslatedString($prodLine['usageunit'],$prodLine['entityType']).'</td>';
          $newText .= '<td align="right" style="padding: 5px 0 0 5px;border-bottom: 1px solid #777;"><span style="font-size: 10px;">&euro;&nbsp;'.formatNumberToPDF($prodLine['productTotal']).'</td>';
          $newText .= '</tr>';
        }

        // [entityType2] => Products
        // [productName2] => vtiger Klantportaal
        // [hdnProductcode2] => vt-port-std
        // [qty2] => 1.000
        // [listPrice2] => 175.000
        // [unitPrice2] => 175.00
        // [productTotal2] => 175
        // [netPrice2] => 175
        // [sortorder2] => B-VT-PORT
        // [section2] => Add-on
        // [usageunit2] => Installatie
        // [productcode2] => vt-port-std
        $newText .=  '</table><br />';
      }
      else
      {
        //@change ARK
        //$newText .= '<p<em>>Opgenomen in deze offerte:</em><br />';
        $newText .= '<h3>Opgenomen in deze offerte <span style="font-size:12px;">(zie bijlage voor uitleg)</span></h3>';
        $newText .= '<ul>';
        $productDetailsTablepassed = array();

        $counter4dot = 0;
        $max4dot = count($productDetailsTable);

        foreach ($productDetailsTable as $id => $prodLine)
        {
          // @change lro 151022 to have correct punctuation.
          $counter4dot++;
          $separator = ($counter4dot == $max4dot) ? '.' : ';';

          // @change 150926 lro now we see duplicates
          // so we need to normalize the array before we print the results
          if (!isset($productDetailsTablepassed[$prodLine['productName']]))
          {
            $tagline = (isset($prodLine['tagline']) && $prodLine['tagline'] != '') ? " - ". $prodLine['tagline'] : '';
            $tagline = rtrim($tagline,'.!? ');
            $newText .= '<li>'.$prodLine['productName'].$tagline.$separator.'</li>';
            
          }

          $productDetailsTablepassed[$prodLine['productName']] = $prodLine['productName'];
        }

        unset($productDetailsTablepassed);
        $newText .= '</ul></p><br />';
      }
    }
    else
    {
      // $keywords[1]
      if (isset($textblock['projectaanpak_'.$keywords[1]]['nobudget']['text']))
      {
        $newText .= veb_getHTMLtext($textblock['projectaanpak_'.$keywords[1]]['nobudget']['text'],$size);
      }
      else
      {
        $newText .= '<p>Voor (andere) werkzaamheden in deze paragraaf is geen budget gereserveerd; derhalve maken ze geen onderdeel uit van deze prijsopgave.</p>';
      }
    }
  }

//print __FILE__ . '<hr>' . $docSection; print($newText);
//file_put_contents('/home/cs1002/public_html/modules/PDFMaker/resources/functions/akrlog.txt', $newText."\n\n", FILE_APPEND);

//$newText = "<p><em>Opgenomen in deze offerte:</em></p>";

    return $newText; //htmlspecialchars(, ENT_QUOTES);
}
