<?php

/**
 * This function returns HTML representation table with specifications
 *  
 * @param $text text to be processed
 * @param $headerText text to be processed as header if filled
 * @change added 
 *
 * */
function veb_getComponentsForInstallations($installationsid)
{
    global $adb;

    $debug = true;
    $data = array();

    $sql = "SELECT *, p.productname, pc.cf_2054 as highestversion, pc.cf_2031 as cmdb_productkey, p.c_version_compatibility
	        FROM vtiger_components AS c
	        INNER JOIN vtiger_componentscf AS cc
	        ON c.componentsid = cc.componentsid
	        INNER JOIN vtiger_crmentity AS ce
	        ON ce.crmid = c.componentsid
	        INNER JOIN vtiger_products AS p
	        ON c.comp_product = p.productid
	        INNER JOIN vtiger_productcf AS pc
	        ON c.comp_product = pc.productid
	        WHERE 
	          c.comp_installation={$installationsid} 
	          AND c.comp_status IN ( 'Active', 'Inactive') and p.productcategory IN ('Add-on','Maatwerk','Patch','Hoofdproduct')
	          AND ce.deleted=0;";
    // AND cf_2037 = 'Active' 


    if ($debug)
        print $sql;

    $result = $adb->query($sql);

    if ($result)
        while ($r = $result->fetchRow()) {
            $data[] = $r;
        }

    return $data;
}

function veb_getInstallationsForAccount($accountid)
{
    global $adb;

    $debug = true;
    $data = array();

    $sql = "SELECT i.*, p.productname, ic.cf_2060 as phpversion, ic.cf_2037 as scanstatus, ic.cf_2068 as hostingmodel, i.agent_call_status
	        FROM vtiger_installations AS i
	        INNER JOIN vtiger_installationscf AS ic
	        ON i.installationsid = ic.installationsid
	        INNER JOIN vtiger_crmentity AS ce
	        ON ce.crmid = i.installationsid
	        INNER JOIN vtiger_products AS p
	        ON i.inst_main_product = p.productid
	        INNER JOIN vtiger_productcf AS pc
	        ON p.productid = pc.productid
	        WHERE
	          i.inst_organisation={$accountid} 
	          AND ic.cf_2037 IN ( 'Active', 'Active No Scan' ) and p.productname LIKE '%tiger%'
	        	AND ce.deleted=0;";

    if ($debug)
        print $sql;
    $result = $adb->query($sql);

    if ($debug)
        print_r($adb);

    if ($result)
        while ($r = $result->fetchRow()) {
            $data[] = $r;
        }

    return $data;
}

function veb_calcversion($data)
{
    $versie = substr($data['inst_version'], 0, 3);
    switch ($versie)
    {
        case 5.1:
        case 5.2:
        case 5.3:
        case 5.4: $stappenTot65 = 6; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.0: $stappenTot65 = 5; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.1: $stappenTot65 = 4; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.2: $stappenTot65 = 3; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.3: $stappenTot65 = 2; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.4: $stappenTot65 = 1; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 6.5: $stappenTot65 = 0; $stappenTot75 = $stappenTot65 + 6;
            break;
        case 7.0: $stappenTot65 = 0; $stappenTot75 = 6;
            break;
        case 7.1: $stappenTot65 = 0; $stappenTot75 = 5;
            break;
        case 7.2: $stappenTot65 = 0; $stappenTot75 = 4;
            break;
        case 7.3: $stappenTot65 = 0; $stappenTot75 = 3;
            break;
        case 7.3: $stappenTot65 = 0; $stappenTot75 = 2;
            break;
        case 7.4: $stappenTot65 = 0; $stappenTot75 = 1;
            break;
        case 7.5: $stappenTot65 = 0; $stappenTot75 = 0;
            break;            
        default:
            $stappenTot65 = 0;
	    $stappenTot75 = 0;
            break;
    }


    $prijsNaar65 = 390 + ($stappenTot65 * 273); // iedere stap = 70% van 390 = 273
    $prijsNaar75 = 390 + (($stappenTot75 - 1) * 312 ); // iedere stap = 80% van 390 = 312

    return array(
        'stappenTot65' => $stappenTot65,
        'stappenTot75' => $stappenTot75,
        'prijsNaar65' => $prijsNaar65,
        'prijsNaar75' => $prijsNaar75
    );
}

function veb_getInstallationAdvise($data)
{

	$kosten = array(
		'ssl' => '&euro;122,- per jaar',
	);


    $versie = substr($data['inst_version'], 0, 3);

    $extraModules = '';
    $keuzeText = '';


    $text = '';
    // check SSL
    if (substr($data['url2'], 0, 5) != 'https')
    {
        $ssl = "- Beveiligingsrisico -- Jouw systeem werkt nog niet met een SSL certificaat. Wij adviseren je dringend om een ssl-certificaat te laten activeren. De kosten hiervoor zijn {$kosten['ssl']}. Certificaten van Let's Encrypt, Cpannel en Direct Admin zijn technisch net zo veilig, maar zijn zelf gratis. Wel steekt Vicus hier tijd in. De kosten daarvan berekenen wij aan je door.\n";
        $extraModules = "[   ] Wij bestellen een 'gratis' SSL certificaat. De servicefee bedraagt {$kosten['ssl']}.";
    } else
    {
        $ssl = '';
    }

    $pricing = veb_calcversion($data);
    $stappenTot65 = $pricing['stappenTot65'];
    $stappenTot75 = $pricing['stappenTot75'];
    $prijsNaar65 = $pricing['prijsNaar65'];
    $prijsNaar75 = $pricing['prijsNaar75'];

    switch (true)
    {

        case ($versie < 6.0):

            $text .= "Jullie gebruiken nu: Vtiger CRM versie welke lager is dan 6.0
- jouw Vtiger CRM is sterk verouderd en is daarmee ernstig gevoelig voor hackers (niet AVG proof);
- deze versie van Vtiger CRM is niet compatible met de minimaal geadviseerde PHP versie;
- eventuele add-ons zijn niet compatible met de minimaal geadviseerde PHP versie.
Wij adviseren:
- upgraden naar Vtiger CRM 7.5 (upgrade naar Vtiger CRM 6.5 is net zo duur). 
- De upgrade naar versie 7.5 kost normaliter &euro;390,- per versie in {$stappenTot75} stap(pen). Tot 30  april 2023 bieden wij deze standaard upgrade aan voor de prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).
{$ssl}- voor gelicenceerde modules moet een nieuwe licentie worden gekocht;
- eventueel maatwerk moeten we ombouwen;
";
            $keuzeText .= "[   ] Wij willen onze Vtiger CRM upgraden naar versie 7.5 voor de speciale prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).";
            break;

        case ($versie < 6.5):

            $text .= "Jullie gebruiken nu: Vtiger CRM versie lager dan 6.5
- jouw Vtiger CRM is verouderd en is daarmee gevoelig voor hackers (niet AVG proof);
- deze versie van Vtiger CRM is niet compatible met de minimaal geadviseerde PHP versie;
- eventuele add-ons zijn niet compatible met de minimaal geadviseerde PHP versie.
Wij adviseren:
- upgraden naar Vtiger CRM 7.5 (op PHP versie 8). 
- De upgrade naar versie 7.5 kost normaliter &euro;390,- per versie in {$stappenTot75} stap(pen). Tot 30  april 2023 bieden wij deze standaard upgrade aan voor de speciale prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).
{$ssl}- voor gelicenceerde modules moet een nieuwe licentie worden gekocht;
- eventueel maatwerk moeten we ombouwen.
";

            $keuzeText .= "[   ] Wij willen onze Vtiger CRM upgraden naar versie 7.5 voor de speciale prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).";
            break;

        case ($versie == 6.5):

            $text .= "Jullie gebruiken nu: Vtiger CRM 6.5
- jouw Vtiger CRM is verouderd en is daarmee gevoelig voor hackers (niet AVG proof);
- deze versie van Vtiger CRM is niet compatible met de minimaal geadviseerde PHP versie 8;
- eventuele add-ons zijn niet compatible met de minimaal geadviseerde PHP versie 8.
Wij adviseren:
- upgraden naar Vtiger CRM 7.5 (op PHP versie 8). 
- De upgrade naar versie 7.5 kost normaliter &euro;390,- per versie in {$stappenTot75} stap(pen). Tot 30  april 2023 bieden wij deze {$stappenTot75} stappen aan voor de prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).
{$ssl}- voor gelicenceerde modules moet meestal een nieuwe licentie worden gekocht;
- eventueel maatwerk moeten we ombouwen.";

            $keuzeText .= "[   ] Wij willen onze Vtiger CRM upgraden naar versie 7.5 voor de prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).";

            break;

        case ($versie < 7.5):

            $text .= "Jullie gebruiken nu: Vtiger CRM 7, maar lager dan 7.5
- jouw Vtiger CRM is verouderd en werkt niet goed op PHP versie 8 en is daarmee gevoelig voor hackers;
Wij adviseren:
- upgraden naar Vtiger CRM 7.5 (op PHP versie 8).
- Tot 30  april 2023 bieden wij bovenstaande aan voor &euro;{$prijsNaar75},- (exclusief maatwerk en modules).
{$ssl}- voor gelicenceerde modules hoeft binnen de major release meestal geen licentie te worden gekocht, wel moet voor sommige modules (o.a. PDF Maker en EMAIL Maker) een upgradefee aan de leverancier worden betaald;
- eventueel maatwerk blijft zeer waarschijnlijk werken.
";
            $keuzeText .= "[   ] Wij willen onze Vtiger CRM upgraden naar versie 7.5 voor de prijs van &euro;{$prijsNaar75},- (exclusief maatwerk en modules).";
            break;

        case ($versie == 7.5):

            $text .= "Jullie gebruiken nu: Vtiger CRM 7.5
{$ssl}- De PHP versie moet naar 8, dit doen we gratis, echter het kan zijn dat er plug-ins of maatwerk in uw systeem zitten die er niet tegen kunnen. Wij gaan er vanuit dat u het systeem zelf test. Eventuele problemen kunnen wij voor je oplossen via onze servicedesk tegen onze gebruikelijke tarieven.";

            $keuzeText .= "[   ] Upgrade mijn systeem naar PHP versie 8 na inplanning, in overleg. Informeer ons zodra dit is gedaan, dan testen wij zelf of alles naar behoren werkt. Eventuele problemen lost Vicus op via de servicedesk tegen het gebruikelijke uurtarief.";

            break;

        default:
            $text .= "{$ssl}We hebben nog onvoldoende informatie om een concreet advies te geven. Neem contact met ons op als u dit systeem persoonlijk wilt bespreken.";
    }

    $phpversie = $data['inst_version'];

    $keuzeText .= "\n<b>Er kan maatwerk in jouw systeem aanwezig zijn</b>:
Maatwerk kunnen wij niet geautomatiseerd inventariseren. Graag vernemen wij jouw voorkeur:
[   ] Wij hebben geen maatwerk in onze Vtiger CRM.
[   ] Alle maatwerk mag vervallen, we gaan verder met een standaard installatie (aanbevolen).
[   ] Wij hebben maatwerk en willen dat graag behouden. Graag offerte hiervoor van Vicus.";
    $keuzeText .= '<p style="font-size:10px"><b>Modules:</b></p>';
    $keuzeText .= '<p style="font-size:10px">Vtiger CRM kent veel standaard modules. Voor de meeste is er een variant voor Vtiger CRM 7. Een upgrade is ook een goed moment op alle modules die u niet meer gebruikt te laten vervallen. Wij zijn er reeds vanuit gegaan dat alle modules die nu op inactief staan niet meer gebruikt worden.</p>';

  // [  ] Add-ons waarvoor geen upgrade van voorhanden (EOL) is mogen vervallen.
//[  ] Vervang alle EOL modules door een alternatief als dat beschikbaar is.
//[  ] Wij willen graag offerte voor het herbouwen van de add-ons waar geen upgrade voor beschikbaar is.

  return array('text' => $text, 'keuzetext' => $keuzeText, 'extraModules' => $extraModules);
}

function veb_getInstallationAlternative($data)
{

   $versie = substr($data['inst_version'], 0, 3);
    $model = $data['hostingmodel'];

    $text = "<p>Als jouw budget nu niet toetstaat om de voorgestelde upgrade door te voeren hebben we voor dit systeem de volgende alternatieven:</p><ol>";

    // als vps dan gelden andere regels
    if ($model == 'Vicus VPS')
    {
        $text .= "<li>Omdat je al een VPS huurt bij Vicus kun je daarop blijven draaien met de PHP versie zoals je zelf wilt. Uiteraard raden we oude versies af. Deze situatie is per definitie niet veilig, niet avg-proef en zeker niet toekomst-vast. Aan het laten draaien as-is zijn geen extra kosten verbonden.</li>";
        $text .= "</ul>";
        return $text;
    }

    switch (true)
    {
        case ($versie < 6.5):
            $text .= "<li>Upgrade naar Vtiger CRM 6.5 (op PHP versie 5.6, dat is lager dan minimaal geadviseerd, maar maximaal haalbaar binnen de Vtiger CRM 6 reeks).</li>";
        //  De upgrade naar versie 6.5 kost normaliter &euro;385,- per versie in {$stappenTot65} stap(pen). Tot 31 januari bieden wij deze standaard upgrade aan voor de speciale prijs van &euro;{$prijsNaar65},-

        case ($versie < 7.0):
//            $text .= "<li>We kunnen uw Vtiger CRM nog voor maximaal 1 jaar op een speciale server plaatsen die oudere, niet officieel ondersteunde versies van de systeemsoftware bevat. Deze situatie is per definitie niet veilig, niet avg-proef en zeker niet toekomst-vast. We raden deze keuze dus af. Dit kunt u eventueel ook tijdelijk doen. De eenmalige kosten hiervan zijn &euro;150,-.</li>";

            $text .= "<li>We kunnen een standaard installatie van Vtiger CRM 7.5 neerzetten en daar jouw gegevens naar overzetten. Als je nu alleen enkelvoudige modules zoals Gebruikers, Organsiaties, Contacten, Leads en Verkoopkansen gebruikt is dat een prima alternatief om te doen. Als je ook de complexere modules zoals offertes, facturen en orders wilt overzetten kun je meestal beter het upgradepad volgen. Ook als je (veel) eigen velden hebt aangemaakt en deze wilt behouden kun je meestal beter upgraden. Om kosten te besparen zetten we Rapporten, lijsten, profielen, rollen, sjablonen en werkstromen niet over; die kun je dan zelf opnieuw aanmaken in het nieuwe systeem.</li>";
            break;

        case ($versie < 7.2):
        default:
            $text .= "<li>We kunnen jouw Vtiger CRM op een speciale server zetten samen met andere klanten die niet willen of kunnen upgraden. Deze situatie is per definitie niet veilig, niet avg-proef en zeker niet toekomst-vast. We raden deze keuze dus af. Dit kun je eventueel ook tijdelijk doen. De eenmalige kosten hiervan zijn &euro;250,-.</li>";
    }
    $text .= "</ol>";

    return $text;
}

function veb_contact_installations($accountid)
{
    $debug = true;
    $table = '';
    $introShown = false;
    $counter = 0;

    $installations = veb_getInstallationsForAccount($accountid);

    if ($debug)
        print_r($installations);

    $nofInstallations = count($installations);

    if (count($installations) > 0)
        foreach ($installations AS $key => $data)
        {
            if ($debug)
                print_r($data);

            $addOns = veb_getComponentsForInstallations($data['installationsid']);

            // if not scanned, onpremise of ondemand we have no more info
            // No Scan
            if ($data['scanstatus'] == 'Actief No Scan' OR ( $data['agent_call_status'] != 'Agent completed' AND $data['agent_call_status'] != 'Agent updated'))
            {
                // ondemand -> prima in orde, niet te scannen
                // onpremise -> niet te scannen, evt d=cmd agent toevoegen

                $table .= "<p>Dit systeem kan niet worden gescand. Controleer zelf s.v.p. de versie van Vtiger CRM (onder het inlogscherm) en de PHP versie (vraag jouw systeembeheerder). Indien jouw versie van Vtiger CRM lager is dan versie 7.5 dan adviseren wij je uit veiligheidsoverweging te upgraden naar versie 7.5. Indien je hierover vragen hebt kun je contact opnemen met onze servicedesk.</p>";
            } else
            {
                if (!$introShown)
                {
;
                    $table .= "<p>Wij hebben de volgende configuratie(s) voor je in beheer.</p>";
                    $table .= "<ol>";
                    foreach ($installations AS $key3 => $data3)
                    {
                        $version = substr($data3['inst_version'], 0, 3);
                        $table .= "<li>{$data3['productname']} {$version} {$data3['url2']}</li>";
                    }
                    $table .= "</ol>";
                    $table .= "<p>Dit advies is gegenereerd vanuit ons configuratiemanagement systeem (CMDB). Dit CMDB-systeem leest geautomatiseerd het aantal actieve gebruikers, php-versie, add-ons en veries uit van alle Vtiger CRM installaties. Wij kunnen niet garanderen dat wij daarmee alle modules volledig in beeld hebben. Daarnaast kunnen we hiermee nog geen maatwerk analyseren.</p>";

//                    $table .= "<p>Een upgrade vind plaats in stappen als volgt: 6.0->6.1->6.2->6.3->6.4->6.5->7.0->7.1->7.2->7.3->7.4->";
                    $table .= "<p>Een upgrade vanaf versie {$version} vind plaats in stappen als volgt: ";
                    
                    $versionFloot = floatval($version);
                    if ($versionFloot < 6) { $table .= "5.x-> "; }
                    if ($versionFloot < 6.1) { $table .= "6.0-> "; }
                    if ($versionFloot < 6.2) { $table .= "6.1-> "; }
                    if ($versionFloot < 6.3) { $table .= "6.2-> "; }
                    if ($versionFloot < 6.4) { $table .= "6.3-> "; }
                    if ($versionFloot < 6.5) { $table .= "6.4-> "; }
                    if ($versionFloot < 7.0) { $table .= "6.5-> "; }
                    if ($versionFloot < 7.1) { $table .= "7.0-> "; }
                    if ($versionFloot < 7.2) { $table .= "7.1-> "; }
                    if ($versionFloot < 7.3) { $table .= "7.2-> "; }
                    if ($versionFloot < 7.4) { $table .= "7.3-> "; }
                    if ($versionFloot < 7.5) { $table .= "7.4-> "; }
                    $table .= "7.5</p>";

                    
                    $table .= "\nAlle genoemde prijzen zijn exclusief ombouwen van maatwerk, (om)bouwen van add-ons waar geen vervanging voor is, licentiekosten van add-ons en btw. Wij gaan bovendien uit van de nodige zelfwerkzaamheid (o.a. bij het omzetten van rapporten, pdf- en email templates, filters en werkstromen). Je ontvangt daarvoor van ons een instructie.";
                } else
                {
                    // pagebreak does not work!
                    //$table .= "<div style='page-break-after: always;'><span style='display: none;'>&nbsp;</span></div>";
                }
                $introShown = true;
            }

            $counter++;

            $table .= '<div style="page-break-inside: avoid;">';
            $table .= "<h1>Systeem {$counter} {$data['url2']}</h1>";
            $table .= '<table border=1>';
            $table .= '<thead>';
            $table .= '<tr>';
            $table .= "<th width=60% colspan=2>Systeem {$data['productname']}</th><th width=40% colspan=2>Gebruikers</th>";
            $table .= '</tr>';
            $table .= '</thead>';
            $table .= '<tbody>';

            $table .= '<tr>';
            $table .= "<td rowspan=2 colspan=2>{$data['productname']}<br>Versie {$data['inst_version']} Status: {$data['installation_status']}<br>{$data['hostingmodel']} Url: {$data['url2']}</td>";
            $table .= "<th>In contract</th><th>In gebruik</th>";
            $table .= '</tr>';
            $table .= '<tr>';
            $nofUsers = $data['users_in_use'] - 2; // minus Vicus + admin 
            $table .= "<td>{$data['users_in_contract']}</td><td>{$nofUsers}</td>";
            $table .= '</tr>';

            $table .= '<thead>';
            $table .= '<tr>';
            $table .= '<th width=40%>Onderdeel (Scanstatus: ' . $data['scanstatus'] . ' ' . $data['agent_call_status'] . ')</th><th width=20%>Huidige versie</th><th width=20%>Beschikbare versie of alternatief</th><th width=20%>Beschikbaar voor</th>';
            $table .= '</tr>';
            $table .= '</thead>';
            $table .= '<tbody>';

            $table .= '<tr>';
            $table .= "<td>PHP programmataal (Systeemsoftware)</td>";
            $phpv = (!empty($data['phpversion'])) ? $data['phpversion'] : '< 7.1';
            $table .= "<td>{$phpv}</td>";
            $table .= "<td>8</td>";
            $table .= "<td>Vtiger CRM 7.5</td>";
            $table .= '</tr>';

            $securePasswordsModule = false;
            $portalModule = false;
            $adviseModules = array();
            foreach ($addOns AS $key => $data2)
            {
                if ($data2['cmdb_productkey'] == 'PassWords' OR $data2['cmdb_productkey'] == 'VebPasswords')
                {
                    $securePasswordsModule = true;
                }

                if ($data2['cmdb_productkey'] == 'SecuredFields')
                {
                    $securedFieldsModule = true;
                }


                if ($data2['cmdb_productkey'] == 'Portal')
                {
                    $portalModule = true;
                }
//        print_r($data2); die();
                $comp_status = $data2['comp_status'];
                $statusText = '';
                $rowstyle = '';
                if ($comp_status == 'Inactive')
                {
                    $rowstyle = 'background-color:#efefef;';
                    $statusText = ', Inactief';
                }
                $table .= '<tr style="' . $rowstyle . '">';
                $table .= "<td>{$data2['productname']} ({$data2['productcategory']}{$statusText})</td>";
                $compversion = !empty($data2['comp_version']) ? $data2['comp_version'] : ' ';
                $table .= "<td>{$compversion}</td>";
                $highestversion = !empty($data2['highestversion']) ? $data2['highestversion'] : ' ';
                $table .= "<td>{$highestversion}</td>";
                if ($data2['c_version_compatibility'] != 'n.v.t.')
                {
                    $c_version_compatibility = !empty($data2['c_version_compatibility']) ? 'Vtiger CRM ' . $data2['c_version_compatibility'] : ' ';
                }
                $table .= "<td>{$c_version_compatibility}</td>";
                $table .= '</tr>';

                if ($comp_status == 'Active')
                {
                    $adviseModules[] = $data2;
                }
            }
            $table .= '</tbody>';
            $table .= '</table>';

            $table .= '<h2>Conclusie, advies en aanbod:</h2>';
            $advies = veb_getInstallationAdvise($data);
            $table .= veb_getHTMLtext($advies['text'], '12px');
            $keuzetext = $advies['keuzetext'];
            $extraModules = $advies['extraModules'];
            $alternative = veb_getInstallationAlternative($data);

            $table .= veb_getHTMLtext($alternative);
            // als geen secure passwords dan aanbieden
            $table .= "<p>We kunnen nog niet alles geautomatiseerd controleren.</p>";
            $table .= "<ol>";
            if (!$securePasswordsModule)
            {
                $table .= "<li>Hebben jullie de module 'Secure passwords voor Vtiger CRM' al? Hiermee motiveer je jouw medewerkers om regelmatig hun wachtwoord aan te passen en een veilig wachtwoord te kiezen. Daarnaast werkt het als eerste verdediging tegen robots die proberen in te loggen. Deze module bieden wij tot 30  april 2023 in combinatie met een upgrade aan voor &euro;349,- (i.p.v. &euro;495,-) + &euro;96,72/jr.</li>";
                $extraModules .= "\n[   ] Wij bestellen 'Secure passwords voor Vtiger CRM' voor &euro;349,- (i.p.v. &euro;495,-) + &euro;96,72/jr.";
            }
            /*
            if (!$securedFieldsModule)
            {
                $table .= "<li>Heeft u de module 'Secured fields voor Vtiger CRM' al? Hiermee kunt u gevoelige (AVG) gegevens encrypted opslaan. Deze module bieden wij tot 30  april 2023 in combinatie met een upgrade aan voor &euro;395,- (i.p.v. &euro;497,-) voor 1 veld + &euro;89,- per jaar (extra velden beveiligen kost eenmalig &euro;101,- per veld).</li>";
                $extraModules .= "\n[   ] Wij bestellen 'Secured fields voor Vtiger CRM' voor &euro;395,- (i.p.v. &euro;497,-) + &euro;101,- per extra veld + &euro;89,00/jr.";
            }
            */
            if ($portalModule)
            {
                $table .= "<li>Het Klantportaal kan Actief staan in jouw Vtiger CRM installatie zonder dat je het portaal gebruikt.";
                if (substr($data['inst_version'], 0, 3) < '7.3')
                {
                    $table .= " Mocht je het portaal gebruiken met Vtiger CRM versie {$data['inst_version']} houdt er dan rekening mee dat bij de overstap naar Vtiger CRM 7.3 of hoger het portaal vernieuwd is en dus ook opnieuw geinstalleerd en vormgegeven moet worden.";
//        $keuzetext .= "\n[   ] Wij gebruiken het klantportaal. Wij willen graag offerte voor het omzetten naar Vtiger CRM 7.1.";
                }
                $table .= "</li>";
            }
            $table .= "</ol>";
            $table .= '<br />';
            $table .= '</div>';
            $table .= '<!-- end of keep block -->';

            $pricing = veb_calcversion($data);
            $stappenTot65 = $pricing['stappenTot65'];
            $stappenTot75 = $pricing['stappenTot75'];
            $prijsNaar65 = $pricing['prijsNaar65'];
            $prijsNaar75 = $pricing['prijsNaar75'];

            // keuzes   
            $keuzetext = "<h2>A. De door vicus aanbevolen oplossing</h2>" . veb_getHTMLtext($keuzetext, '10px');

            $eolTxt = false;

//    $moduleTable = '<p>Omcircel het gewenste antwoord</p>';
            $moduleTable = '<table border=1 style="width:900px; text-align:center;">';
            $moduleTable .= '<tr><th rowspan=2>Module</th><th rowspan=2>Vervangprijs</th><th colspan=3>Jouw keuze (kruis het gewenste antwoord aan)</th>';
            $moduleTable .= '<tr><th>Vervangen</th><th>Mag vervallen</th><th>Herbouwen</th></tr>';
            foreach ($adviseModules as $key4 => $data4)
            {
                $moduleTable .= "<tr>";
                // als beschikbaar niet eol
                $moduleTable .= "<td>{$data4['productname']} ({$data4['productcategory']})</td>";
                if ($data4['cmdb_productkey'] == 'Vtiger2King')
                {
                    if ($version != '7.0' && $version != '7.1')
                    {
                        $moduleTable .= '<td style="text-align:right;">&euro;145.00</td><td style="text-align:center;">[   ]</td>';
                    } else
                    {
                        $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                    }
                    $moduleTable .= '<td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                } elseif ($version == '7.1')
                {
                    $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                    $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td><td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                } elseif ($version == '7.0' && $data4['cmdb_productkey'] != 'Portal')
                {
                    $moduleTable .= '<td style="text-align:right;">&euro;55.00</td>';
                    $moduleTable .= '<td style="text-align:center;">[   ]</td></td><td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                } elseif ($data4['productcategory'] == 'Maatwerk')
                {
                    $moduleTable .= '<td style="text-align:right;">vraag offerte</td>';
                    $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td><td style="text-align:center;">[   ]</td><td style="text-align:center;">[   ]</td>';
                } elseif (stripos($data4['highestversion'], 'eol') !== false and stripos($data4['highestversion'], 'alt') !== false)
                {
                    $eolTxt = true;
                    $moduleTable .= '<td style="text-align:right;">vraag alternatief</td>';
                    $moduleTable .= '<td style="text-align:center;">[   ]</td><td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                } elseif (stripos($data4['highestversion'], 'eol') !== false)
                {
                    $eolTxt = true;
                    $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                    $moduleTable .= '<td style="background-color:#efefef;text-align:center;">n.v.t.</td><td style="text-align:center;">[   ]</td><td style="text-align:center;">[   ]</td>';
                } else
                {
                    if ($data4['c_annual_maintenance'] > 0)
                    {
                        $perjaar = " + &euro;" . number_format($data4['c_annual_maintenance'], 2) . '/jr';
                    } else
                    {
                        $perjaar = '';
                    }
                    $moduleTable .= '<td style="text-align:right;">' . "&euro;" . number_format($data4['unit_price'], 2) . "{$perjaar}</td>";
                    //$moduleTable .= "<td>{$data4['highestversion']}</td>";
                    $moduleTable .= '<td style="text-align:center;">[   ]</td><td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
                }

                $moduleTable .= "</tr>";
            }
            // special for NL vertaling
            // kan zijn dat een klant hem had/niet had. Dus alleen laten kiezen voor aanzetten
            /*
            $moduleTable .= "<tr>";
            $moduleTable .= '<td>Vtiger CRM Taalpakket Nederlands (NL-Dutch) - (Add-on)</td>';
            $moduleTable .= '<td style="text-align:right;">&euro;156.00 + &euro;111.00/jr</td>';
            $moduleTable .= '<td style="text-align:center;">[   ]</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td><td style="background-color:#efefef;text-align:center;">n.v.t.</td>';
            $moduleTable .= "</tr>";
		*/

            $moduleTable .= "</table>";
//            $moduleTable .= '<p style="font-size:10px">Op de vervangprijs in de bovenstaande tabel krijgt u tot 31 januari 10% korting (niet te combineren met andere kortingen) op de eenmalige kosten (niet de jaarkosten). Daarna gelden de normale upgradeprijzen.</p>';

            if ($eolTxt)
            {
                $moduleTable .= '<p style="font-size:10px">Sommige modules in jouw systeem zijn End Of Live (EOL); daarvoor adviseren we graag over een alternatief.</p>';
            }

            $keuzetext .= $moduleTable;

            $keuzetext .= "<h2>Aanbevolen modules</h2>" . veb_getHTMLtext($extraModules, '10px');

            $keuzetext .= "<h2>B. Wij kiezen voor een alternatieve oplossing</h2>";

            $alternatiefText = '';
            if ($data['hostingmodel'] != 'Vicus VPS')
            {
                $alternatiefText .= "[   ] Plaats onze Vtiger CRM op een server samen met andere klanten die niet willen upgraden. Wij zijn ons ervan bewust dat deze situatie niet veilig en niet avg-proef is. De eenmalige kosten hiervan zijn &euro;250,-.";
            } else
            {
                $alternatiefText .= "[   ] Wij maken gebruik van een VPS en onze Vtiger CRM behoeft op dit moment geen upgrade. We blijven dus op de oude Vtiger CRM en onderliggende systeemsoftware draaien. Wij zijn ons ervan bewust dat deze situatie niet veilig, niet avg-proef en niet toekomst-vast is.";
            }
            $alternatiefText .= "\n[   ] Wij willen graag offerte voor een standaard installatie van Vtiger CRM 7.5, zonder modules en maatwerk en het overzetten van een nader af te stemmen deel van onze gegevens.";
            $version = substr($data['inst_version'], 0, 3);
            if ($version < 6.5)
            {
                $alternatiefText .= "\n[   ] Wij willen onze Vtiger CRM upgraden naar versie 6.5 voor de speciale prijs van &euro;{$prijsNaar65},- (exclusief maatwerk, module licenties hoeven niet te worden vernieuwd). Wij zijn ons ervan bewust dat deze oplossing niet veilig en niet avg-proef is.";
            }
            // Enkelvoudig: [   ] Gebruikers [   ] Organsiaties [   ] Contacten [   ] Leads [   ] Verkoopkansen.
            //Meervoudig: [   ] Offertes [   ] Facturen [   ] Verkooporders [   ] Inkooporders (Organsiaties, Contacten, Producten, Diensten zijn ook nodig).

            $keuzeBlockSysteem[$data['url2']] = $keuzetext . veb_getHTMLtext($alternatiefText, '10px');
        } else
    {
        // we hebben geen installaties voor deze contactpersoon
        $table .= '<div style="page-break-inside: avoid;">';
        $table .= "<h1>Systeem {$counter} {$data['url2']}</h1>";
        $table .= '<p style="font-size:10px">Scanstatus: Niet gescand er is geen kopppeling beschikbaar</p>';
        $table .= '<p style="font-size:10px">Uw systeem kan niet worden gescand. Controleer zelf s.v.p. de versie van Vtiger CRM (onder het inlogscherm) en de PHP versie (vraag uw systeembeheerder). Indien uw versie van Vtiger CRM lager is dan versie 7.5 dan adviseren wij u uit veiligheidsoverweging te upgraden naar versie 7.5. Indien u hierover vragen heeft kunt u contact opnemen met onze servicedesk.</p>';
    }

    foreach ($keuzeBlockSysteem as $system => $text)
    {
        $table .= "<div style='page-break-after: always;'><span style='display: none;'>&nbsp;</span></div>";
        $table .= "<h1>Jouw keuzes voor {$system}</h1>";
        $table .= '<p style="font-size:10px">Wil je deze pagina s.v.p. invullen, inscannen en e-mailen naar sales@vicus.nl? Wij nemen contact met je op om de planning te bespreken of als wij vragen hebben. Onderstaande speciale actieprijzen zijn geldig tot en met 30  april 2023.</p>';
        $table .= $text;
        $table .= '<div style="page-break-inside: avoid;">';
        $table .= '<p style="font-size:10px"><b>Ondertekening</b></p>';
        $table .= '<p style="font-size:10px">Getekend voor akkoord:</p>';
        $table .= '<p style="font-size:10px">Jouw naam</p>';
        $table .= '</div><!-- end of keep block -->';
    }


//  die($table);

    if ($debug)
    {
        file_put_contents("/home/cs1002/public_html/modules/PDFMaker/resources/functions/installations-debug.html", $table);
        return $table;
//    die();
    } else
    {
        return $table;
    }
}
