<?php
/**
 * [CUSTOMFUNCTION|veb_getBijlage|$QUOTES_CRMID$|12px|times new roman,times,serif|CUSTOMFUNCTION]
 */

include_once('veb_pdfm_config.php');

/**
 * This function returns HTML representation of textfields 
 *  
 * @param $crmid	ID of the CRM entity
 * @param $docSection	section of the document (e.g. conditions, introduction, etc)
 * @param $size			(optional) font size - default 12px
 * @param $size			(optional) font -  default times new roman,times,serif
 * @return	string containing formatted textblock
 **/ 
function veb_getBijlage($crmid, $size = '12px')
{
	global $adb, $PDFMaker_template_id;

	$style = 'font-size:'.$size;

	// defaults
	$newText = array();
	$printedSomething = false;

	// have all products & services assiciated to quote
	$result = $adb->query("select setype from vtiger_crmentity where crmid=$crmid");
	$row = $adb->fetchByAssoc($result);
	$my_focus = CRMEntity::getInstance($row['setype']);
	$my_focus->id = $crmid;
	$my_focus->retrieve_entity_info($crmid,$row['setype']);
	$associated_prod = getAssociatedProducts($row['setype'], $my_focus);

        $pdfmConfig = new pdfmConfig($my_focus->fields['c_picklist_settings']);

	$service_category = $pdfmConfig->service_category;
	$service_order = $pdfmConfig->service_order;
	$product_category = $pdfmConfig->product_category;
	$product_order = $pdfmConfig->product_order;
	
	// get account no for tracing the links through parameter cid=
// print_r($my_focus); die();
	$result = $adb->query("select account_no from vtiger_account where accountid='".$my_focus->column_fields['account_id']."'");
	$row = $adb->fetchByAssoc($result);	
	// print_r($row['account_no']); die();
	$accountNo = $row['account_no'];
	$accountId = $my_focus->column_fields['account_id'];
	$quoteId = $crmid;
	$refNo = $my_focus->column_fields['c_document_number'];
	
	$contactId = $my_focus->column_fields['contact_id'];

//	print '<pre>';print_r($associated_prod);
	// @change lro 111206 added to filter duplicates out
	$associated_prod = veb_array_unique($associated_prod);
//	print_r($associated_prod);
	

	// get info from products and services, incl custom fields
	// sort them by order as defined
	foreach($associated_prod as $key=>$prod_info)
	{
//		print "$key-";
		if($prod_info['entityType'.$key]=='Products') 
		{
			$vebType = 'p';
			$res = $adb->query("select ".$product_order." as ord, ".$product_category." as section from vtiger_products where productid=".$prod_info['hdnProductId'.$key]);
//			$res = $adb->query("select * from vtiger_products where productid=".$prod_info['hdnProductId'.$key]);
			$res2 = $adb->query("select usageunit, website, productcode, c_principles as uitgangspunten from vtiger_products where productid=".$prod_info['hdnProductId'.$key]);
			$res3 = $adb->query("select description from vtiger_crmentity where crmid=".$prod_info['hdnProductId'.$key]);
			$res4 = $adb->query("select cf_1681 as speclink, cf_2072 as inclusive, cf_1592 as voordelen from vtiger_productcf where productid=".$prod_info['hdnProductId'.$key]);
		} else {
			$vebType = 's';
			$res = $adb->query("select ".$service_order." as ord, c_partsnumber as productcode, ".$service_category." as section from vtiger_service where serviceid=".$prod_info['hdnProductId'.$key]);
			$res2 = $adb->query("select service_usageunit AS usageunit, website from vtiger_service where serviceid=".$prod_info['hdnProductId'.$key]);
			$res3 = $adb->query("select description from vtiger_crmentity where crmid=".$prod_info['hdnProductId'.$key]);
			$res4 = false;
		}
		$row = $adb->fetchByAssoc($res);
		$row2 = $adb->fetchByAssoc($res2);
		$row3 = $adb->fetchByAssoc($res3);
		if ($res4) {
		  $row4 = $adb->fetchByAssoc($res4);
		} else {
  		$row4 = array();
		}
//		print_r($row4);
		$images = getInventoryImages($prod_info['hdnProductId'.$key]);
		

//		if($row['ord']=='' || $row['ord']==0)
		if($row['ord']=='')
			$row['ord'] = '9999999';
		if($merge){
			if($prod_info['entityType'.$key]=='Products' && strtolower($row[$product_category])!='--geen--' && trim($row[$product_category]!='')) {
				$row['ord'] = '99999999'.$Pick[$row[$product_category]];
			}
		}

		// row
		$associated_prod[$key]['sortorder'.$key] = $row['ord'];
		$associated_prod[$key]['section'.$key] = $row['section'];
		
		// row 2 website, manufacturer, productcode, manufacturer, serialno, productname
		$associated_prod[$key]['usageunit'.$key] = $row2['usageunit'];
		$associated_prod[$key]['website'.$key] = $row2['website'];

		if($prod_info['entityType'.$key]=='Products') 
		{
			$associated_prod[$key]['productcode'.$key] = $row2['productcode'];
		} else {
			$associated_prod[$key]['productcode'.$key] = $row['productcode'];
		}
		
		$associated_prod[$key]['uitgangspunten'.$key] = $row2['uitgangspunten'];		
		

		// row 3 description
		$associated_prod[$key]['description'.$key] = $row3['description'];
		
		$associated_prod[$key]['vebtype'.$key] = $vebType;

    // row 4 custom fields
		$associated_prod[$key]['speclink'.$key] = $row4['speclink'];
		
		$associated_prod[$key]['inclusive'.$key] = $row4['inclusive'];

		$associated_prod[$key]['voordelen'.$key] = $row4['voordelen'];

		// images
		$associated_prod[$key]['image'.$key] = $images[$prod_info['hdnProductId'.$key].'_1'];

		swapAssociatedProducts($associated_prod,$key);
//print '<pre>';print_r($associated_prod);
	}
	
	foreach ($associated_prod as $key => $prodInfo) 
	{
		switch (strtolower($prodInfo['section'.$key])) {
			case 'software': $sectOrd = 1; break;
			case 'add-on': $sectOrd = 2; break;
			case 'projectkosten': $sectOrd = 3; break;
			case 'jaarkosten': $sectOrd = 4; break;
			default: $sectOrd = 99; break;
		}		
		$sortorder = $sectOrd.'-'.$prodInfo['sortorder'.$key].'-'.$key;
		$newText[$sortorder] = '';
//		print '<hr><pre>';print $sortorder .'<br>'; print_r($prodInfo);

		// @change 111230 lro solving that we see a left over of deleted records
		// may be a bug in getAssociatedProducts
		if ($prodInfo['productName'.$key] == '') {
//			print '<pre>';print_r($prodInfo);			
			continue;
		}
		$printedSomething = true;
		$allowedSites = $pdfmConfig->allowed_sites;
		$allowedSite = false;
		$productid = $prodInfo['hdnProductId'.$key];
		
		foreach ($allowedSites as $siteId => $domain) {

//			if (str_instr($domain, $prodInfo['website'.$key])) 
			if (stristr($prodInfo['website'.$key], $domain) )
			{
				$allowedSite = true;
				continue; // step out of the loop, we're done
			}
		}

// http://www.vicus.nl/vicus/contactpersonen.html?wva_accid=194874&wva_conid=199535&refno=16020905lro01&utm_source=crm&utm_medium=pdf&utm_campaign=offerte&utm_content=textlink

		if (!empty($prodInfo['website'.$key]) && $allowedSite) 
		{
		    $link = veb_url_add_trackingcodes($prodInfo['website'.$key], array(
		        'accountid'=>$accountId,
		        'contactid'=>$contactId,
		        'refno'=>$refNo,
		        'quoteid'=>$quoteId,
		        'productid'=>$productid
    		    ));
		
		    /*
			// ensure we will only include websites that are Vicus related, don't make people smarter than necessary!			
			// - will be parsed to unorderd list :-)
			// tracer = "?cid=contact_id"; $accountId
			if (stristr($prodInfo['website'.$key], '?') && $accountId != '')
				$link = $prodInfo['website'.$key].'&wva_accid='.$accountId."&refno=$refNo";
			elseif ($accountId != '')
				$link = $prodInfo['website'.$key].'?wva_accid='.$accountId."&refno=$refNo";
			elseif (stristr($prodInfo['website'.$key], '?'))
				$link = $prodInfo['website'.$key]."&refno=$refNo";
			else 
				$link = $prodInfo['website'.$key]."?refno=$refNo";

			if ($link != '' && $contactId != '') {
				$link = $link . '&wva_conid='.$contactId;
			} elseif ($contactId != '') {
				$link = $prodInfo['website'.$key].'?wva_conid='.$contactId."&refno=$refNo";
			}

			if ($link != '' && $quoteId != '') {
				$link = $link . '&wva_quoid='.$quoteId;
			}
			
			$link = $link . "&utm_source=crm&utm_medium=pdf&utm_campaign=offerte&utm_content=textlink";
			
			if (substr($link, 0,7) != 'http://' && substr($link, 0,8) != 'https://') {
				$link = 'https://'.$link;
			}
			*/	
			
			$website = "Zie: ".'<a href="'.$link.'">'.$prodInfo['website'.$key].'</a>';

		} else {
			$website = '';
		}

	    $speclink = '';
		if (!empty($prodInfo['speclink'.$key])) 
		{
		    $speclink = veb_url_add_trackingcodes($prodInfo['speclink'.$key], array(
		        'accountid'=>$accountId,
		        'contactid'=>$contactId,
		        'refno'=>$refNo,
		        'quoteid'=>$quoteId,
		        'productid'=>$productid
    		    ));
    		/*
			// ensure we will only include websites that are Vicus related, don't make people smarter than necessary!			
			// - will be parsed to unorderd list :-)
			// tracer = "?cid=contact_id"; $accountId
			if (stristr($prodInfo['speclink'.$key], '?') && $accountId != '')
				$speclink = $prodInfo['speclink'.$key].'&wva_accid='.$accountId."&refno=$refNo";
			elseif ($accountId != '')
				$speclink = $prodInfo['speclink'.$key].'?wva_accid='.$accountId."&refno=$refNo";
			elseif (stristr($prodInfo['speclink'.$key], '?'))
				$speclink = $prodInfo['speclink'.$key]."&refno=$refNo";
			else 
				$speclink = $prodInfo['speclink'.$key]."?refno=$refNo";

			if ($speclink != '' && $contactId != '') {
				$speclink = $speclink . '&wva_conid='.$contactId;
			} elseif ($contactId != '') {
				$speclink = $prodInfo['speclink'.$key].'?wva_conid='.$contactId."&refno=$refNo";
			}

			if ($speclink != '' && $quoteId != '') {
				$speclink = $speclink . '&wva_quoid='.$quoteId;
			}
			
			$speclink = $speclink . "&utm_source=crm&utm_medium=pdf&utm_campaign=offerte&utm_content=textlink";
			
			if (substr($speclink, 0,7) != 'http://' && substr($speclink, 0,8) != 'https://') {
				$speclink = 'https://'.$speclink;
			}
		    */
		}


		$newText[$sortorder] .= '<!-- start block --><div style="page-break-inside: avoid;">'."\n";

		if(!empty($prodInfo['image'.$key]) && 1==3)
		{


//			$newText[$sortorder] .= '<table><tr><td width="100%">';
			$newText[$sortorder] .= '<h2 style="float:left; width:70%;"><bookmark content="'.$prodInfo['productName'.$key].'" level="1"></bookmark>['.$prodInfo['vebtype'.$key].'-'.strtolower($prodInfo['productcode'.$key]).'] '.$prodInfo['productName'.$key].' ('.$prodInfo['section'.$key].')</h2>';
//			$newText[$sortorder] .= veb_getHTMLtext($website,$size)."\n";
//			$newText[$sortorder] .= '</td>'."\n";
//			$newText[$sortorder] .= '<td width="100px">'."\n";
			$width="";
			$height="";
			if($prodInfo['image'.$key]["width"]>0)
				$width=" width='".$prodInfo['image'.$key]["width"]."' ";
			if($prodInfo['image'.$key]["height"]>0)
				$height=" height='".$prodInfo['image'.$key]["height"]."' ";
			$newText[$sortorder] .= "<img style='float:right;' src='".$prodInfo['image'.$key]["src"]."' ".$width.$height."/>\n";
			$newText[$sortorder] .= '<div style="clear:both;"></div>'."\n";
			/*
			$newText[$sortorder] .= veb_getHTMLtext($prodInfo['description'.$key],$size)."\n";
			$newText[$sortorder] .= '</td></tr></table>';
			*/

		} else {
			// ['.$prodInfo['vebtype'.$key].'-'.strtolower($prodInfo['productcode'.$key]).'] '.
			$newText[$sortorder] .= '<h2><bookmark content="'.$prodInfo['productName'.$key].'" level="1"></bookmark>'.$prodInfo['productName'.$key].' ('.$prodInfo['section'.$key].')</h2>';
//			$newText[$sortorder] .= veb_getHTMLtext($website,$size)."\n";
		}
		
		$tempText = '';
		
		/*
		$tempText .= !empty($prodInfo['description'.$key]) ? "\n".$prodInfo['description'.$key] : '';
		$tempText .= !empty($prodInfo['inclusive'.$key]) ? "\nInclusief:\n".$prodInfo['inclusive'.$key] : '';
		$tempText .= !empty($prodInfo['uitgangspunten'.$key]) ? "\nUitgangspunten:\n".$prodInfo['uitgangspunten'.$key] : '';
		$tempText .= !empty($prodInfo['voordelen'.$key]) ? "\nVoordelen:\n".$prodInfo['voordelen'.$key] : '';
		$tempText .= !empty($website) ? "\n$website" : '';
		
		//$newText[$sortorder] .= veb_getHTMLtext(.$prodInfo['inclusive'.$key].$prodInfo['uitgangspunten'.$key].$prodInfo['voordelen'.$key].$website,$size)."\n";
		$newText[$sortorder] .= veb_getHTMLtext($tempText."\n");
		*/
		$tempText .= !empty($prodInfo['description'.$key]) ? $prodInfo['description'.$key]."\n" : '';
		$tempText .= !empty($prodInfo['inclusive'.$key]) ? "Inclusief:\n".$prodInfo['inclusive'.$key]."\n" : '';
		$tempText .= !empty($prodInfo['uitgangspunten'.$key]) ? "Uitgangspunten:\n".$prodInfo['uitgangspunten'.$key]."\n" : '';
		$tempText .= !empty($prodInfo['voordelen'.$key]) ? "Voordelen:\n".$prodInfo['voordelen'.$key]."\n" : '';
		$tempText .= !empty($website) ? "$website"."\n" : '';
		
		$tempText .= veb_subproducts_formatted($productid, $prodInfo['website'.$key]);

		
		//$newText[$sortorder] .= veb_getHTMLtext(.$prodInfo['inclusive'.$key].$prodInfo['uitgangspunten'.$key].$prodInfo['voordelen'.$key].$website,$size)."\n";
		$newText[$sortorder] .= veb_getHTMLtext($tempText);
		
		$newText[$sortorder] .= '</div> <!-- end block -->'."\n\n";
		
		// replace tags in the text
    	$linkText = '';
		if ($speclink != '') {
      		$linkUrl = $speclink; // $prodInfo['speclink'.$key];
    	  	$linkText = '<a href="'.$linkUrl.'">Download via deze link de specificatie</a>.';
	    }
	  
		$newText[$sortorder] = str_replace('[SPECLINK]',$linkText,$newText[$sortorder]);
		
//		$newText[$sortorder] .= '</td></tr>'."\n";
	}
//	$newText[$sortorder] .= '</table>';

ksort($newText);
$newTextResult = implode("\n",$newText);

//print_r($newText);

//print('expect content here: '.$newTextResult); die();
// print "<br>".__FILE__ .':'.memory_get_usage(true); //die();

    return $newTextResult; //htmlspecialchars(, ENT_QUOTES);
}



/** 
 * Special function to enbsure each proeduct is included once
 * @param	array	input	may contain duplicates
 * @return	array	output	only contains unique products
 * @since	06 december 2011
 */
function veb_array_unique($input) {
	$output = array();
	$aProductsPassed = array();
	
	foreach ($input as $key => $productinfo) 
	{
		if (!isset( $aProductsPassed[ $productinfo['hdnProductId'.$key] ] )) {
			$output[$key] = $productinfo;
			$aProductsPassed[$productinfo['hdnProductId'.$key]] = $productinfo['hdnProductId'.$key];
		}
	}
	
	return $output;
}
