<?php

/*
 * usage: [CUSTOMFUNCTION|getCustomProductBlock|$INVOICE_CRMID$|Art.-Nr.|no|Artikel-Bezeichnung|name|Liefermenge|quantity|Preis/Einh.|listprice|Betrag|total|CUSTOMFUNCTION]
 *
 */
// include_once('veb_pdfm_config.php');

include_once('modules/PDFMaker/resources/functions/veb_subproducts_formatted.php');

function getCustomProductBlock($invid, $merge) //|no|name|quantity|listprice|total
{
    global $adb, $PDFMaker_template_id, $renvooi;

    $pdfmConfig = new pdfmConfig;

    $allInText = ''; // new since 20191201 lro to try to catch all in a descriptive text, to have e more friendly proposition.

    $service_phase = $pdfmConfig->service_phase;
    $discount_setting = $pdfmConfig->discount_setting;

    $product_category = $pdfmConfig->product_category;
    $product_order = $pdfmConfig->product_order;
    $product_phase = $pdfmConfig->product_phase;

// @change lro melding als de array leeg is.
$allInTextInStelposten = array();

    $Associations = array(
        'entitytype' => 'entityType',
        'id' => 'hdnProductId',
        'name' => 'productName',
        'code' => 'hdnProductcode',
        'no' => 'product_no',
        'description' => 'productDescription',
        'comment' => 'comment',
        'qtyinstock' => 'qtyInStock',
        'quantity' => 'qty',
        'listprice' => 'listPrice',
        'unitprice' => 'unitPrice',
        'total' => 'productTotal',
        'discount' => 'discountTotal',
        'totalafterdiscount' => 'totalAfterDiscount',
        'tax' => 'taxTotal',
        'netto' => 'netPrice',
        'image' => 'productImage',
        'cf_1681' => 'speclink',
        'cf_2072' => 'inclusive',
        'c_principles' => 'uitgangspunten',
        'cf_1592' => 'voordelen',
    );

    $Numeric = array(
        'qtyinstock' => 'qtyInStock',
        //'quantity'=>'qty',
        'listprice' => 'listPrice',
        'unitprice' => 'unitPrice',
        'total' => 'productTotal',
        'discount' => 'discountTotal',
        'totalafterdiscount' => 'totalAfterDiscount',
        'tax' => 'taxTotal',
        'netto' => 'netPrice',
    );

    $return = '';
    $input_args = func_get_args();

    $Columns = array();
    $Header = array();

    foreach ($input_args as $key => $value)
    {
        if ($key > 1)
        {
            if ($key % 2)
            {
                $Columns[] = strtolower($value);
            } else
            {
                $Header[] = $value;
            }
        }
    }

    $pagebreak = getPageBreaks($invid);
    $breaklines = getInventoryBreaklines($invid);
    $images = getInventoryImages($invid);

    $result = $adb->query("select setype from vtiger_crmentity where crmid=$invid");
    $row = $adb->fetchByAssoc($result);
    $my_focus = CRMEntity::getInstance($row['setype']);
    $my_focus->id = $invid;
    $my_focus->retrieve_entity_info($invid, $row['setype']);

    $pdfmConfig = new pdfmConfig($my_focus->column_fields['c_picklist_settings']);

//  var_dump($pdfmConfig); die();


    $naamgevingFasen = explode(',', $my_focus->column_fields['cf_1685']);

    // $discountSettingTxt = $my_focus->column_fields[$discount_setting];
    $discountSettingTxt = 'Hele offerte';
    //$discountSettingTxt = 'Projectkosten';
    // Testing data
    $errors = false;

    if (empty($my_focus->column_fields[$pdfmConfig->document_nr]))
    {
        $errors[] = 'Documentnummer mist';
    }

    $sqlC = "SELECT *
           FROM vtiger_contactdetails AS cd
           LEFT JOIN vtiger_contactscf AS ccf ON cd.contactid = ccf.contactid
           WHERE cd.contactid='" . $my_focus->column_fields['contact_id'] . "';";

    $resultC = $adb->query($sqlC);

    if ($resultC)
    {
        $rowC = $adb->fetchByAssoc($resultC);

        if ($rowC['salutation'] != 'Dhr.' && $rowC['salutation'] != 'Mevr.')
            $errors[] = 'Salutation onjuist (moet Dhr. of Mevr.) (CON)';
        if (empty($rowC['firstname']))
            $errors[] = 'Voornaam is leeg (CON)';
        if (empty($rowC['lastname']))
            $errors[] = 'Achternaam is leeg (CON)';
        // if( empty($rowC['email'])) $errors[] = 'E-mailadres is leeg'; // @change lro 140121 we often send to employee,wehre formal person is director.
        if (empty($rowC['c_contact_preamble']))
            $errors[] = 'Aanhef / geachte is leeg (CON)';
    }
    else
    {
        $errors[] = 'Geadresseerde contactpersoon niet gevonden!';
    }

//  $contactNo = $row['contact_no'];
//  $refNo = $my_focus->column_fields['c_document_number'];

    if ($errors)
    {
        print 'Graag oplossen:<ol>';
        print implode('<li>', $errors);
        print '</ol>';
        die();
    }

    // ready with test
    $associated_prod = getAssociatedProducts($row['setype'], $my_focus);

    $category_association = array();
    $first_product_in_association = array();
    $Pick = array();

    // jho - $pickres = $adb->query("SELECT picklistid FROM vtiger_picklist name='$product_category'");
    $pickres = $adb->query("SELECT picklistid, fieldname FROM vtiger_picklist, vtiger_field WHERE fieldname = name and columnname='$product_category' and tablename='vtiger_products'");
    $pickrow = $adb->fetchByAssoc($pickres);

// jho
    $picklistTable = $pickrow['fieldname'];

    $picklistid = $pickrow['picklistid'];

    $pickres = $adb->query("SELECT " . $picklistTable . ", sortid
                          FROM vtiger_role2picklist INNER JOIN vtiger_" . $picklistTable . " ON picklistvalueid=picklist_valueid
                          WHERE `picklistid`=$picklistid
                          AND `roleid`='H2' ORDER BY sortid");

    while ($pickrow = $adb->fetchByAssoc($pickres)) {
        $Pick[$pickrow[$product_category]] = $pickrow['sortid'];
    }

    $associated_prod = lroGetProductDetails($associated_prod);

    // preprocess - calculate yearly fees
    foreach ($associated_prod AS $prodkey => $ProdArray)
    {
        // special handling
        $yearlyfee = $ProdArray['yearlyfee' . $prodkey];
        $extrakey = count($associated_prod) + 1;

        if ($yearlyfee > 0)
        {
            $associated_prod[$extrakey] = array(
                'entityType' . $extrakey => 'Services',
                'hdnProductId' . $extrakey => $productid,
                'productName' . $extrakey => $ProdArray['productName' . $prodkey] . ' Jaarkosten',
                'productcode' . $extrakey => $ProdArray['productcode' . $prodkey] . '-yr',
                'usageunit' . $extrakey => 'Jaar',
                'qtyInStock' . $extrakey => 'NA',
                'qty' . $extrakey => $ProdArray['qty' . $prodkey],
                'listPrice' . $extrakey => $ProdArray['yearlyfee' . $prodkey],
                'unitPrice' . $extrakey => $ProdArray['yearlyfee' . $prodkey],
                'productTotal' . $extrakey => $ProdArray['yearlyfee' . $prodkey] * $ProdArray['qty' . $prodkey],
                'productid' . $extrakey => $productid,
                'taxTotal' . $extrakey => $ProdArray['taxTotal' . $prodkey],
                'netPrice' . $extrakey => $ProdArray['netPrice' . $prodkey],
                'sortorder' . $extrakey => $ProdArray['sortorder' . $prodkey],
                'section' . $extrakey => 'Jaarkosten',
                'speclink' . $extrakey => $ProdArray['cf_1681' . $prodkey],
                'phase' . $extrakey => $ProdArray['phase' . $prodkey],
                // @change lro 181106
                'inclusive' . $extrakey => $ProdArray['cf_1681' . $prodkey],
                'uitgangspunten' . $extrakey => $ProdArray['cf_1681' . $prodkey],
                'voordelen' . $extrakey => $ProdArray['cf_1681' . $prodkey],
                // @change lro 140508 added the multiplier
                'totalAfterDiscount' . $extrakey => $ProdArray['yearlyfee' . $prodkey] * $ProdArray['qty' . $prodkey],
            );
        }
    }

    // @change lro added page-break-inside:avoid" autosize="0.8" // page-break-inside:avoid;
    $return .= '<h1><bookmark content="Investeringsoverzicht" level="0"></bookmark>Investeringsoverzicht</h1>' . "\n";
    // zie line 240 voor extra tekst

    $allInText .= '<h1><bookmark content="Investering" level="0"></bookmark>Uw investering</h1>' . "\n";

    // preprocess define how many phases
    $aPhases = array();
    foreach ($associated_prod as $prodkey => $ProdArray)
    {
        if (empty($ProdArray['phase' . $prodkey]) && (substr($ProdArray['phase' . $prodkey], 0, 1)) !== "0")
        {
            $phaseNr = 9;
        } else
        {
            $phaseNr = (int) substr($ProdArray['phase' . $prodkey], 0, 1);
        }

        if (count($naamgevingFasen) > 0)
        {
            $nextPhase = $phaseNr;
            switch ($phaseNr)
            {
                case 0: $aPhases[0] = (isset($naamgevingFasen[0])) ? $nextPhase . ' ' . $naamgevingFasen[0] : $nextPhase . ' Voorber.';
                    break;
                case 1: $aPhases[1] = (isset($naamgevingFasen[1])) ? $nextPhase . ' ' . $naamgevingFasen[1] : $nextPhase . ' Basis';
                    break;
                case 2: $aPhases[2] = (isset($naamgevingFasen[2])) ? $nextPhase . ' ' . $naamgevingFasen[2] : $nextPhase . ' Iteratie' . $nextPhase;
                    break;
                case 3: $aPhases[3] = (isset($naamgevingFasen[3])) ? $nextPhase . ' ' . $naamgevingFasen[3] : $nextPhase . ' Iteratie' . $nextPhase;
                    break;
                case 4: $aPhases[4] = (isset($naamgevingFasen[4])) ? $nextPhase . ' ' . $naamgevingFasen[4] : $nextPhase . ' Iteratie' . $nextPhase;
                    break;
                case 5: $aPhases[5] = (isset($naamgevingFasen[5])) ? $nextPhase . ' ' . $naamgevingFasen[5] : $nextPhase . ' Iteratie' . $nextPhase;
                    break;
                case 5: $aPhases[6] = (isset($naamgevingFasen[6])) ? $nextPhase . ' ' . $naamgevingFasen[6] : $nextPhase . ' Iteratie' . $nextPhase;
                    break;
                default: $aPhases[9] = $nextPhase . ' Iteratie' . $nextPhase;
            }
        } elseif (1 == 3)
        {
            switch ($phaseNr)
            {
                case 0: $aPhases[0] = '0 Ontwerp';
                    break;
                case 1: $aPhases[1] = '1 Fase';
                    break;
                case 2: $aPhases[2] = '2 Klant';
                    break;
                case 3: $aPhases[3] = '3 Loyalty';
                    break;
                case 4: $aPhases[4] = '4 Integr';
                    break;
                case 5: $aPhases[5] = '5 Multis';
                    break;
                case 5: $aPhases[6] = '6 Extra';
                    break;
                default: $aPhases[9] = 'Overig';
            }
        } else
        {
            switch ($phaseNr)
            {
                case 0: $aPhases[0] = '0 Ontwerp';
                    break;
                case 1: $aPhases[1] = '1e Fase';
                    break;
                case 2: $aPhases[2] = '2e Fase';
                    break;
                case 3: $aPhases[3] = '3e Fase';
                    break;
                case 4: $aPhases[4] = '4e Fase';
                    break;
                case 5: $aPhases[5] = '5e Fase';
                    break;
                case 5: $aPhases[6] = '6e Fase';
                    break;
                default: $aPhases[9] = 'Overig';
            }
        }
    }

    ksort($aPhases); // ensure right order!
    // @change lro added
    if (count($aPhases) > 1)
    {
        $faseNames = implode(', ', $aPhases);
        $faseText = '<p>In onderstaande tabel vind je ' . count($aPhases) . ' kolommen (' . $faseNames . '). Per kolom zijn zowel de jaarkosten als de eenmalige investering weergegeven. In de laatste kolom zijn de kosten van alle kolommen bij elkaar opgeteld.</p>';
    } else
    {
        $faseText = '';
    }
//    $return .= '<p>Bij elke vooruitgang hoort een investering. Onderstaand hebben wij getracht deze zo helder en transparant mogelijk te presenteren. Ons aanbod bestaat uit twee delen. Te weten <em>Abonnementen / Jaarkosten</em> en <em>Eenmalige investering</em>.</p>';
$return .= '<p>Hieronder presenteren wij het investeringsoverzicht waarbij ons aanbod bestaat uit twee delen: <em>Abonnementen / Jaarkosten</em> en <em>Eenmalige investering</em>.</p>';

    $return .= $faseText;

    $allInText .= '<p>Ons aanbod bestaat uit <em>Eenmalige investering</em> en <em>Abonnementen</em>.</p>';

    // add to the columns
    // and ensure we have a logical order
    if (count($aPhases) > 0)
    {
        $key = array_search('total', $Columns);

        if ($key)
        {
            unset($Columns[$key], $Header[$key]);
        }

        foreach ($aPhases as $pId => $pText)
        {
            $Columns[] = $pText;
//      $Header[] = $pText;
            $Header[] = trim(substr($pText, 1));  // remove # and space
            $Numeric[$pText] = $pText;
        }

        if ($key)
        {
            $Columns[] = 'total';
            $Header[] = 'Totaal';
        }
    }

    $total_width = 100;
    $columns_total = count($Columns);
    // $columns_total = $columns_total + count($aPhases); // remove all phaases from available comuns
    // $total_width = $total_width - ( count($aPhases) * 10); // remove reserved width for phases

    if (in_array('no', $Columns))
    {
        $total_width = $total_width - 5;
        $columns_total--;
    }

    if (in_array('code', $Columns))
    {
        $total_width = $total_width - 10;
        $columns_total--;
    }

    if (in_array('name', $Columns))
    {
        // $total_width = $total_width - 20;
        // $columns_total--;
        $columns_total++;
        $columns_total++;
    }

    // $columns_total++;

    $column_width = round($total_width / $columns_total);
    $ColumnsWidth = array();

    foreach ($Columns as $columnname)
    {
        switch ($columnname)
        {
            case "no":
                $ColumnsWidth[] = 5;
                break;
            case "code":
                $ColumnsWidth[] = 10;
                break;
            case "name":
                $ColumnsWidth[] = 3 * $column_width;
                break;
            case "quantity":
                $ColumnsWidth[] = $column_width;
                break;
            default:
                $ColumnsWidth[] = $column_width;
                break;
        }
    }

    $headerLine = ''; // excludes tr tags

    foreach ($Header as $key => $value)
    {
        $align = '';

        if (isset($Numeric[$Columns[$key]]) || $Columns[$key] == 'quantity')
        {
            $align = ' align="right"';
        }

        $headerLine .= "\t" . '<th style="width: ' . $ColumnsWidth[$key] . '%; border: none; border-bottom: 1px solid rgb(204, 204, 204); color-background: #efefef;"' . $align . '><span style="font-style:italic;">' . $value . '</span></th>' . "\n";
    }

    // totals
    // $headerLine .= "\t".'<td style="border: none; color-background: #efefef;" align="right">&nbsp;</td>'."\n";
    // foreach ($aPhases as $pId => $pTitle)
    // {
    //   $headerLine .= "\t".'<th style="border: none; color-background: #efefef;" align="right"><span style="font-style:italic;">'.$pTitle.'</span></th>'."\n";
    // }
    // $return .= $headerLine;
    $i = 0;

    $text = array();
    $totalAfterDiscount = array();
    $totalsPhases = array();
    $yearlyFees = array();

    // @change lro 150319 solves Warning: ksort() expects parameter 1 to be array, null given
    // in /home/cs1002/public_html/crm/modules/PDFMaker/functions/InvoiceFunctions3-sortv3.php on line 719
    // when total is 0 (and one should inilialize vars :-)
    $totalsPerPhase = array();
    $totalsPerPhase['total'] = array();

    foreach ($associated_prod as $prodkey => $ProdArray)
    {
//        var_dump($ProdArray); die();


        $i++;
        $productid = $ProdArray[$Associations["id"] . $prodkey];
        $section = $ProdArray['section' . $prodkey];
        $phaseNr = substr($ProdArray['phase' . $prodkey], 0, 1);

        // @change lro 120626 - order per section / phase
        // $sortorder = $ProdArray['sortorder'.$prodkey];
        $sortorder = $phaseNr . $ProdArray['sortorder' . $prodkey];

        $totalAfterDiscount[$section] = (float) $totalAfterDiscount[$section] + (float) $ProdArray['totalAfterDiscount' . $prodkey];

        if (!isset($breaklines[$ProdArray[$Associations["id"] . ($prodkey - 1)] . "_" . ($prodkey - 1)]))
        {
            $text[$section][$sortorder] .= '</tr>' . "\n";
        }

        $text[$section][$sortorder] .= '<tr>' . "\n";

        // handle products and services
        // preparing the sections
        foreach ($Columns as $key => $columnname)
        {
            $align = '';

            if (isset($Numeric[$columnname]) || $columnname == 'quantity')
            {
                $align = ' align="right"';
            }

            $cell = "";

            if ($columnname == "image")
            {
                if (isset($images[$productid . "_" . $prodkey]))
                {
                    $width = "";
                    $height = "";
                    if ($images[$productid . "_" . $prodkey]["width"] > 0)
                    {
                        $width = " width='" . $images[$productid . "_" . $prodkey]["width"] . "' ";
                    }
                    if ($images[$productid . "_" . $prodkey]["height"] > 0)
                    {
                        $height = " height='" . $images[$productid . "_" . $prodkey]["height"] . "' ";
                    }
                    $cell = "<img src='" . $images[$productid . "_" . $prodkey]["src"] . "' " . $width . $height . "/>" . "\n";
                } else
                {
                    $cell = "&nbsp;";
                }
            } elseif ($columnname == 'quantity')
            {
                $usageUnitName = getTranslatedString($ProdArray['usageunit' . $prodkey]);
                switch (strtolower($usageUnitName))
                {
                    case 'jaar': $usageUnitName = 'x jr';
                        $usageUnitNameAllinText = 'jaar';
                        break;
                    case 'gebruiker': $usageUnitName = 'gebr';
                        $usageUnitNameAllinText = 'gebruiker';
                        break;
                    case 'gebr. pjr': $usageUnitName = 'gebr';
                        $usageUnitNameAllinText = 'gebruiker per jaar';
                        break;
                    case 'uren': $usageUnitName = 'uur';
                        $usageUnitNameAllinText = 'uur';
                        break;
                    case 'hours': $usageUnitName = 'uur';
                        $usageUnitNameAllinText = 'uur';
                        break;
                    case 'eenmalig': $usageUnitName = 'eenm';
                        $usageUnitNameAllinText = 'eenmalig';
                        break;
                    case 'dagdeel': $usageUnitName = 'dagd';
                        $usageUnitNameAllinText = 'dagdeel';
                        break;
                    case 'installatie': $usageUnitName = 'inst';
                        $usageUnitNameAllinText = 'installatie';
                        break;
                    case 'kilometer': $usageUnitName = 'km';
                        $usageUnitNameAllinText = 'kilometer';
                        break;
                    case 'maanden': $usageUnitName = 'x mnd';
                        $usageUnitNameAllinText = 'maand';
                        break;
                }

                // $cell=round($ProdArray[$Associations[$columnname].$prodkey],2).' '.$usageUnitName,$ProdArray['entityType'.$prodkey];
                $cell = round($ProdArray[$Associations[$columnname] . $prodkey], 2) . ' ' . $usageUnitName;
                if (isset($ProdArray[$Associations[$columnname] . $prodkey]))
                {
                    
                } else
                {
                    if ($cell == 0)
                    {
                        $cell = "&nbsp;";
                    }
                }
            } elseif ($columnname == 'total')
            {
                $cell = round($ProdArray[$Associations[$columnname] . $prodkey], 2); // @change 140520 round was 0
                if ($cell == 0)
                {
                    $cell = "&nbsp;";
                }
            } elseif (in_array($columnname, $aPhases))
            {
                // only take amount if phase is set equal
                // $phaseNr contains phase 1-9
                // $aPhases contains id => phaseName 1 = 1 Amb
                // $columnname contains phaseName
                if ($phaseNr == substr($columnname, 0, 1))
                {
                    $cell = round($ProdArray[$Associations['total'] . $prodkey], 2);
                    $totalsPerPhase[$section][$phaseNr] = $totalsPerPhase[$section][$phaseNr] + $cell;
                    if (strtolower($section) != 'jaarkosten')
                    {
                        $totalsPerPhase['total'][$phaseNr] = $totalsPerPhase['total'][$phaseNr] + $cell;
                    }
                } else
                {
                    $cell = 0;
                }

                if ($cell == 0)
                {
                    $cell = "&nbsp;";
                }
            }

            /*
              elseif($columnname=='usageunit')
              {
              $cell=$ProdArray[$Associations[$columnname].$prodkey].' '.getTranslatedString($ProdArray['usageunit'.$prodkey],$ProdArray['entityType'.$prodkey]);
              if ($cell == 0){ $cell="&nbsp;"; }
              }
             */ 
            elseif ($columnname == 'no')
            {
                $cell = $prodkey; //$sortorder; //$i;
            } elseif ($columnname == 'product_no')
            {
                $cell = $ProdArray['productcode' . $prodkey]; //$ProdArray[$Associations['product_no'].$prodkey]; //$sortorder; //$i;
            } else
            {
                $cell = $ProdArray[$Associations[$columnname] . $prodkey];
            }

            if (isset($Numeric[$columnname]))
            {
                if ($cell != "&nbsp;")
                {
                    $cell = '&euro;&nbsp;' . formatNumberToPDF($cell, 2);
                }
                /* else {
                  // lijkt nu nutteloos maar is voorbereiding om fixed price contracten te kunnen doen
                  if($columnname=='total') {
                  $cell = '&euro;&nbsp;'.formatNumberToPDF($cell,2);
                  } else {
                  $cell = 'x'; //  zet kruisje ind e juiste kolom om aan te geven dat deze componentn in btereffende fase zit
                  }
                  } */
            }

            $text[$section][$sortorder] .= "\t" . '<td style="padding: 5px 0 0 0px; width: ' . $ColumnsWidth[$key] . '%;"' . $align . '><span style="font-size: 10px; ">' . $cell . '</span></td>' . "\n";
        }

        if (isset($breaklines[$productid . "_" . $prodkey]))
        {
            $return[$section][$sortorder] .= '</tr></table>' . "\n" . $pagebreak . "\n" . '<table border="0" cellpadding="0" cellspacing="0" width="100%" autosize="1.0" style="page-break-inside:avoid;">' . "\n";
        }

//    $allInText .= 'Voor '.$ProdArray['productName'.$prodkey].' zijn de kosten per '.$usageUnitNameAllinText. ', er zijn er nu '.$ProdArray['qty'.$prodkey].' '.$usageUnitNameAllinText. ' in de offerte opgenomen.<br />';
        $allInTextA[$ProdArray['productName' . $prodkey]]['qty'] += $ProdArray['qty' . $prodkey];
        $allInTextA[$ProdArray['productName' . $prodkey]]['amount'] = (float) $ProdArray['totalAfterDiscount' . $prodkey];
        $allInTextA[$ProdArray['productName' . $prodkey]]['total'] += (float) $ProdArray['totalAfterDiscount' . $prodkey] * $ProdArray['qty' . $prodkey];
        $allInTextA[$ProdArray['productName' . $prodkey]]['unit'] = strtolower($ProdArray['usageunit' . $prodkey]);
        $allInTextA[$ProdArray['productName' . $prodkey]]['sortorder'] = strtolower($ProdArray['sortorder' . $prodkey]) . $prodkey; // added the prdkey to have it unique!
//print_r($allInTextA);die();
    }

    // see if we have enough test support
    // see if we have enough project management
    // also on top of test-sup!
    $testHours = array();
    foreach ($associated_prod as $prodkey => $ProdArray)
    {
        $phaseNr = substr($ProdArray['phase' . $prodkey], 0, 1);
        $qty = (float) $ProdArray['qty' . $prodkey];
        $listprice = (float) $ProdArray['listPrice' . $prodkey];
        $unit = $ProdArray['usageunit' . $prodkey];

        switch (strtolower($unit))
        {
            case 'day': $hours = 8 * $qty;
                break;
            case 'dagdeel': $hours = 4 * $qty;
                break;
            case 'hours': $hours = 1 * $qty;
                break;
            // assumed hours = calculated from listprice
            case 'installatie': $hours = $listprice / 110 * $qty;
                break;
            case 'eenmalig': $hours = $listprice / 110 * $qty;
                break;
            default: $hours = 0;
                break;
        }

        // prod code = test-sup
        // 20% on top of selected phases (not A = design)
        // per werkitem een testfactor meenemen (x% uplift obv complexiteit)
        if (!in_array(strtolower(substr($ProdArray['sortorder' . $prodkey], 0, 1)), array('a', 'h', 'i', 'j', 'l', 'n')))
        {
            $testHours[$phaseNr] = $testHours[$phaseNr] + ($hours * 0.2);
        }

        // prod code = projmngt
        // @change lro 130222 except if uplift was blocked
        // jho - if ( $my_focus->column_fields['c_lead_solutions'] == 0 && !in_array(strtolower(substr($ProdArray['sortorder'.$prodkey],0,1)), array('') ) )
        // if (showTextBlock($my_focus->column_fields['c_picklist_settings'], 'pm_fee') === false && !in_array(strtolower(substr($ProdArray['sortorder'.$prodkey],0,1)), array('') ) )
        if ($pdfmConfig->getPicklistValue('pm_fee') === false && !in_array(strtolower(substr($ProdArray['sortorder' . $prodkey], 0, 1)), array('')))
        {
            // 10% over alles behalve software en add-ons
            $pmHours[$phaseNr] = $pmHours[$phaseNr] + ( $hours * 0.1 );
        }
    }

    // $section = 'Projectkosten';
    $section = 'Projectmanagement';


    foreach ((array) $pmHours as $phaseNr => $hours)
    {
        $tariff = $pdfmConfig->servicedesktarief;
        $cell = round($hours * $tariff, 2);
        $totalsPerPhase[$section][$phaseNr] = $totalsPerPhase[$section][$phaseNr] + $cell;
        $totalsPerPhase['total'][$phaseNr] = $totalsPerPhase['total'][$phaseNr] + $cell;
    }

    $section = 'Testondersteuning';

    foreach ($testHours as $phaseNr => $hours)
    {
//    $cell=round($hours * 90,2);
//    $totalsPerPhase[$section][$phaseNr] = $totalsPerPhase[$section][$phaseNr] + $cell;
//    $totalsPerPhase['total'][$phaseNr] = $totalsPerPhase['total'][$phaseNr] + $cell;
    }

    // ensure we have the sections ($text) in our prefered order
    // @change 111206 lro
    // $sectionOrder = array('Software','Add-on','Projectkosten','Jaarkosten');
    $sectionOrder = array('Jaarkosten', 'Software', 'Add-on', 'Projectkosten');
    foreach ($sectionOrder AS $sectid => $key)
    {
        if (!empty($text[$key]))
        {
            $textReordered[$key] = $text[$key];
        }
    }
    // end change
// echo '<pre>';print_r($textReordered); die(__FILE__);

    $firstSectionPassed = false;
    $headerplaced = false;

    foreach ((array) $textReordered AS $sect => $content)
    {
        // @change lro 120626 - order per section / phase
        ksort($content);

        if ($firstSectionPassed)
        {
            $return .= '</table><br />' . "\n";
        }

        $firstSectionPassed = true;
        $return .= '<table border="0" cellpadding="0" cellspacing="0" width="100%" autosize="1.0" style="page-break-inside:avoid;">' . "\n";
        $return .= '<tr>' . "\n";

        if ($sect == 'Add-on')
        {
            $sectText = 'Projectkosten (Modules)';
        } elseif ($sect == 'Software')
        {
            $sectText = 'Projectkosten (Software)';
        } elseif ($sect == 'Jaarkosten')
        {
            $sectText = 'Abonnementen / Jaarkosten';
        } elseif ($sect == 'Projectkosten')
        {
            $sectText = 'Projectkosten (Dienstverlening)';
        } else
        {
            $sectText = $sect;
        }

        $spanCount = count($Columns) - count($aPhases);

        if (count($aPhases) > 1)
        {
            $spanCount--;
        }

        if ($sect == 'Jaarkosten')
        {
            $return .= "\t" . '<td style="padding: 15px 0 10px 0; border-top:2px solid black;" colspan="' . count($Columns) . '"><span style="font-size: 10px;"><bookmark content="' . $sectText . '" level="1"></bookmark><h2>' . $sectText . '</h2></span></td></tr>' . "\n<tr>\n";
        } else
        {
            if (!$headerplaced)
            {
                $return .= "\t" . '<td style="padding: 15px 0 10px 0; border-top:2px solid black;" colspan="' . count($Columns) . '"><span style="font-size: 10px;"><bookmark content="Eenmalige investering" level="1"></bookmark><h2>Eenmalige investering</h2></span></td></tr>' . "\n<tr>\n";
                $headerplaced = true;
            }

            $return .= "\t" . '<td style="padding: 5px 0 5px 0px;" colspan="2"><span style="font-size: 10px;"><strong>' . $sectText . '</strong></span></td>' . "\n";
        }

        $return .= '</tr>' . "\n";
        $return .= '<tr>' . "\n" . $headerLine; //.'</tr>'."\n";

        foreach ((array) $content as $sorder => $string)
        {
            $return .= $string;
            /* A. Architectuur en Ontwerp
             * B. Basisplatform inrichten
             * C. Template en vormgeving
             * D. Maatwerk
             * E. Integratie
             * F. Inregelen processen en worksflows
             * G. Gegevensverwerking
             * H. Documentatie en handleidingen
             * I. Testen
             * J. Go-Live
             * K. Upgrades en Migraties - c_func_tech_supportL. Gebruikersondersteuning
             * M. Content creatie
             * N. Internetmarketing
             * O. Conventionele marketing
             * */
        }

        $return .= '</tr>' . "\n";
        $return .= '<tr>' . "\n";
        $return .= "\t" . '<td colspan="' . $spanCount . '"' . $align . ' style="border-bottom: 1px solid rgb(204, 204, 204);padding: 5px 0 0 5px;">';

//    $faseText = (count($aPhases) > 1) ? "per fase " : "";
        $faseText = "";
        $return .= '<span style="font-size: 10px; text-align:right;font-weight:bold;">' . $sectText . ' ' . $faseText . ':</span></td>' . "\n";

        if (count($aPhases) > 1)
        {
            foreach ($aPhases as $pId => $pText)
            {
                $cell = formatNumberToPDF((int) $totalsPerPhase[$sect][$pId], 0);
                $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-bottom: 1px solid rgb(204, 204, 204);"' . $align . '><span style="font-size: 10px; font-weight:bold;">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
            }
        }

        $cell = '&euro;&nbsp;' . formatNumberToPDF($totalAfterDiscount[$sect], 0);
        $align = ' align="right"';
        $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-bottom: 1px solid rgb(204, 204, 204);"' . $align . '><span style="font-size: 10px; font-weight:bold;">' . $cell . '</span></td>' . "\n";
        $return .= '</tr>' . "\n";

        if ($sect == 'Jaarkosten' && ($discountSettingTxt == "Jaarkosten" || $discountSettingTxt == "Hele offerte"))
        {
            // @change lro 152022 end add discount on yearly fees
            $discountPercent = (float) $my_focus->column_fields['hdnDiscountPercent'];

            $colspancalc = count($aPhases) + 3;

            if ($discountPercent > 0)
            {
                $return .= '<tr>' . "\n";
                $return .= "\t" . '<td style="padding: 5px 0 0 5px;" colspan="' . $colspancalc . '"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);">Subtotaal Jaarkosten (excl. BTW)</span></td>' . "\n";
                $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:normal;"' . $align . '><span style="font-size: 10px; ">' . $cell . '</span></td>' . "\n";
                $return .= '</tr>' . "\n";

                $discountAmount = $totalAfterDiscount[$sect] * $discountPercent / 100;
                $cell = '&euro;&nbsp;' . formatNumberToPDF($discountAmount, 0);
                $return .= '<tr>' . "\n";
                $return .= "\t" . '<td style="padding: 5px 0 0 5px;" colspan="' . $colspancalc . '"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);">-/- Korting (' . number_format($discountPercent, 2) . '%)</span></td>' . "\n";
                $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-top: 0px solid rgb(204, 204, 204);font-weight:normal;"' . $align . '><span style="font-size: 10px; ">' . $cell . '</span></td>' . "\n";
                $return .= '</tr>' . "\n";

                $amountToPayYearly = $totalAfterDiscount[$sect] - $discountAmount;
                $cell = '&euro;&nbsp;' . formatNumberToPDF($amountToPayYearly, 0);
                $return .= '<tr>' . "\n";
                $return .= "\t" . '<td colspan="' . $colspancalc . '" style="padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px;border-top: none;font-weight:bold;">Totaal jaarkosten (excl. BTW)</span></td>' . "\n";
                $return .= "\t" . '<td style="padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;"' . $align . '><span style="font-size: 10px; ">' . $cell . '</span></td>' . "\n";
                $return .= '</tr>' . "\n";
            } else
            {
                $discountAmount = 0;
                $return .= '<tr>' . "\n";
                $return .= "\t" . '<th style="padding: 5px 0 0 5px;" colspan="' . $colspancalc . '"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);">Totaal Jaarkosten (excl. BTW)</span></th>' . "\n";
                $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;"' . $align . '><span style="font-size: 10px; ">' . $cell . '</span></td>' . "\n";
                $return .= '</tr>' . "\n";
            }
            // @change end add discount on yearly fees
            //nodig voor de AllInText
            $AllInTextAmountToPayYearly = $totalAfterDiscount['Jaarkosten'];
            $AllInTextDiscountAmountYearly = $discountAmount;
        }
    }

    $return .= '</tbody>' . "\n";
    $return .= '</table>' . "\n";


    // @change lro 150319
    // there seems to be a problem if we have 1 phase and amount 0 (so free!)
    //  no only problem if we have no services / projectcost
    // if zero we don't show any projectcost table
    // if (count($aPhases) > 0)
    if (count($aPhases) > 0 && !empty($totalsPerPhase['total']))
    {
        $align = ' align="right" ';
        $return .= '<br />';
        $return .= '<table border="0" cellpadding="0" cellspacing="0" width="100%" autosize="1.0" style="page-break-inside:avoid;">' . "\n";
        $return .= '<tbody>' . "\n";
        $return .= '<tr style="border-top: 2px solid rgb(204, 204, 204);">' . "\n";
        $cols = count($aPhases) + 1;
        $return .= '<td colspan="' . $cols . '" style="border: none; "><strong>Overzicht Eenmalige Investeringen (excl Jaarkosten)</strong></td>' . "\n";
        $return .= '</tr>' . "\n";

        $return .= '<tr style="border-top: 2px solid rgb(204, 204, 204);">' . "\n";
        // $width=100-10-($cols*10); // 140422 lro -10 verwijderd vanwege te korte table in uitgebreide offerte
        $width = 100 - 10 - (count($aPhases) * 10);

        $return .= '<th width="' . $width . '%" align="right" style="border: none; ">Onderdeel</th>' . "\n";

        foreach ($aPhases as $pId => $pText)
        {
            $pText = trim(substr($pText, 1));  // remove # and space
            $return .= '<th width="10%" align="right" style="border: none; ">' . $pText . '</th>' . "\n";
        }

        $return .= '<th width="10%" align="right" style="border: none; ">Totaal</th>' . "\n";
        $return .= '</tr>' . "\n";

        # We show the rows
        # But we skip the Yearly costs!
        $rowTtl = array();

        foreach ($totalsPerPhase as $sect => $phaseInfo)
        {
            if ($sect == 'total' || strtolower($sect) == 'jaarkosten')
                continue;

            $return .= '<tr>' . "\n";

            if ($sect == 'Add-on')
            {
                $sectText = 'Projectkosten (Modules)';
            } elseif ($sect == 'Software')
            {
                $sectText = 'Projectkosten (Software)';
            } elseif ($sect == 'Projectmanagement')
            {
                $sectText = 'Projectmanagement & Communicatie';
            } elseif ($sect == 'Projectkosten')
            {
                $sectText = 'Projectkosten (Dienstverlening)';
            } else
            {
                $sectText = $sect;
            }

            $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px; ">' . $sectText . '</span></td>' . "\n";

            foreach ($aPhases as $pId => $pText)
            {
                $rowTtl[$sect] = $rowTtl[$sect] + (float) $totalsPerPhase[$sect][$pId];
                $cell = formatNumberToPDF((float) $totalsPerPhase[$sect][$pId], 2);

                /* @change lro 120301 disabled 
                  if ($sect == 'Jaarkosten') // we still want thee in all phases!'just in the total column
                  $return .= "\t".'<td style="width:10%; padding: 5px 0 0 5px;"'.$align.'><span style="font-size: 10px; ">&nbsp;</span></td>'."\n";
                  else
                 */
                $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
            }

            $cell = formatNumberToPDF((float) $rowTtl[$sect], 2);
            $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
            $return .= '</tr>' . "\n";
        }

        $blankColumns = count($aPhases) + 1;
        $discountPercent = (float) $my_focus->column_fields['hdnDiscountPercent'];

        $return .= '<tr>' . "\n";

        if ($discountPercent > 0)
        {
            $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);font-weight:normal;">Subtotaal Eenmalige investeringen</span></td>' . "\n";
        } else
        {
            $return .= "\t" . '<th style="width:10%; padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);">Optelling Eenmalige investeringen (excl. BTW)</span><br><span style="font-size: 8px;border:none;">Geldt niet als een tussen partijen overeengekomen vaste prijs!</span></th>' . "\n";
        }

        ksort($totalsPerPhase['total']);
        foreach ($totalsPerPhase['total'] as $pId => $pText)
        {
            $rowTtl['total'] = $rowTtl['total'] + (float) $totalsPerPhase['total'][$pId];
            $cell = formatNumberToPDF((float) $totalsPerPhase['total'][$pId], 0);
            $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
        }

        $cell = formatNumberToPDF((float) $rowTtl['total'], 0);
        $return .= "\t" . '<td style="width:10%; padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
        $return .= '</tr>' . "\n";

        if ($discountPercent > 0 && ($discountSettingTxt == "Projectkosten" || $discountSettingTxt == "Hele offerte"))
        {
            $return .= '<tr>' . "\n";
            $return .= "\t" . '<td colspan="' . $blankColumns . '" style="padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px;border-top: none;">-/- Korting (' . number_format($discountPercent, 2) . '%)</span></td>' . "\n";
            $discountAmount = $rowTtl['total'] * $discountPercent / 100;
            $cell = formatNumberToPDF($discountAmount, 2);
            $return .= "\t" . '<td style="padding: 5px 0 0 5px;border:none;font-weight:normal;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
            $return .= '</tr>' . "\n";

            $subtotaal = $rowTtl['total'] - $discountAmount;
            $return .= '<tr>' . "\n";
            $return .= "\t" . '<td colspan="' . $blankColumns . '" style="padding: 5px 0 0 5px;"' . $align . '><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;">Optelling Eenmalige Investeringen (excl. BTW)</span><br><span style="font-size: 8px;border:none;">(geldt niet als een tussen partijen overeengekomen vaste prijs)</span></td>' . "\n";
            $cell = formatNumberToPDF($subtotaal, 0);
            $return .= "\t" . '<td style="padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:bold;"' . $align . '><span style="font-size: 10px; ">&euro;&nbsp;' . $cell . '</span></td>' . "\n";
            $return .= '</tr>' . "\n";
        } else
        {
            $subtotaal = $rowTtl['total'];
            $discountAmount = 0;
        }

        // ============================================================================================================ Samenstellen als tekst
        // $allInTextA bevat qty en unit of measure
        $allInTextInMaandkosten = array();
        $allInTextInProjectkosten = array();
//        var_dump($allInTextA); die();
        foreach ($allInTextA as $vebProductname => $vebProductlines)
        {
//        var_dump($vebProductlines); die();
            $vebQty = $vebProductlines['qty'];
            $vebUnit = $vebProductlines['unit'];
            $vebAmount = $vebProductlines['amount']; // price each
            $vebTotal = $vebProductlines['total']; // price each x qty
            $vebSortorder = $vebProductlines['sortorder']; // price each x qty
            $isstelpost = false;
            $istimebox = false;

            // als het woord stelpost in de naam staat, meldt dan amount x aantal
            if (stripos($vebProductname, 'stelpost') !== false)
            {
                $stelpostvebProductname = str_ireplace(array('(stelpost)', 'stelpost'), '', $vebProductname);
                $stelpostvebProductname = trim($stelpostvebProductname);
                switch ($vebUnit)
                {
                    case 'eenmalig':
                        $allInTextInStelposten[$vebSortorder] = "&euro;&nbsp;{$vebAmount} voor $stelpostvebProductname";
                        break;
                    case 'hours':
                        $allInTextInStelposten[$vebSortorder] = "{$vebQty} uur voor $stelpostvebProductname";
                        break;
                    default:
                        $allInTextInStelposten[$vebSortorder] = "$stelpostvebProductname ({$vebQty} {$vebUnit} x {$vebAmount} )";
                }
                $isstelpost = true;
            }

            // t4436
            $allInTextInTimeboxen = array();

            // als het woord stelpost in de naam staat, meldt dan amount x aantal
            if (stripos($vebProductname, 'timebox') !== false)
            {

                $timeboxvebProductname = str_ireplace(array('(timebox)', 'timebox'), '', $vebProductname);
                $timeboxtvebProductname = trim($timeboxvebProductname);
                switch ($vebUnit)
                {
                    case 'eenmalig':
                        $allInTextInTimeboxen[$vebSortorder] = "&euro;&nbsp;{$vebTotal} voor $timeboxvebProductname";
                        break;
                    case 'hours':
                        $allInTextInTimeboxen[$vebSortorder] = "{$vebQty} uur voor $timeboxvebProductname";
                        break;
                    default:
                        $allInTextInTimeboxen[$vebSortorder] = "$timeboxvebProductname ({$vebQty} {$vebUnit} x {$vebAmount} )";
                }
                $istimebox = true;
            }


            if ($vebUnit == 'jaar' || $vebUnit == 'maanden' || $vebUnit == 'maand' || $vebUnit == 'gebr. pjr' )
            {
                $maandvebProductname = str_ireplace(array(' - per maand', ' Jaarkosten'), '', $vebProductname);
                switch ($vebUnit)
                {
                    case 'gebr. pjr':
                        $allInTextInMaandkosten[$vebSortorder] = "{$vebQty} x ".$vebProductname;
                        break;
                    default:
                        $allInTextInMaandkosten[$vebSortorder] = trim($maandvebProductname);
                } 
            } elseif (!$isstelpost && !$istimebox)
            {
                if ($vebQty == 1)
                {
                    $allInTextInProjectkosten[$vebSortorder] = $vebProductname;
                } else
                {
                    switch ($vebUnit)
                    {
                        case 'eenmalig':
                            $allInTextInProjectkosten[$vebSortorder] = $vebQty . " x " . $vebProductname;
                            break;
                        case 'hours':
                            $allInTextInProjectkosten[$vebSortorder] = $vebProductname;
                            break;
                        default:
                            $allInTextInProjectkosten[$vebSortorder] = $vebQty . " x {$vebUnit} " . $vebProductname;
                    }
                }
            }
        }

        // sort by key / given sortorder
        ksort($allInTextInStelposten);
        ksort($allInTextInTimeboxen);
        ksort($allInTextInMaandkosten);
        ksort($allInTextInProjectkosten);

        // round on eur 5
        $commercialSubtotaal = round($subtotaal / 100, 0);
        $commercialSubtotaal = ($commercialSubtotaal * 100) + 50;
        $projectkosten = formatNumberToPDF($commercialSubtotaal, 0);

        $maandkosten = formatNumberToPDF($AllInTextAmountToPayYearly / 12, 2);

        if ($projectkosten > 0)
        {
            $allInText .= "<p>Wij kunnen dit project, zoals in deze offerte beschreven, voor jou uitvoeren voor een <em>eenmalige investering</em> van <strong>&euro;&nbsp;{$projectkosten},=</strong>.";
        }
        if ($maandkosten > 0)
        {
            $allInText .= " Bij de beschreven configuratie zijn de maandelijkse <em>abonnementskosten</em> <strong>&euro;&nbsp;{$maandkosten}</strong> (bij betaling vooruit per jaar).";
        }

        if ($discountAmount > 0)
        {
            $kortingprojectkosten = formatNumberToPDF($discountAmount, 2);
            $allInText .= " Hierbij hebben wij rekening gehouden met een eenmalige korting van &euro;&nbsp;{$kortingprojectkosten} op de projectkosten.";
        }
        if ($AllInTextDiscountAmountYearly > 0)
        {
            $kortingjaarkosten = formatNumberToPDF($AllInTextDiscountAmountYearly / 12, 2);
            $allInText .= " Inclusief een eenmalige korting van &euro;&nbsp;{$kortingjaarkosten} op de abonnementskosten.";
        }
        $allInText .= '</p>';

        if ($projectkosten > 0)
        {
            $allInText .= '<h2>Toelichting eenmalige investering</h2>';
            //        $tableProjecten = veb_formatAsTable(implode(', ', $allInTextInProjectkosten));
            $tableProjecten = veb_formatAsTable($allInTextInProjectkosten);
            $allInText .= "<p>De eenmalige investering omvat:</p>" . $tableProjecten;
            if (count($allInTextInStelposten) > 0)
            {
                $allInText .= '<br /><h3>Omdat we nog niet alles weten werken we met stelposten</h3>';
                $tableStelposten = veb_formatAsTable($allInTextInStelposten);
                $allInText .= "<p>Binnen de eenmalige investering zijn wij uitgegaan van de volgende stelposten (definitieve invulling en budget wordt tijdens het project in overleg bepaald):</p>" . $tableStelposten;
            }
            if (count($allInTextInTimeboxen) > 0)
            {
                $allInText .= '<br /><h3>Omdat we creativiteit willen bieden werken we met timeboxen</h3>';
                $tableTimeboxen = veb_formatAsTable($allInTextInTimeboxen);
                $allInText .= "<p>Binnen de eenmalige investering zijn we uitgegaan van de volgende timeboxen (deze tijd wordt in overleg met jou besteed):</p>" . $tableTimeboxen;
            }
        }

        if ($maandkosten > 0)
        {
            $allInText .= '<h2>Toelichting abonnementskosten</h2>';
            $tableMaandkosten = veb_formatAsTable($allInTextInMaandkosten);
            $allInText .= "<p>In de abonnementskosten is opgenomen:</p>" . $tableMaandkosten;
        }
// @change lro 140327 removed btw
        /**
          $return .= '<tr>'."\n";
          $vatAmount = $subtotaal * 0.21; // @change lro 120927 naar 21% !
          $return .= "\t".'<td colspan="'.$blankColumns.'" style="padding: 5px 0 0 5px;"'.$align.'><span style="font-size: 10px;border: none;">BTW (21%) +</span></td>'."\n";
          $cell = formatNumberToPDF((float)$vatAmount,2);
          $return .= "\t".'<td style="width:10%; padding: 5px 0 0 5px;border: none;font-weight:normal;"'.$align.'><span style="font-size: 10px; ">&euro;&nbsp;'.$cell.'</span></td>'."\n";
          $return .= '</tr>'."\n";

          $return .= '<tr>'."\n";
          $return .= "\t".'<td colspan="'.$blankColumns.'" style="padding: 5px 0 0 5px;"'.$align.'><span style="font-size: 10px;border-top: 1px solid rgb(204, 204, 204);">Totaal (incl. BTW)</span></td>'."\n";
          $cell = formatNumberToPDF((float)$subtotaal + $vatAmount,2);
          $return .= "\t".'<td style="width:10%; padding: 5px 0 0 5px;border-top: 1px solid rgb(204, 204, 204);font-weight:normal;"'.$align.'><span style="font-size: 10px; ">&euro;&nbsp;'.$cell.'</span></td>'."\n";
          $return .= '</tr>'."\n";
         * */
        $return .= '</tbody>' . "\n";
        $return .= '</table>' . "\n";
    }

// print __FILE__ . '<hr>'; print($return);die(__FILE__);

    $return .= '<br /><p>Het betaalschema vind je terug in de paragraaf <em>Tarieven, facturering en betaling</em> in het hoofdstuk <em>Contractvoorwaarden en ondertekening</em>.</p>' . "\n";

    $allInText .= '<h2>Betaalschema</h2>';
    $allInText .= '<p>Het betaalschema vind je terug in de paragraaf <em>Tarieven, facturering en betaling</em> in het hoofdstuk <em>Contractvoorwaarden en ondertekening</em>.</p>' . "\n";

    $returnText = '';

    // default if nothing set
    if (!$pdfmConfig->getPicklistValue('investeringstext') && !$pdfmConfig->getPicklistValue('investeringsoverzicht'))
    {
        $returnText .= $return;
    }

    if ($pdfmConfig->getPicklistValue('investeringstext') === true)
    {
        $returnText .= $allInText;
    }

    if ($pdfmConfig->getPicklistValue('investeringsoverzicht') === true)
    {
        $returnText .= $return;
    } elseif ($renvooi && $pdfmConfig->getPicklistValue('investeringstext') === true)
    {
        $returnText .= '<div style="border:solid 2px red;"><br /><p style="color:red; text-align:center;">----------- Deze tabel staat alleen in de renvooi versie, als deze ook naar de klant moet dan instellingen in de configurator aanpassen! ------</p><br /><br />' . $return . '<br /><br /><p style="color:red; text-align:center;">----------- Deze tabel staat alleen in de renvooi versie, als deze ook naar de klant moet dan instellingen in de configurator aanpassen! ------</p>' . '</div>';
    }

    if ($returnText == '')
    {
        $returnText = $allInText;
    }


    if ($pdfmConfig->getPicklistValue('m2-update') === true)
    {
        $returnText .= veb_getTextBlock($invid, 'special', $size = '12px', $ForceNewPage = False);
    }

    if ($pdfmConfig->getPicklistValue('vtiger-update') === true)
    {
        $returnText .= veb_getTextBlock($invid, 'special', $size = '12px', $ForceNewPage = False);
    }

//die($returnText);


    return $returnText;
}

function veb_formatAsTable($dataArray, $columns = 2)
{
    $html = '<table>';
    $qty = count($dataArray);
    $counter = 0;
    foreach ($dataArray as $id => $label)
    {
        if ($counter + 1 & $columns - 1)
        {
            $html .= '<tr><td width="50%"><i style="font-family:fontawesome;" class="fa">&#xf00c;</i>&nbsp;' . $label . '</td>';
        } else
        {
            $html .= '<td width="50%"><i style="font-family:fontawesome;" class="fa">&#xf00c;</i>&nbsp;' . $label . '</td></tr>';
        }
        $counter++;
    }
    $html .= '</table>';
    return $html;
}

function getInventoryBreaklines($invid)
{
    global $adb;
    $sql = "SELECT productid, sequence FROM vtiger_pdfmaker_breakline WHERE crmid=?";
    $res = $adb->pquery($sql, array($invid));
    $products = array();

    while ($row = $adb->fetchByAssoc($res)) {
        $products[$row["productid"] . "_" . $row["sequence"]] = $row["sequence"];
    }

    return $products;
}

// @change lro look like it is looking at the wrong location 9at elast for Vicus internal use)
function getInventoryImages($invid)
{
    global $adb;

    /* @change lro 111105 changed the query to get any results :-)
      $sql="SELECT vtiger_attachments.path, vtiger_attachments.name, vtiger_attachments.attachmentsid, productid, sequence, width, height
      FROM vtiger_pdfmaker_images
      INNER JOIN vtiger_attachments
      ON vtiger_attachments.attachmentsid=vtiger_pdfmaker_images.attachmentid
      INNER JOIN vtiger_crmentity
      ON vtiger_attachments.attachmentsid=vtiger_crmentity.crmid
      WHERE deleted=0 AND vtiger_pdfmaker_images.crmid=?";
     */
    $sql = "SELECT vtiger_attachments.path, vtiger_attachments.name, vtiger_attachments.attachmentsid, productid, sequence, width, height
  FROM vtiger_pdfmaker_images
  INNER JOIN vtiger_attachments
   ON vtiger_attachments.attachmentsid=vtiger_pdfmaker_images.attachmentid
  INNER JOIN vtiger_crmentity
   ON vtiger_pdfmaker_images.productid=vtiger_crmentity.crmid
  WHERE deleted=0 AND vtiger_pdfmaker_images.productid=?";
    /*
      $sql="SELECT vtiger_attachments.path, vtiger_attachments.name, vtiger_attachments.attachmentsid,vtiger_attachments.description, vtiger_attachments.type
      FROM vtiger_attachments
      INNER JOIN vtiger_crmentity ON vtiger_attachments.attachmentsid=vtiger_crmentity.crmid
      WHERE deleted=0 AND vtiger_crmentity.crmid=?";
     */

    $res = $adb->pquery($sql, array($invid));
    $products = array();
    while ($row = $adb->fetchByAssoc($res)) {
        $products[$row["productid"] . "_" . $row["sequence"]]["src"] = $row["path"] . $row["attachmentsid"] . "_" . $row["name"];
        $products[$row["productid"] . "_" . $row["sequence"]]["width"] = $row["width"];
        $products[$row["productid"] . "_" . $row["sequence"]]["height"] = $row["height"];
    }

    return $products;
}

/**
 * @change lro 111117 added cache handler to save SQL query time
 * otherwise it loads the settings for each and every variable
 */
function formatNumberToPDF($value, $decimals = false)
{
    global $PDFMaker_template_id, $adb, $formatNumberToPDF_cache;

    if (is_numeric($value))
    {
        if (is_array($formatNumberToPDF_cache) && !empty($formatNumberToPDF_cache))
        {
            $data = $formatNumberToPDF_cache;
        } else
        {
            $sql = "SELECT decimals, decimal_point, thousands_separator
              FROM vtiger_pdfmaker_settings
              WHERE templateid=?";

            $result = $adb->pquery($sql, array($PDFMaker_template_id));
            $data = $adb->fetch_array($result);
            $formatNumberToPDF_cache = $data;
        }

        $decimal_point = html_entity_decode($data["decimal_point"], ENT_QUOTES);
        $thousands_separator = html_entity_decode(($data["thousands_separator"] != "sp" ? $data["thousands_separator"] : " "), ENT_QUOTES);

        if ($decimals === false)
        {
            $decimals = $data["decimals"];
        }

        $number = number_format($value, $decimals, $decimal_point, $thousands_separator);
    } else
    {
        $number = "";
    }
    return $number;
}

function show()
{
    $input_args = func_get_args();
    if (!empty($input_args))
    {
        foreach ($input_args as $input)
        {
            if (is_array($input))
            {
                echo '<table border="0">';
                echo '<tr><th>Key</th><th>Value</th></tr>';
                foreach ($input as $key => $value)
                {
                    echo "<tr><td>$key</td><td>";
                    show($value);
                    echo "</td></tr>";
                }

                echo "</table>";
            } elseif (is_resource($input) || is_object($input))
            {
                echo "<pre>";
                print_r($input);
                echo "</pre>";
            } elseif (is_bool($input))
            {
                if ($input)
                {
                    echo "<i>true</i>";
                } else
                {
                    echo "<i>false</i>";
                }
                echo "<br />";
            } else
            {
                echo $input . "<br />";
            }
        }
    }
}

function swapAssociatedProducts(&$associated_prod, $key)
{
    if ($key == 1)
    {
        return;
    }

    while ($key > 0) {
        $key1 = $key - 1;

        if ($associated_prod[$key]['sortorder' . $key] < $associated_prod[$key1]['sortorder' . $key1])
        {
            // current shall be before previous
            $Swap = $associated_prod[$key];
            foreach ($associated_prod[$key1] as $prevkey => $prevvalue)
            {
                $keypart = substr($prevkey, 0, strlen($prevkey) - strlen($key1));

                if ($keypart != 'final_detail')
                {
                    $associated_prod[$key][$keypart . $key] = $prevvalue;
                    $associated_prod[$key1][$prevkey] = $Swap[$keypart . $key];
                }
            }
        }
        $key--;
    }
}

function getPagebreaks($invid)
{
    global $adb, $PDFMaker_template_id;
    $sql = "SELECT orientation, margin_left, margin_top, margin_right, margin_bottom
        FROM vtiger_pdfmaker_settings
        WHERE templateid=?";
    $result = $adb->pquery($sql, array($PDFMaker_template_id));
    $data = $adb->fetchByAssoc($result);

    $pagebreak = '<pagebreak orientation="' . $data["orientation"] . '" margin-left="' . ($data["margin_left"] * 10) . 'mm" margin-right="' . ($data["margin_right"] * 10) . 'mm" margin-top="0mm" margin-bottom="0mm" margin-header="' . ($data["margin_top"] * 10) . 'mm" margin-footer="' . ($data["margin_bottom"] * 10) . 'mm" />';
    return $pagebreak;
}

function lroGetProductDetails($associated_prod = array())
{
    global $adb;

    $pdfmConfig = new pdfmConfig();

    $service_category = $pdfmConfig->service_category; // 'c_qoute_cluster';
    $service_order = $pdfmConfig->service_order; // 'c_clusterode';
    $service_phase = $pdfmConfig->service_phase; // 'c_growth_modelphase';

    $product_category = $pdfmConfig->product_category; // 'c_clustercode'; //
    $product_order = $pdfmConfig->product_order; // 'c_qoute_cluster';  // clustercode succesmodel offerteopbouw
    $product_phase = $pdfmConfig->product_phase; // 'c_growth_model_fase';
    // c_annual_maintenance // Yearly fee
    // sort products
    foreach ((array) $associated_prod as $key => $prod_info)
    {
        if ($prod_info['entityType' . $key] == 'Products')
        {
//      echo "select ".$product_order." as ord, ".$product_category." as section, ".$product_phase." as phase from vtiger_products where productid=".$prod_info['hdnProductId'.$key];
            $sql1 = "select " . $product_order . " as ord, " . $product_category . " as section, " . $product_phase . " as phase, c_annual_maintenance as yearlyfee, c_tagline AS tagline from vtiger_products where productid=" . $prod_info['hdnProductId' . $key];
            $res = $adb->query($sql1);
            $sql2 = "select usageunit,website,productcode from vtiger_products where productid=" . $prod_info['hdnProductId' . $key];
            $res2 = $adb->query($sql2);
        } elseif ($prod_info['entityType' . $key] == 'Services')
        {
//      echo "select ".$service_order." as ord, c_partsnumber as productcode, ".$service_category." as section ".$service_phase." as phase from vtiger_service where serviceid=".$prod_info['hdnProductId'.$key];
//      $res = $adb->query("select ".$service_order." as ord, ".$service_category." as section from vtiger_service where serviceid=".$prod_info['hdnProductId'.$key]);
            $sql1 = "select " . $service_order . " as ord, c_partsnumber as productcode, " . $service_category . " as section, " . $service_phase . " as phase from vtiger_service where serviceid=" . $prod_info['hdnProductId' . $key];
            $res = $adb->query($sql1);
            $sql2 = "select service_usageunit AS usageunit from vtiger_service where serviceid=" . $prod_info['hdnProductId' . $key];
            $res2 = $adb->query($sql2);
        } else
        {
            continue;
        }

        $row = $adb->fetchByAssoc($res);
        $row2 = $adb->fetchByAssoc($res2);

        if ($row['ord'] == '')
        {
            $row['ord'] = '9999999';
        }

        if ($merge)
        {
            if ($prod_info['entityType' . $key] == 'Products' && strtolower($row[$product_category]) != '--geen--' && trim($row[$product_category] != ''))
            {
                $row['ord'] = '99999999' . $Pick[$row[$product_category]];
            }
        }

//    $associated_prod[$key]['sortorder'.$key] = $row['ord'];
// @change order 180403 lro
        $associated_prod[$key]['sortorder' . $key] = $row['ord'] . $row['productcode'];
        $associated_prod[$key]['section' . $key] = $row['section'];
        $associated_prod[$key]['phase' . $key] = (int) substr($row['phase'], 0, 1);

        $associated_prod[$key]['tagline' . $key] = $row['tagline'];

        // @change lro 140328
        // @change lro 140508 .. @todo oops need to multiply by qty in the totals
        $associated_prod[$key]['yearlyfee' . $key] = $row['yearlyfee'];

//    $associated_prod[$key]['qty'.$key]=0
        // might overriden through [comment45]
//    print substr($ProdArray['comment'.$prodkey],0,2);
        if (strtoupper(substr($prod_info['comment' . $key], 0, 2)) == '#F')
        {
            $phaseOverride = substr($prod_info['comment' . $key], 2, 1);
            if ($phaseOverride >= 0 && $phaseOverride <= 6)
            {
                $associated_prod[$key]['phase' . $key] = $phaseOverride;
            } else
            {
                print 'Error in fase override - Ongeldig fasenummer voor product/dienst' . print_r($associated_prod[$key]);
                die();
            }
        }

        // @change lro 111031
//    print_r($row2);
        $associated_prod[$key]['usageunit' . $key] = $row2['usageunit'];

        if ($prod_info['entityType' . $key] == 'Products')
        {
            $associated_prod[$key]['productcode' . $key] = $row2['productcode'];
        } else
        {
            $associated_prod[$key]['productcode' . $key] = $row['productcode'];
        }
        
        // @change lro 210111 - ticket 38144 - add prodnr toe aan offerte
        $associated_prod[$key]['productName' . $key] = $associated_prod[$key]['productName' . $key].' ('.strtolower($associated_prod[$key]['hdnProductcode' . $key]).')';

        swapAssociatedProducts($associated_prod, $key);
// print '<pre>';var_dump($associated_prod); die();
    }

    // sort products - end
    // merge products
    if ($merge)
    {
        foreach ($associated_prod as $key => $prod_info)
        {
            $res = $adb->query("select " . $product_category . " from vtiger_products where productid=" . $prod_info['hdnProductId' . $key]);
            $row = $adb->fetchByAssoc($res);
            $associated_prod[$key]['category' . $key] = $row[$product_category];
            if (strtolower($row[$product_category]) != '--geen--' && trim($row[$product_category] != ''))
            {
                $category_association[$row[$product_category]][$key] = $prod_info['hdnProductId' . $key];
                if (!isset($first_product_in_association[$row[$product_category]]))
                {
                    $first_product_in_association[$row[$product_category]] = $key;
                }
            }
        }

        foreach ($category_association as $assoc => $prod_info)
        {
            foreach ($prod_info as $key => $id)
            {
                if ($key == $first_product_in_association[$assoc])
                {
                    $associated_prod[$key]['productName' . $key] = $assoc;
                    $associated_prod[$key]['hdnProductcode' . $key] = '';
                    $associated_prod[$key]['subProductArray' . $key] = array();
                    $associated_prod[$key]['qty' . $key] = 0;
                    $associated_prod[$key]['listPrice' . $key] = $associated_prod[$key]['productTotal' . $key];
                    $associated_prod[$key]['unitPrice' . $key] = $associated_prod[$key]['productTotal' . $key];
                } else
                {
                    $first = $first_product_in_association[$assoc];
                    $associated_prod[$first]['netPrice' . $first] += $associated_prod[$key]['netPrice' . $key];
                    $associated_prod[$first]['totalAfterDiscount' . $first] += $associated_prod[$key]['totalAfterDiscount' . $key];
                    $associated_prod[$first]['productTotal' . $first] += $associated_prod[$key]['productTotal' . $key];
                    $associated_prod[$first]['listPrice' . $first] = $associated_prod[$first]['productTotal' . $first];
                    $associated_prod[$first]['unitPrice' . $first] = $associated_prod[$first]['productTotal' . $first];
                    if ($associated_prod[$key]['discount_percent' . $key] > 0)
                    {
                        $associated_prod[$first]['discount_amount' . $first] += $associated_prod[$key]['productTotal' . $key] - $associated_prod[$key]['totalafterdiscount' . $key];
                    }

                    $associated_prod[$first]['discount_amount' . $first] += $associated_prod[$key]['discount_amount' . $key];
                    unset($associated_prod[$key]);
                }
            }
        }
    }

    // merge products - end
    unset($Pick, $row, $res, $category_association);
    return $associated_prod;
}
