<?php

/* +**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ********************************************************************************** */

class Mosaico_getTemplateFieldsAjax_View extends Vtiger_Basic_View {

    function __construct() {
        parent::__construct();
        $this->exposeMethod('getEmailTemplateModuleFields');
    }

    function checkPermission() {

    }

    function preProcess(Vtiger_Request $request) {
        return true;
    }

    function postProcess(Vtiger_Request $request) {
        return true;
    }

    function process(Vtiger_Request $request) {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
        }
        $this->invokeExposedMethod('getEmailTemplateModuleFields', $request);
        return;
    }

    public function getEmailTemplateModuleFields(Vtiger_Request $request) {
        $recordModel = new EmailTemplates_Record_Model();
        $recordModel->setModule('EmailTemplates');
        $allFiledsOptions = $recordModel->getEmailTemplateFields();
        $modules[] = array('text' => vtranslate('None'), 'value' => '');
        $fields = array();
        foreach ($allFiledsOptions as $moduleName => $fieldArray) {
            $modules[] = array('text' => $moduleName, 'value' => $moduleName);
            $fields[$moduleName][] = array('text' => vtranslate('None'), 'value' => '');
            foreach ($fieldArray as $key => $valueArray) {
                $fieldParts = explode(':', $valueArray[0]);
                $fields[$moduleName][] = array('text' => $fieldParts[1], 'value' => $valueArray[1]);
            }
        }
        $result = array(
            'RelModulesFields' => $fields,
            'RelModules' => $modules
        );
        $response = new Vtiger_Response();
        $response->setResult($result);
        $response->emit();
    }

}
