<?php

vimport('~~/vtlib/Vtiger/Module.php');

class Mosaico_Template_Model extends Vtiger_Module_Model {

    public static function downloadTemplate($request) {
        global $root_directory;
        global $site_URL;
        global $adb;
        $hashKey = $request->get('hash');
        $html = $request->get('html');
        $path = $root_directory . 'modules/Mosaico/storage/';
        $file = $path . $hashKey . '.html';
        $fileName = $hashKey . '.html';
        $downloadFile = $site_URL . 'modules/Mosaico/storage/' . $fileName;
        $adb->pquery("UPDATE vtiger_mosaico SET templateurl = ?, havetemplate = 1  WHERE templateid = ?", array($downloadFile, $hashKey));
        file_put_contents($file, utf8_encode($html));
        header("Content-Type: application/force-download");
        header("Content-Disposition: attachment; filename=\"" . $fileName . "\"");
        header("Content-Length: " . strlen($html));
        echo $html;
        exit;
    }

    public static function saveTemplate($request) {
        global $adb;
        global $root_directory;
        global $site_URL;
//        $test = trim($request->get('json'),'"');
//        echo $request->get('html');var_dump(json_decode($_POST['json']));exit;
        $hashKey = $request->get('hash');
        $metadata = trim($_POST['metadata'],'"');
        $json = trim($_POST['jsonText'],'"');
        $html = trim($_POST['html'],'"');
        $path = $root_directory . 'modules/Mosaico/storage/';
        $file = $path . $hashKey . '.html';
        $fileName = $hashKey . '.html';
        $downloadFile = $site_URL . 'modules/Mosaico/storage/' . $fileName;
        //file_put_contents($file, utf8_encode($html));
		file_put_contents($file, $html);
        $success = $adb->pquery("UPDATE vtiger_mosaico SET meta = ?, json = ?, templateurl = ?, havetemplate = 1 WHERE templateid = ?", array($metadata, $json, $downloadFile, $hashKey));

        if ($success) {
            return true;
        }

        return false;
    }

    public static function getTemplate($request) {
        $hashKey = $request->get('hash');

        if ($hashKey) {
            global $adb;
            $strd = $adb->pquery("SELECT templateid,meta,json FROM vtiger_mosaico WHERE templateid = ? LIMIT 1", array($hashKey));
            $nr = $adb->num_rows($strd);
            if ($nr) {
                $data = $strd->fields;
                $metadata = $data['meta'];
                $json = $data['json'];
                if(is_null($json)){
                    return false;
                }
                $recordModel = array("hash" => $hashKey, "metadata" => $metadata, "json" => $json);
                return $recordModel;
            }
        }
        return false;
    }

    public static function imageHandler($request) {
        $params = $request->get('params');
        $params = explode(",", $params);
        $width = (int) $params[0];
        $height = (int) $params[1];
        $method = $request->get('method');
        if ($method == "placeholder") {
            $image = new Imagick();
            $image->newImage($width, $height, "#707070");
            $image->setImageFormat("png");
            $x = 0;
            $y = 0;
            $size = 40;
            $draw = new ImagickDraw();

            while ($y < $height) {
                $draw->setFillColor("#808080");
                $points = array(
                    array("x" => $x, "y" => $y),
                    array("x" => $x + $size, "y" => $y),
                    array("x" => $x + $size * 2, "y" => $y + $size),
                    array("x" => $x + $size * 2, "y" => $y + $size * 2)
                );

                $draw->polygon($points);

                $points = array(
                    array("x" => $x, "y" => $y + $size),
                    array("x" => $x + $size, "y" => $y + $size * 2),
                    array("x" => $x, "y" => $y + $size * 2)
                );

                $draw->polygon($points);

                $x += $size * 2;

                if ($x > $width) {
                    $x = 0;
                    $y += $size * 2;
                }
            }
            $draw->setFillColor("#B0B0B0");
            $draw->setFontSize($width / 5);
            $draw->setFontWeight(800);
            $draw->setGravity(Imagick::GRAVITY_CENTER);
            $draw->annotation(0, 0, $width . " x " . $height);

            $image->drawImage($draw);

            header("Content-type: image/png");

            echo $image;
        } else {
            $file_name = $request->get('src');
            $path_parts = pathinfo($file_name);

            switch ($path_parts["extension"]) {
                case "png":
                    $mime_type = "image/png";
                    break;

                case "gif":
                    $mime_type = "image/gif";
                    break;

                default:
                    $mime_type = "image/jpeg";
                    break;
            }

            $file_name = $path_parts["basename"];
            $fullPath = $path_parts['dirname'] . '/' . $path_parts['basename'];
            // $image = Mosaico_Template_Model::ResizeImage($fullPath, $method, $width, $height);
            header("Content-type: " . $mime_type);
            echo $image;
        }
    }

    public static function fileUpload($request) {
        global $root_directory;
        global $site_URL;
        $files = array();
        foreach ($_FILES["files"]["error"] as $key => $error) {
            if ($error == UPLOAD_ERR_OK) {
                $tmp_name = $_FILES["files"]["tmp_name"][$key];
                $file_name = $_FILES["files"]["name"][$key];
                $file_name = str_replace(" ", "_", $file_name);
                $file_name = time().'_'.$request->get('record').'_'.$file_name;
                $file_path = $root_directory . 'modules/Mosaico/storage/uploads/' . $file_name;
                if (move_uploaded_file($tmp_name, $file_path) === TRUE) {
                    $size = filesize($file_path);
                    if (!extension_loaded('imagick')) {
                        if (!dl('imagick.so')) {
                            $file = array(
                                "error" => 'Please Install "Imagick" PHP extension'
                            );
                            $files[] = $file;
                            echo json_encode(array("files" => $files));
                            exit;
                        }
                    }
                    $image = new Imagick($file_path);
                    $image->resizeImage(90, 90, Imagick::FILTER_LANCZOS, 1.0, TRUE);
                    $image->writeImage($root_directory . 'modules/Mosaico/storage/uploads/thumbnails/' . $file_name);
                    $image->destroy();

                    $file = array(
                        "name" => $file_name,
                        "url" => $site_URL . 'modules/Mosaico/storage/uploads/' . $file_name,
                        "size" => $size,
                        "thumbnailUrl" => $site_URL . 'modules/Mosaico/storage/uploads/thumbnails/' . $file_name
                    );

                    $files[] = $file;
                } else {
                    $http_return_code = 500;
                    return;
                }
            } else {
                $http_return_code = 400;
                return;
            }
        }

        echo json_encode(array("files" => $files));
        exit;
        header("Content-Type: application/json; charset=utf-8");
        header("Connection: close");

        return json_encode(array("files" => $files));
    }

    public static function ResizeImage($file_name, $method, $width, $height) {
        $image = new Imagick($file_name);
        if ($method == "resize") {
            $image->resizeImage($width, $height, Imagick::FILTER_LANCZOS, 1.0);
        } else {
            $image_geometry = $image->getImageGeometry();

            $width_ratio = $image_geometry["width"] / $width;
            $height_ratio = $image_geometry["height"] / $height;

            $resize_width = $width;
            $resize_height = $height;

            if ($width_ratio > $height_ratio) {
                $resize_width = 0;
            } else {
                $resize_height = 0;
            }

            $image->resizeImage($resize_width, $resize_height, Imagick::FILTER_LANCZOS, 1.0);

            $image_geometry = $image->getImageGeometry();

            $x = ( $image_geometry["width"] - $width ) / 2;
            $y = ( $image_geometry["height"] - $height ) / 2;

            $image->cropImage($width, $height, $x, $y);
        }

        return $image;
    }

}
