<?php

/**
 * entry point for all requests
 */
error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT);

$http_response_code = 200;

$url = parse_url( $_SERVER[ "REQUEST_URI" ] );

if ( array_key_exists( "path", $url ) ) {
	$request = substr( $url[ "path" ], strlen( dirname( $url[ "path" ] ) ) );
	$request_handlers = array("/img/" => "ProcessImgRequest");
	// echo '<pre>';var_dump($request);exit;
	if ( array_key_exists( $request, $request_handlers ) ) {
		$request_handlers[ $request ]();
	} else {
		$http_response_code = 404;
	}
} else {
	$http_response_code = 500;
}
http_response_code( $http_response_code );	// removed seran@radus28.com


/**
 * handler for img requests
 */
function ProcessImgRequest()
{
	if ( $_SERVER[ "REQUEST_METHOD" ] == "GET" ) {

		$method = $_GET[ "method" ];
// @change t45441
		if (strpos($method, 'placeholder¶ms=') === 0) {

			$_GET['params'] = str_replace("placeholder¶ms=", '', $method);
			$method = 'placeholder';
		}
//

		$params = explode( ",", $_GET[ "params" ] );
		$width = (int) $params[ 0 ];
		$height = (int) $params[ 1 ];

		if ( $method == "placeholder" ) {

			$image = new Imagick();


			$image->newImage( $width, $height, "#707070" );
			$image->setImageFormat( "png" );
			$x = 0;
			$y = 0;
			$size = 40;

			$draw = new ImagickDraw();

// file_put_contents('jho.txt', date('Y-m-d H:i:s') . ' ' . __LINE__.' '.var_export($draw, true)."\n", FILE_APPEND);

			while ( $y < $height ) {
				$draw->setFillColor( "#808080" );
				$points = array(
					array( "x" => $x, "y" => $y ),
					array( "x" => $x + $size, "y" => $y ),
					array( "x" => $x + $size * 2, "y" => $y + $size ),
					array( "x" => $x + $size * 2, "y" => $y + $size * 2 )
				);

				$draw->polygon( $points );

				$points = array(
					array( "x" => $x, "y" => $y + $size ),
					array( "x" => $x + $size, "y" => $y + $size * 2 ),
					array( "x" => $x, "y" => $y + $size * 2 )
				);

				$draw->polygon( $points );
				$x += $size * 2;

				if ( $x > $width ) {
					$x = 0;
					$y += $size * 2;
				}
			}

			$draw->setFillColor( "#B0B0B0" );
			$draw->setFontSize( $width / 5 );
			$draw->setFontWeight( 800 );
			$draw->setGravity( Imagick::GRAVITY_CENTER );
			//$draw->annotation( 0, 0, $width . " x " . $height );
			$image->drawImage( $draw );

			header( "Content-type: image/png" );

			echo $image;
		} else {
			$file_name = $_GET[ "src" ];
			$path_parts = pathinfo( $file_name );
			switch ( $path_parts[ "extension" ] )
			{
				case "png":
					$mime_type = "image/png";
					break;

				case "gif":
					$mime_type = "image/gif";
					break;

				default:
					$mime_type = "image/jpeg";
					break;
			}

			$file_name = $path_parts[ "basename" ];
			$fullPath = $path_parts['dirname'] . '/' . $path_parts['basename'];
			$image = ResizeImage( $fullPath, $method, $width, $height );
			header( "Content-type: " . $mime_type );
			echo $image;
		}
	}
}

/**
 * function to resize images using resize or cover methods
 */
function ResizeImage( $file_name, $method, $width, $height )
{
	$file_name = $_SERVER["DOCUMENT_ROOT"] . str_replace($_SERVER["REQUEST_SCHEME"] . '://' . $_SERVER["HTTP_HOST"], '', $file_name);
// file_put_contents('jho.txt', date('Y-m-d H:i:s') . ' ' . __LINE__.' '.var_export($file_name, true)."\n", FILE_APPEND);
// file_put_contents('jho.txt', date('Y-m-d H:i:s') . ' ' . __LINE__.' '.var_export($_SERVER, true)."\n", FILE_APPEND);
// file_put_contents('jho.txt', date('Y-m-d H:i:s') . ' ' . __LINE__.' '.var_export($file_name, true)."\n", FILE_APPEND);
	$image = new Imagick( $file_name );
	if ( $method == "resize" ) {
		$image->resizeImage( $width, $height, Imagick::FILTER_LANCZOS, 1.0 );
	} else {
		$image_geometry = $image->getImageGeometry();
		$width_ratio = $image_geometry[ "width" ] / $width;
		$height_ratio = $image_geometry[ "height" ] / $height;
		$resize_width = $width;
		$resize_height = $height;

		if ( $width_ratio > $height_ratio ) {
			$resize_width = 0;
		} else {
			$resize_height = 0;
		}

		$image->resizeImage( $resize_width, $resize_height, Imagick::FILTER_LANCZOS, 1.0 );

		$image_geometry = $image->getImageGeometry();

		$x = ( $image_geometry[ "width" ] - $width ) / 2;
		$y = ( $image_geometry[ "height" ] - $height ) / 2;

		$image->cropImage( $width, $height, $x, $y );
	}
	
	return $image;
}
