/**
 * plugin.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2015 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/*global tinymce:true */

tinymce.PluginManager.add('fields', function (editor) {
    function createFieldsList(callback) {
        return function () {
            var linkList = editor.settings.link_list;
            if (typeof linkList == "string") {
                tinymce.util.XHR.send({
                    url: linkList,
                    success: function (text) {
                        callback(tinymce.util.JSON.parse(text));
                    }
                });
            } else if (typeof linkList == "function") {
                linkList(callback);
            } else {
                callback(linkList);
            }
        };
    }

    function buildListItems(inputList, itemCallback, startItems) {
        function appendItems(values, output) {
            output = output || [];

            tinymce.each(values, function (item) {
                var menuItem = {text: item.text || item.title};

                if (item.menu) {
                    menuItem.menu = appendItems(item.menu);
                } else {
                    menuItem.value = item.value;

                    if (itemCallback) {
                        itemCallback(menuItem);
                    }
                }

                output.push(menuItem);
            });

            return output;
        }

        return appendItems(inputList, startItems || []);
    }

    function showDialog() {
        var data = {};
        var win, targetListCtrl, targetModuleCtrl;


        function targetModuleChange(e) {
            data.targetModule = this.value();
            var value = [{text: 'None', value: ''}];
            if (data.targetModule != '') {
                var valueArray = JSON.parse(localStorage.getItem('RelModulesFields'));
                value = valueArray[data.targetModule];
            }
            moduleFieldsEvent.state.set('menu', value);
        }

        function targetModuleFieldChange(e) {
            data.targetFieldValue = this.value();
        }

        if (editor.settings.target_list !== false) {
            if (!editor.settings.target_list) {
                editor.settings.target_list = [
                    {text: 'None', value: ''}
                ];
            }

            targetListCtrl = {
                name: 'moduleFields',
                type: 'listbox',
                label: 'Field Name',
                values: buildListItems(editor.settings.target_list),
                style: {width: 400},
                onselect: targetModuleFieldChange,
                onPostRender: function () {
                    moduleFieldsEvent = this;
                }
            };
        }

        if (editor.settings.target_module !== false) {
            if (!editor.settings.target_module) {
                editor.settings.target_module = JSON.parse(localStorage.getItem('RelModules'));
            }

            targetModuleCtrl = {
                name: 'targetModule',
                type: 'listbox',
                label: 'Module Name',
                autofocus: true,
                values: buildListItems(editor.settings.target_module),
                content_css: [{width: 400}],
                onselect: targetModuleChange,
                onPostRender: function () {
                    targetModuleEvent = this;
                }

            };
        }

        win = editor.windowManager.open({
            title: 'Insert Fields',
            data: data,
            width: 400,
            height: 100,
            body: [
                targetModuleCtrl,
                targetListCtrl
            ],
            onSubmit: function (e) {
                editor.insertContent(data.targetFieldValue);
            }
        });
    }

    editor.addButton('fields', {
        icon: 'keyboard',
        tooltip: 'Insert Fields',
        shortcut: 'Meta+K',
        onclick: createFieldsList(showDialog),
        stateSelector: 'a[href]'
    });

    editor.addShortcut('Meta+K', '', createFieldsList(showDialog));
    editor.addCommand('mceFields', createFieldsList(showDialog));

    this.showDialog = showDialog;

    editor.addMenuItem('fields', {
        icon: 'keyboard',
        text: 'Insert Fields',
        shortcut: 'Meta+K',
        onclick: createFieldsList(showDialog),
        stateSelector: 'a[href]',
        context: 'insert',
        prependToContext: true
    });
});
