<?php

class Mosaico_Template_Action extends Vtiger_Action_Controller {

    function __construct() {
        parent::__construct();
        $this->exposeMethod('downloadTemplate');
        $this->exposeMethod('saveTemplate');
        $this->exposeMethod('getTemplate');
        $this->exposeMethod('fileUpload');
        $this->exposeMethod('imageHandler');
    }

    public function checkPermission(Vtiger_Request $request) {
        $moduleName = $request->getModule();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);

        $userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
        $permission = $userPrivilegesModel->hasModulePermission($moduleModel->getId());

        if (!$permission) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
    }

    public function process(Vtiger_Request $request) {
      $mode = $request->getMode();
      if (!empty($mode) && $this->isMethodExposed($mode)) {
          $this->invokeExposedMethod($mode, $request);
          return;
      }
    }

    function downloadTemplate(Vtiger_Request $request) {
        $recordModels = Mosaico_Template_Model::downloadTemplate($request);
        $response = new Vtiger_Response();
        $response->setResult($recordModels);
        $response->emit();
    }       

    function saveTemplate(Vtiger_Request $request) {
        $recordModels = Mosaico_Template_Model::saveTemplate($request);
        $response = new Vtiger_Response();
        $response->setResult($recordModels);
        $response->emit();
    }       

    function getTemplate(Vtiger_Request $request) {
        $recordModels = Mosaico_Template_Model::getTemplate($request);
        $response = new Vtiger_Response();
        $response->setResult($recordModels);
        $response->emit();
    }     

    function fileUpload(Vtiger_Request $request) {
        $recordModels = Mosaico_Template_Model::fileUpload($request);
        $response = new Vtiger_Response();
        $response->setResult($recordModels);
        $response->emit();
    }    

    function imageHandler(Vtiger_Request $request) {
        $recordModels = Mosaico_Template_Model::imageHandler($request);
        $response = new Vtiger_Response();
        $response->setResult($recordModels);
        $response->emit();
    }
}
