<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * *******************************************************************************/

require_once 'modules/com_vtiger_workflow/include.inc';
require_once 'modules/com_vtiger_workflow/expression_engine/VTExpressionsManager.inc';

class ListViewColors_Record_Model extends Vtiger_Record_Model {

    public function getId() {
        return $this->get('listviewcolorid');
    }

    public function getName() {
        return $this->get('description');
    }

    public function get($key) {
            return parent::get($key);
    }

   
    public function getModule() {
            return $this->module;
    }

    public function setModule($moduleName) {
            $this->module = Vtiger_Module_Model::getInstance($moduleName);
            return $this;
    }

    public static function getInstance($listviewcolorid) {

        $adb = PearDatabase::getInstance();

        $sql = "SELECT * FROM its4you_listviewcolors WHERE listviewcolorid = ?";
        $result = $adb->pquery($sql, array($listviewcolorid));

        if($adb->num_rows($result)){
            $data = $adb->raw_query_result_rowdata($result, 0);
            return self::getInstanceObject($data);
        }else{
            return null;
        }
    }

    public static function getInstanceObject($data) {
        $ListViewColorsModel = new self();

        $ListViewColorsModel->set('color', $data["color"]);
        $ListViewColorsModel->set('description', $data["description"]);
        $ListViewColorsModel->set('conditions', Zend_Json::decode($data["lvc_conditions"]));
        $ListViewColorsModel->set('module_name', $data["module_name"]);
        $ListViewColorsModel->set('listviewcolorid', $data["listviewcolorid"]);
        $ListViewColorsModel->setModule($data["module_name"]);
        return $ListViewColorsModel;
    }
}