<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * *******************************************************************************/

class ListViewColors_Module_Model extends Vtiger_Module_Model {
    
    private $version_type;
    private $license_key;
    private $version_no;
    
    function __construct() {
        $this->log = LoggerManager::getLogger('account');
        $this->db = PearDatabase::getInstance();

        $this->setLicenseInfo();
        
        $this->name = "ListViewColors";
        $this->id = getTabId("ListViewColors");
    }
    
    private function setLicenseInfo() {

        $this->version_no = ListViewColors_Version_Helper::$version;

        $sql = "SELECT version_type, license_key FROM its4you_listviewcolors_license";
        $result = $this->db->query($sql);
        if ($this->db->num_rows($result) > 0) {
            $this->version_type = $this->db->query_result($result, 0, "version_type");
            $this->license_key = $this->db->query_result($result, 0, "license_key");
        } else {
            $this->version_type = "";
            $this->license_key = "";
        }
    }
    
    //Getters and Setters
    public function GetVersionType() {
        return $this->version_type;
    }

    public function GetLicenseKey() {
        return $this->license_key;
    }
    
    static public function convertDateTimeValue($fieldValue,$value,$condition) {
        
        $current_user = Users_Record_Model::getCurrentUserModel();
        
        list($cdate, $time) = explode(' ', $fieldValue,2);
        $fieldDateValue = $fieldValue = DateTimeField::convertToDBFormat($cdate);
        if ($time != ""){
            if($current_user->hour_format == '12'){
                $time = date("H:i:s", strtotime($time));
            }
            $fieldValue = $fieldValue." ".$time;
        }

        //Convert the DB Date Time Format to User Date Time Format
        $valueArray = explode(' ', $value);
        if(count($valueArray) == 1 && $condition != "less than hours before" && $condition != "less than hours later" && $condition != "more than hours before" && $condition != "more than hours later") {
            $fieldValue = $fieldDateValue;
        }
        
        return $fieldValue;
    }
}
