<?php

/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * *******************************************************************************/

class ListViewColors_ListView_Model extends Vtiger_ListView_Model {

    public static function getInstance($moduleName, $viewId='0', $New_Fields) {
        $db = PearDatabase::getInstance();
        $currentUser = vglobal('current_user');

        $modelClassName = Vtiger_Loader::getComponentClassName('Model', 'ListView', $moduleName);
        $instance = new $modelClassName();
        $moduleModel = Vtiger_Module_Model::getInstance($moduleName);
        $queryGenerator = new QueryGenerator($moduleModel->get('name'), $currentUser);
        $customView = new CustomView();
        if (!empty($viewId) && $viewId != "0") {
                $queryGenerator->initForCustomViewById($viewId);

                //Used to set the viewid into the session which will be used to load the same filter when you refresh the page
                $viewId = $customView->getViewId($moduleName);
        } else {
                $viewId = $customView->getViewId($moduleName);
                if(!empty($viewId) && $viewId != 0) {
                        $queryGenerator->initForDefaultCustomView();
                } else {
                        $entityInstance = CRMEntity::getInstance($moduleName);
                        $listFields = $entityInstance->list_fields_name;
                        $listFields[] = 'id';
                        $queryGenerator->setFields($listFields);
                }
        }
        $controller = new ListViewController($db, $currentUser, $queryGenerator);

        if (count($New_Fields) > 0) {
            $Fields = $queryGenerator->getFields();
            
            foreach ($New_Fields AS $add_fieldname) {
                if (!in_array($add_fieldname,$Fields)) $Fields[] = $add_fieldname; 
            }    
            //$Fields = array_merge($OldFields, $Fields);
            $queryGenerator->setFields($Fields);
        }
        
        return $instance->set('module', $moduleModel)->set('query_generator', $queryGenerator)->set('listview_controller', $controller);
    }
}