/*********************************************************************************
 * The content of this file is subject to the ListView Colors 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/
    
jQuery.Class("ListViewColors_List_Js",{},{
    
    getInstance : function(urlParams) {

        this.setColors();
          
        var Vtiger_List_Js_Old = jQuery.extend(true, {}, Vtiger_List_Js);  
          
        Vtiger_List_Js.prototype.getListViewRecords = function (urlParams) {  
		var aDeferred = jQuery.Deferred();
		if(typeof urlParams == 'undefined') {
			urlParams = {};
		}

		var thisInstance = this;
		var loadingMessage = jQuery('.listViewLoadingMsg').text();
		var progressIndicatorElement = jQuery.progressIndicator({
			'message' : loadingMessage,
			'position' : 'html',
			'blockInfo' : {
				'enabled' : true
			}
		});


        var urlOldParams = urlParams;
    
        var defaultParams = this.getDefaultParams();
        var urlParams = jQuery.extend(defaultParams, urlParams);

        var LVCParams = {
                'module': 'ListViewColors',
                'formodule' : urlParams['module'],
                'page' : urlParams['page'],
                'action' : "IndexAjax",
                'mode' : "getColors"
        }

        var urlLVCParams = jQuery.extend(LVCParams, urlOldParams); 

		AppConnector.requestPjax(urlParams).then(
			function(data){
				progressIndicatorElement.progressIndicator({
					'mode' : 'hide'
				})
                                var listViewContentsContainer = jQuery('#listViewContents')
                                listViewContentsContainer.html(data);
                                app.showSelect2ElementView(listViewContentsContainer.find('select.select2'));
                                app.changeSelectElementView(listViewContentsContainer);
                                
                                if (typeof thisInstance.registerTimeListSearch == 'function') { 
                                    thisInstance.registerTimeListSearch(listViewContentsContainer);
                                }
                                
                                if (typeof thisInstance.registerDateListSearch == 'function') { 
                                    thisInstance.registerDateListSearch(listViewContentsContainer);
                                }

                                AppConnector.request(urlLVCParams).then(
                                    function(data){
                                        var response = data['result'];
                                        var result = response['success'];

                                        if(result == true) {
                                            if(response['numcolors'] > 0) {
                                                var Colors = response['colors'];
                                                jQuery('#listViewContents').find(".listViewEntries").each(function(key,domElement) { 
                                                    rowid = jQuery(this).data('id'); 
                                                    if (Colors[rowid]) {
                                                        var colors_val = Colors[rowid];
                                                        jQuery(domElement).css('background-color',Colors[rowid][colors_val.length-1]); 
                                                        //jQuery(this).animate({backgroundColor: color_val}, 1500);

                                                        var tempID=0;
                                                        var changeInterval=800;    // Change interval in miliseconds

                                                        setInterval(function(){
                                                            jQuery(domElement).animate({backgroundColor: colors_val[tempID]},100);
                                                             tempID=tempID+1;
                                                             if (tempID>colors_val.length-1) tempID=0;
                                                         },changeInterval);
                                                    }
                                                });
                                            }
                                        }
                                    }      
                                );
                                
				thisInstance.calculatePages().then(function(data){
					//thisInstance.triggerDisplayTypeEvent();
					Vtiger_Helper_Js.showHorizontalTopScrollBar();

					var selectedIds = thisInstance.readSelectedIds();
					if(selectedIds != ''){
						if(selectedIds == 'all'){
							jQuery('.listViewEntriesCheckBox').each( function(index,element) {
								jQuery(this).attr('checked', true).closest('tr').addClass('highlightBackgroundColor');
							});
							jQuery('#deSelectAllMsgDiv').show();
							var excludedIds = thisInstance.readExcludedIds();
							if(excludedIds != ''){
								jQuery('#listViewEntriesMainCheckBox').attr('checked',false);
								jQuery('.listViewEntriesCheckBox').each( function(index,element) {
									if(jQuery.inArray(jQuery(element).val(),excludedIds) != -1){
										jQuery(element).attr('checked', false).closest('tr').removeClass('highlightBackgroundColor');
									}
								});
							}
						} else {
							jQuery('.listViewEntriesCheckBox').each( function(index,element) {
								if(jQuery.inArray(jQuery(element).val(),selectedIds) != -1){
									jQuery(this).attr('checked', true).closest('tr').addClass('highlightBackgroundColor');
								}
							});
						}
						thisInstance.checkSelectAll();
					}
					aDeferred.resolve(data);

					// Let listeners know about page state change.
					app.notifyPostAjaxReady();
				});
			},

			function(textStatus, errorThrown){
				aDeferred.reject(textStatus, errorThrown);
			}
		);
		return aDeferred.promise();
	}  
    }, 
    setColors : function() {

        var module = app.getModuleName();
        var viewname = jQuery('#viewName').val();
        var orderBy = jQuery('#orderBy').val();
        var sortOrder = jQuery("#sortOrder").val();
        var pageNumber = jQuery('#pageNumber').val();
        
        var urlParams = {
            "viewname": viewname,
            "orderby": orderBy,
            "sortorder": sortOrder,
            'page' : pageNumber
        }
        
        var LVCParams = {
            "module": "ListViewColors",
            "formodule" : module,
            "action" : "IndexAjax",
            "mode" : "getColors"            
        }
        var urlLVCParams = jQuery.extend(LVCParams, urlParams); 
        
        AppConnector.request(urlLVCParams).then(
            function(data){
                var response = data['result'];
                var result = response['success'];

                if(result == true) {
                    if(response['numcolors'] > 0) {
                        var Colors = response['colors'];
                        jQuery('#listViewContents').find(".listViewEntries").each(function(key,domElement) { 

                            rowid = jQuery(this).data('id'); 
                            if (Colors[rowid]) {
                                var colors_val = Colors[rowid];
                                jQuery(domElement).css('background-color',Colors[rowid][colors_val.length-1]); 

                                var tempID=0;
                                var changeInterval=800;    // Change interval in miliseconds

                                setInterval(function(){
                                    jQuery(domElement).animate({backgroundColor: colors_val[tempID]},100);
                                     tempID=tempID+1;
                                     if (tempID>colors_val.length-1) tempID=0;
                                 },changeInterval);
                            }
                        });
                    } 
                }
            }      
        );
    }
});

jQuery(document).ready(function() {
    if (typeof(Vtiger_List_Js) != 'undefined') {
        var emailMassEditInstance = new ListViewColors_List_Js();
        emailMassEditInstance.getInstance();
    }
});   