<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class Leads_Detail_View extends Accounts_Detail_View {

protected $record = false;
	protected $isAjaxEnabled = null;

	function __construct() {
		parent::__construct();
		$this->exposeMethod('showJourney');
	}

	/**
		 * Added to support Engagements view in Vtiger7
		 * @param Vtiger_Request $request
		 */
		function _showRecentActivities(Vtiger_Request $request){
			$parentRecordId = $request->get('record');
			$pageNumber = $request->get('page');
			$limit = $request->get('limit');
			$moduleName = $request->getModule();

			if(empty($pageNumber)) {
				$pageNumber = 1;
			}

			$pagingModel = new Vtiger_Paging_Model();
			$pagingModel->set('page', $pageNumber);
			if(!empty($limit)) {
				$pagingModel->set('limit', $limit);
			}

			$recentActivities = ModTracker_Record_Model::getUpdates($parentRecordId, $pagingModel,$moduleName);
// var_dump($recentActivities);
			$pagingModel->calculatePageRange($recentActivities);

			if($pagingModel->getCurrentPage() == ModTracker_Record_Model::getTotalRecordCount($parentRecordId)/$pagingModel->getPageLimit()) {
				$pagingModel->set('nextPageExists', false);
			}
			$recordModel = Vtiger_Record_Model::getInstanceById($parentRecordId);
			$viewer = $this->getViewer($request);
			$viewer->assign('SOURCE',$recordModel->get('source'));
			$viewer->assign('RECENT_ACTIVITIES', $recentActivities);
			$viewer->assign('MODULE_NAME', $moduleName);
			$viewer->assign('PAGING_MODEL', $pagingModel);
			$viewer->assign('RECORD_ID',$parentRecordId);
		}

		/**
		 * Function returns recent changes made on the record
		 * @param Vtiger_Request $request
		 */
		function showJourney (Vtiger_Request $request){
			$moduleName = $request->getModule();
			$this->_showRecentActivities($request);

			$viewer = $this->getViewer($request);
			echo $viewer->view('RecentJourney.tpl', $moduleName, true);
	}

}
