<?php
/* ***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ************************************************************************************/

// @change t49474
if (class_exists('LeadHandler')) return;
//

require_once('include/Webservices/Utils.php');
require_once('include/Webservices/ConvertLead.php');

class LeadHandler extends VTEventHandler {

  function handleEvent($eventName, $entityData) {

    if ($eventName === 'vtiger.lead.convertlead') {

      $this->relateConvertedDataIds($entityData);
      $this->storeConvertedDataIds($entityData);
      $this->convertRelatedBlock($entityData);
    }

    return;
  }

  private function getConvertedId($entityData, $setype) {

    list($objectTypeId, $entityId) = explode('x', $entityData->entityIds[$setype]);
    return (int)$entityId;
  }

  /*
   * relate relatedTabs to Account and Contact both
   * note, all relatedTabs records to both...
   * - or only WebVisits and/or VebWebForms?
   *
   */
  private function relateConvertedDataIds($entityData) {

    // via convert proces, related records linked to:
    $transferRelatedRecordsTo = $entityData->transferRelatedRecordsTo;

    if (empty($transferRelatedRecordsTo)) return;

    $relateAlsoTo = null;

    if ($transferRelatedRecordsTo == 'Accounts') $relateAlsoTo = 'Contacts';
    if ($transferRelatedRecordsTo == 'Contacts') $relateAlsoTo = 'Accounts';

    if (empty($relateAlsoTo)) return;

    $leadId = $entityData->getId();

    $entityId = $this->getConvertedId($entityData, $relateAlsoTo);

    if ($entityId == 0) return;

    vtws_transferLeadRelatedRecords($leadId, $entityId, $relateAlsoTo);
  }

  // @change t30451
  private function storeConvertedDataIds($entityData) {

    if (!Vtiger_Utils::CheckTable('vtiger_wv_converted')) return;

    $adb = PearDatabase::getInstance();

    $leadId = $entityData->getId();

    $accountId = $this->getConvertedId($entityData, 'Accounts');
    $contactId = $this->getConvertedId($entityData, 'Contacts');
    $potentialId = $this->getConvertedId($entityData, 'Potentials');

    date_default_timezone_set('Netherlands/Amsterdam');
    $current_date = date('Y-m-d H:i:s');

    $is_converted = "INSERT INTO `vtiger_wv_converted` (`lead_id`, `account_id`, `contact_id`, `potential_id`, `timestamp`, `wva_converted`)
                     VALUES ('$leadId', '$accountId', '$contactId', '$potentialId', '$current_date', '1');";

    $result = $adb->pquery($is_converted, array());
  }

  private function getRelatedId($currentTabId, $relatedTabId) {

    $adb = PearDatabase::getInstance();

    $query = "SELECT relation_id FROM vtiger_relatedlists WHERE tabid = ? AND related_tabid = ?";
    $result = $adb->pquery($query, array($currentTabId, $relatedTabId));
    return $adb->query_result($result, $i, 'relation_id');
  }

  /*
   * Convert Block information for Relaties on VebWebforms and WebVisits
   *
   */
  private function convertRelatedBlock($entityData) {

    $allowedModules = array('VebWebforms', 'WebVisits');

    foreach($allowedModules as $allowedModule) {

      if (!vtlib_isModuleActive($allowedModule)) continue;

      $functionToCall = 'convert' . $allowedModule;

      $this->$functionToCall($entityData);
    }
  }

  private function convertVebWebforms($entityData) {

    $adb = PearDatabase::getInstance();

    $leadId = $entityData->getId();
    $assignedUserId = $entityData->get('assigned_user_id');

    // get the account/contact id the lead is converted to
    $accountId = $this->getConvertedId($entityData, 'Accounts');
    $contactId = $this->getConvertedId($entityData, 'Contacts');

    $currentTabId = getTabId('Leads');
    $relatedTabId = getTabId('VebWebforms');
    $relatedId = $this->getRelatedId($currentTabId, $relatedTabId);

    $focus = CRMEntity::getInstance('Leads');
    $relatedInfo = $focus->get_dependents_list($leadId, $currentTabId, $relatedTabId, $relatedId);

    $result = $adb->pquery($relatedInfo['query'], array());
    $noRows = $adb->num_rows($result);

    for($i=0;$i<$noRows;$i++) {

      $webformId = $adb->query_result($result, $i, 'webformid');

      $focus = CRMEntity::getInstance('VebWebforms');
      $focus->mode = 'edit';
      $focus->id = $webformId;

      $focus->retrieve_entity_info($webformId, 'VebWebforms');

      if ((int)$accountId > 0) {

        $focus->column_fields->offsetSet('leadid', 0);
        $focus->column_fields->offsetSet('accountid', $accountId);
      }

      if ((int)$contactId > 0) {

        $focus->column_fields->offsetSet('leadid', 0);
        $focus->column_fields->offsetSet('contactid', $contactId);
      }

      $focus->column_fields->offsetSet('assigned_user_id', $assignedUserId);

      // no workflows
      $focus->saveentity('VebWebforms');
    }
  }

  private function convertWebVisits($entityData) {

    $adb = PearDatabase::getInstance();

    $leadId = $entityData->getId();
    $assignedUserId = $entityData->get('assigned_user_id');

    // get the account/contact id the lead is converted to
    $accountId = $this->getConvertedId($entityData, 'Accounts');
    $contactId = $this->getConvertedId($entityData, 'Contacts');

    $currentTabId = getTabId('Leads');
    $relatedTabId = getTabId('WebVisits');
    $relatedId = $this->getRelatedId($currentTabId, $relatedTabId);

    $focus = CRMEntity::getInstance('Leads');
    $relatedInfo = $focus->get_dependents_list($leadId, $currentTabId, $relatedTabId, $relatedId);

    $result = $adb->pquery($relatedInfo['query'], array());
    $noRows = $adb->num_rows($result);

    for($i=0;$i<$noRows;$i++) {

      $webvisitId = $adb->query_result($result, $i, 'webvisitsid');

      $focus = CRMEntity::getInstance('WebVisits');
      $focus->mode = 'edit';
      $focus->id = $webvisitId;

      $focus->retrieve_entity_info($webvisitId, 'WebVisits');

      if ((int)$accountId > 0) {

        $focus->column_fields->offsetSet('leadid', 0);
        $focus->column_fields->offsetSet('accountid', $accountId);
      }

      if ((int)$contactId > 0) {

        $focus->column_fields->offsetSet('leadid', 0);
        $focus->column_fields->offsetSet('contactid', $contactId);
      }

      $focus->column_fields->offsetSet('assigned_user_id', $assignedUserId);

      // no workflows
      $focus->saveentity('WebVisits');
    }
  }

  private function log($msg) {

    // return;
    error_log('LeadsConvertHandler - ' . $msg, 0);
  }
}
