<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class Leads_Save_Action extends Vtiger_Save_Action {

	public function process(Vtiger_Request $request) {

		//To stop saveing the value of salutation as '--None--'
		$salutationType = $request->get('salutationtype');
		if ($salutationType === '--None--') {
			$request->set('salutationtype', '');
		}
		//TECHNOKRAFTS START: save the value of datetime field
		if(($request->get('wv_timefirstvisit')!='' && $request->get('wv_datefirstvisit')!='') || ($request->get('wv_timelastvisit')!='' && $request->get('wv_lastvisitdate')!='')) 
		{
			$startTime = Vtiger_Time_UIType::getTimeValueWithSeconds($request->get('wv_timefirstvisit'));
			$startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($request->get('wv_datefirstvisit')." ".$startTime);
			list($startDate, $startTime) = explode(' ', $startDateTime);
			$request->set('wv_datefirstvisit', $startDateTime);
			$request->set('wv_timefirstvisit', $startTime);
			
			$endTime = Vtiger_Time_UIType::getTimeValueWithSeconds($request->get('wv_timelastvisit'));
			//$endDateTime = $request->get('enddate')." ".$endTime;
			$endDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($request->get('wv_lastvisitdate')." ".$endTime);
			list($endDate, $endTime) = explode(' ', $endDateTime);
			$request->set('wv_lastvisitdate', $endDateTime);
			$request->set('wv_timelastvisit', $endTime);
		}
		//TECHNOKRAFTS END: save the value of datetime field
		parent::process($request);
	}
}
