<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class Installations extends Vtiger_CRMEntity {
	var $table_name = 'vtiger_installations';
	var $table_index= 'installationsid';

	//@chang akr t29966
	var $related_tables = array('vtiger_installationscf'=>array('installationsid'));

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_installationscf', 'installationsid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_installations', 'vtiger_installationscf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_installations' => 'installationsid',
		'vtiger_installationscf'=>'installationsid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		'LBL_MODULES' => array('installations', 'modules'),
		'LBL_URL1' => array('installations', 'url1'),
		'LBL_ORGANISATION' => array('installations', 'organisation'),
		'LBL_AGENT_CALL_STATUS_HANDLED' => array('installations', 'agent_call_status_handled'),
		'LBL_SERVER' => array('installations', 'server'),
		'LBL_PATCHES' => array('installations', 'patches'),
		'LBL_URL2' => array('installations', 'url2'),
		'LBL_USERS_OVERRUN_HANDLED' => array('installations', 'users_overrun_handled'),
		'LBL_AGENT_CALL_STATUS' => array('installations', 'agent_call_status'),
		'LBL_AGENT_LAST_UPDATE' => array('installations', 'agent_last_update'),
		'LBL_HANDLED_REMARKS' => array('installations', 'handled_remarks'),
		'LBL_USERS_IN_CONTRACT' => array('installations', 'users_in_contract'),
		'LBL_AGENT_CALL_OUTPUT' => array('installations', 'agent_call_output'),
		'LBL_URL3' => array('installations', 'url3'),
		'LBL_CUSTOMER_SPACE' => array('installations', 'customer_space'),
		'LBL_USERS_IN_USE' => array('installations', 'users_in_use'),
		'LBL_USER' => array('installations', 'user'),
		'LBL_INSTALLATIONNO' => array('installations', 'installationno'),
		'LBL_OTHER_URLS' => array('installations', 'other_urls'),
		'LBL_DESCRIPTION' => array('installations', 'description'),
		'LBL_KEY' => array('installations', 'key'),
		'LBL_USERS_OVERRUN' => array('installations', 'users_overrun'),
		'LBL_SYSTEM' => array('installations', 'system'),
		'LBL_VERSION' => array('installations', 'version'),
		'LBL_CRONJOBS_NO_FINISH' => array('installations', 'cronjobs_no_finish'),
		'LBL_INSTALLATION_STATUS' => array('installations', 'installation_status'),
		'LBL_HANDLED_DATE' => array('installations', 'handled_date'),

	);
	var $list_fields_name = Array (
		'LBL_MODULES' => 'modules',
		'LBL_URL1' => 'url1',
		'LBL_ORGANISATION' => 'organisation',
		'LBL_AGENT_CALL_STATUS_HANDLED' => 'agent_call_status_handled',
		'LBL_SERVER' => 'server',
		'LBL_PATCHES' => 'patches',
		'LBL_URL2' => 'url2',
		'LBL_USERS_OVERRUN_HANDLED' => 'users_overrun_handled',
		'LBL_AGENT_CALL_STATUS' => 'agent_call_status',
		'LBL_AGENT_LAST_UPDATE' => 'agent_last_update',
		'LBL_HANDLED_REMARKS' => 'handled_remarks',
		'LBL_USERS_IN_CONTRACT' => 'users_in_contract',
		'LBL_AGENT_CALL_OUTPUT' => 'agent_call_output',
		'LBL_URL3' => 'url3',
		'LBL_CUSTOMER_SPACE' => 'customer_space',
		'LBL_USERS_IN_USE' => 'users_in_use',
		'LBL_USER' => 'user',
		'LBL_INSTALLATIONNO' => 'installationno',
		'LBL_OTHER_URLS' => 'other_urls',
		'LBL_DESCRIPTION' => 'description',
		'LBL_KEY' => 'key',
		'LBL_USERS_OVERRUN' => 'users_overrun',
		'LBL_SYSTEM' => 'system',
		'LBL_VERSION' => 'version',
		'LBL_CRONJOBS_NO_FINISH' => 'cronjobs_no_finish',
		'LBL_INSTALLATION_STATUS' => 'installation_status',
		'LBL_HANDLED_DATE' => 'handled_date',

	);

	// Make the field link to detail view
	var $list_link_field = 'user';

	// For Popup listview and UI type support
	var $search_fields = Array(
		'LBL_OTHER_URLS' => array('installations', 'other_urls'),
		'LBL_USERS_IN_USE' => array('installations', 'users_in_use'),
		'LBL_ORGANISATION' => array('installations', 'organisation'),
		'LBL_USERS_IN_CONTRACT' => array('installations', 'users_in_contract'),

	);
	var $search_fields_name = Array (
		'LBL_OTHER_URLS' => 'other_urls',
		'LBL_USERS_IN_USE' => 'users_in_use',
		'LBL_ORGANISATION' => 'organisation',
		'LBL_USERS_IN_CONTRACT' => 'users_in_contract',

	);

	// For Popup window record selection
	var $popup_fields = Array ('user');

	// For Alphabetical search
	var $def_basicsearch_col = 'user';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'user';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('user','assigned_user_id');

	// var $default_order_by = 'user';
	var $default_order_by = 'installationsid';
	// var $default_sort_order='ASC';
	var $default_sort_order='DESC';

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
 		if($eventType == 'module.postinstall') {
			//Delete duplicates from all picklist
			static::deleteDuplicatesFromAllPickLists($moduleName);
		} else if($eventType == 'module.disabled') {
			// TODO Handle actions before this module is being uninstalled.
		} else if($eventType == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			//Delete duplicates from all picklist
			static::deleteDuplicatesFromAllPickLists($moduleName);
		}
 	}

	/**
	 * Delete doubloons from all pick list from module
	 */
	public static function deleteDuplicatesFromAllPickLists($moduleName)
	{
		global $adb,$log;

		$log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...START");

		//Deleting doubloons
		$query = "SELECT columnname FROM `vtiger_field` WHERE uitype in (15,16,33) "
				. "and tabid in (select tabid from vtiger_tab where name = '$moduleName')";
		$result = $adb->pquery($query, array());

		$a_picklists = array();
		while($row = $adb->fetchByAssoc($result))
		{
			$a_picklists[] = $row["columnname"];
		}

		foreach ($a_picklists as $picklist)
		{
			static::deleteDuplicatesFromPickList($picklist);
		}

		$log->debug("Invoking deleteDuplicatesFromAllPickList(".$moduleName.") method ...DONE");
	}

	public static function deleteDuplicatesFromPickList($pickListName)
	{
		global $adb,$log;

		$log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...START");

		//Deleting doubloons
		$query = "SELECT {$pickListName}id FROM vtiger_{$pickListName} GROUP BY {$pickListName}";
		$result = $adb->pquery($query, array());

		$a_uniqueIds = array();
		while($row = $adb->fetchByAssoc($result))
		{
			$a_uniqueIds[] = $row[$pickListName.'id'];
		}

		if(!empty($a_uniqueIds))
		{
			$query = "DELETE FROM vtiger_{$pickListName} WHERE {$pickListName}id NOT IN (".implode(",", $a_uniqueIds).")";
			$adb->pquery($query, array());
		}

		$log->debug("Invoking deleteDuplicatesFromPickList(".$pickListName.") method ...DONE");
	}
}
