<?php
/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class ITS4YouQuickSearch_Integration_Model extends Vtiger_Base_Model
{
    const IGNORED_MODULES = array('Users', 'PBXManager', 'Emails');
    const IGNORED_UI_TYPES = array(52, 53, 56, 70, 77, 98, 99, 101, 104, 105, 106, 115, 116, 117, 156, 357);
    public $module;
    public $moduleId;
    public $userId;
    public $fieldNames = array();
    /**
     * @var PearDatabase
     */
    public $db;
    public $fields = array();

    /**
     * @throws Exception
     */
    public static function getSupportedModules($hasModulePermissions = false)
    {
        $currentUserPrivilegeModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
        $adb = PearDatabase::getInstance();
        $result = $adb->pquery('SELECT vtiger_entityname.modulename 
            FROM vtiger_entityname, vtiger_tab 
            WHERE vtiger_entityname.tabid=vtiger_tab.tabid 
              AND vtiger_tab.isentitytype=1 
              AND modulename NOT IN (' . generateQuestionMarks(self::IGNORED_MODULES) . ')',
            array(self::IGNORED_MODULES)
        );
        $modules = array();

        while ($row = $adb->fetchByAssoc($result)) {
            $module = $row['modulename'];

            if($hasModulePermissions && !$currentUserPrivilegeModel->hasModulePermission(getTabid($module))) {
                continue;
            }

            if (vtlib_isModuleActive($module)) {
                $modules[$module] = self::getInstance($module);
            }
        }

        return $modules;
    }

    /**
     * @param string $module
     * @return self
     * @throws Exception
     */
    public static function getInstance($module, $userId = 0)
    {
        $self = new self();
        $self->db = PearDatabase::getInstance();
        $self->module = $module;
        $self->moduleId = getTabid($self->module);
        $self->userId = $userId;
        $self->retrieveInfo();
        $self->retrieveFields();

        return $self;
    }

    /**
     * @throws Exception
     */
    public function retrieveInfo()
    {
        $result = $this->db->pquery('SELECT * FROM its4you_quicksearch_settings WHERE gstabid=? AND user_id=?',
            array($this->getModuleId(), $this->userId)
        );
        $row = $this->db->query_result_rowdata($result);
        $this->setData($row);
    }

    public function getModuleId()
    {
        return $this->moduleId;
    }

    /**
     * @throws Exception
     */
    public function retrieveFields()
    {
        if ($this->isEmpty('searchcolumn')) {
            return;
        }

        $fields = (array)explode(',', $this->get('searchcolumn'));

        foreach ($fields as $field) {
            list($fieldName, $columnName) = explode('::', $field);

            if (!empty($columnName)) {
                $fieldName = $this->getFieldNameFromColumn($columnName);
            }

            $this->setFieldName($fieldName);
        }
    }

    /**
     * @param string $columnName
     * @return string
     * @throws Exception
     */
    public function getFieldNameFromColumn($columnName)
    {
        $result = $this->db->pquery('SELECT fieldname FROM vtiger_field WHERE columnname=? AND tabid=?',
            array($columnName, $this->getModuleId())
        );

        return $this->db->query_result($result, 0, 'fieldname');
    }

    public function setFieldName($fieldName)
    {
        $this->fieldNames[] = $fieldName;
    }

    /**
     * @throws Exception
     */
    public static function getAvailableModules()
    {
        $adb = PearDatabase::getInstance();
        $result = $adb->pquery('SELECT gstabid, searchcolumn, turn_off, user_id FROM its4you_quicksearch_settings WHERE turn_off=0');
        $availableModules = array();

        while ($row = $adb->fetchByAssoc($result)) {
            $moduleId = $row['gstabid'];
            $moduleName = getTabModuleName($moduleId);
            $integrationModel = self::getInstance($moduleName);

            if ($integrationModel->isModulePermitted() && $integrationModel->isActive()) {
                $availableModules[$moduleId] = self::getInstance($moduleName);
            }
        }

        return $availableModules;
    }

    public function isModulePermitted()
    {
        return in_array($this->moduleId, getPermittedModuleIdList());
    }

    /**
     * @return string
     */
    public function getModule()
    {
        return $this->module;
    }

    const IGNORED_TABLES = array(
        'vtiger_campaignrelstatus',
    );

    /**
     * @return array
     */
    public function getFields()
    {
        if (!empty($this->fields)) {
            return $this->fields;
        }

        $result = $this->db->pquery('SELECT fieldid FROM vtiger_field WHERE tabid=? AND presence IN(0,2) 
              AND tablename NOT IN(' . generateQuestionMarks(self::IGNORED_TABLES) . ') 
              AND uitype NOT IN (' . generateQuestionMarks(self::IGNORED_UI_TYPES) . ') ',
            array($this->getModuleId(), self::IGNORED_TABLES, self::IGNORED_UI_TYPES));

        while ($row = $this->db->fetchByAssoc($result)) {
            $fieldModel = Vtiger_Field_Model::getInstance($row['fieldid']);

            if (!$fieldModel || !$fieldModel->getPermissions() || !$fieldModel->isActiveField()) {
                continue;
            }

            $this->fields[] = $fieldModel;
        }

        return $this->fields;
    }

    public $activeFields = array();

    public function getActiveFields()
    {
        if (!empty($this->activeFields)) {
            return $this->activeFields;
        }

        foreach ($this->getFields() as $fieldModel) {
            if ($this->isActiveField($fieldModel->get('name'))) {
                $this->activeFields[] = $fieldModel;
            }
        }

        return $this->activeFields;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return !$this->isEmpty('searchcolumn') && !$this->isEmpty('gstabid') && $this->isEmpty('turn_off');
    }

    /**
     * @param string $fieldName
     * @return bool
     */
    public function isActiveField($fieldName)
    {
        return in_array($fieldName, $this->getFieldNames());
    }

    /**
     * @return bool
     */
    public function isEmptyFieldNames()
    {
        return empty($this->getFieldNames());
    }

    /**
     * @return array
     */
    public function getFieldNames()
    {
        return $this->fieldNames;
    }

    /**
     * @param array $values
     */
    public function setFieldNames($values)
    {
        $this->fieldNames = $values;
    }

    /**
     * @throws Exception
     */
    public function save()
    {
        $params = array(
            implode(',', $this->getFieldNames()),
            $this->get('turn_off'),
            $this->getModuleId(),
            $this->userId,
        );

        if (!$this->isEmpty('gstabid')) {
            $sql = 'UPDATE its4you_quicksearch_settings SET searchcolumn=?, turn_off=? WHERE gstabid=? AND user_id=?';
        } else {
            $sql = 'INSERT INTO its4you_quicksearch_settings (searchcolumn, turn_off, gstabid, user_id) VALUES (?,?,?,?)';
        }

        $this->db->pquery($sql, $params);
        $this->retrieveInfo();

        return !$this->isEmpty('gstabid');
    }
}