<?php

/* * *******************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class ITS4YouQuickSearch_SearchResult_Helper
{
    public static $moduleModel;

    /**
     * @throws Exception
     */
    public static function getMatchingRecordsForModule($searchKey, $tabId, $offset = null, $limit = null)
    {
        $currentUser = Users_Record_Model::getCurrentUserModel();
        $matchingRecords = [];
        $moduleName = getTabModuleName($tabId);
        $integrationModel = ITS4YouQuickSearch_Integration_Model::getInstance($moduleName);

        if ($integrationModel->isModulePermitted()) {
            if ($integrationModel->isActive() && !$integrationModel->isEmptyFieldNames()) {
                $fieldModels = $integrationModel->getActiveFields();
            } else {
                $moduleModel = self::getModuleModel($moduleName);
                $fieldModels = $moduleModel->getFields();
            }

            $queryGenerator = new ITS4YouQuickSearch_QueryGeneratorQS_Helper($moduleName, $currentUser);
            $queryGenerator->setSearchValue($searchKey);
            $queryGenerator->initForDefaultCustomView();

            /** @var Vtiger_Field_Model $fieldModel */
            foreach ($fieldModels as $fieldModel) {
                if (!is_object($fieldModel) || !$fieldModel->isActiveField() || !$fieldModel->getPermissions()) {
                    continue;
                }

                if (!$queryGenerator->isValidSearchValueForField($fieldModel, $searchKey)) {
                    continue;
                }

                $queryGenerator->addContainCondition($fieldModel->getName(), $searchKey);
            }

            $sql = $queryGenerator->getQuery();

            if (!is_null($offset) && !is_null($limit)) {
                $sql .= ' LIMIT ' . $limit . ' OFFSET ' . $offset;
            }

            self::retrieveRecordsFromQuery($matchingRecords, $sql);
        }

        return $matchingRecords;
    }

    public static function getModuleModel($moduleName)
    {
        if (!isset(self::$moduleModel[$moduleName])) {
            self::$moduleModel[$moduleName] = Vtiger_Module_Model::getInstance($moduleName);
        }

        return self::$moduleModel[$moduleName];
    }

    /**
     * @throws Exception
     */
    public static function retrieveRecordsFromQuery(&$records, $sql)
    {
        $adb = PearDatabase::getInstance();
        $result = $adb->pquery($sql);

        while ($row = $adb->fetchByAssoc($result)) {
            $recordId = $row['vtiger_crmentity_crmid'];
            $recordModule = $row['vtiger_crmentity_setype'];

            $row['id'] = $recordId;
            $row['crmid'] = $recordId;

            if (!isRecordExists($recordId)) {
                continue;
            }

            if (Users_Privileges_Model::isPermitted($recordModule, 'DetailView', $recordId)) {
                $row['id'] = $recordId;

                $records[$recordModule][$recordId] = self::getRecordModel($recordModule, $row);
            }
        }
    }

    /**
     * @throws Exception
     */
    public static function getRecordModel($moduleName, $data)
    {
        $moduleModel = self::getModuleModel($moduleName);
        $modelClassName = Vtiger_Loader::getComponentClassName('Model', 'Record', $moduleName);
        $recordInstance = new $modelClassName();

        return $recordInstance->setData($data)->setModuleFromInstance($moduleModel)->setRawData($data);
    }

    /**
     * @param $tabId
     *
     * @return bool
     */
    public static function isModulePermitted($tabId)
    {
        return in_array($tabId, getPermittedModuleIdList());
    }

    /**
     * @throws Exception
     */
    public static function getMatchingRecords($searchKey, $offset = null, $limit = null)
    {
        $currentUser = Users_Record_Model::getCurrentUserModel();
        $matchingRecords = [];
        $availableModules = ITS4YouQuickSearch_Integration_Model::getAvailableModules();

        foreach ($availableModules as $integrationModel) {
            $moduleName = $integrationModel->getModule();
            $fieldModels = $integrationModel->getActiveFields();

            $queryGenerator = new ITS4YouQuickSearch_QueryGeneratorQS_Helper($moduleName, $currentUser);
            $queryGenerator->setSearchValue($searchKey);

            if (!empty($fieldModels)) {
                $queryGenerator->initForCustomSearchFields($fieldModels);

                /** @var Vtiger_Field_Model $fieldModel */
                foreach ($fieldModels as $fieldModel) {
                    if (!$queryGenerator->isValidSearchValueForField($fieldModel, $searchKey)) {
                        continue;
                    }

                    $queryGenerator->addContainCondition($fieldModel->getName(), $searchKey);
                }
            }

            $sql = $queryGenerator->getQuery();

            if (!is_null($offset) && !is_null($limit)) {
                $sql .= ' LIMIT ' . $limit . ' OFFSET ' . $offset;
            }

            self::retrieveRecordsFromQuery($matchingRecords, $sql);
        }

        return $matchingRecords;
    }

    /**
     * @param $fields
     * @param $moduleModel
     *
     * @return array
     * @throws Exception
     */
    public static function parseCustomFields($fields, $moduleModel)
    {
        return array_map(function ($fieldName) use ($moduleModel) {
            return Vtiger_Field_Model::getInstance($fieldName, $moduleModel);
        }, $fields);
    }
}
