<?php
/*********************************************************************************
 * The content of this file is subject to the Quick Search 4 You license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 ********************************************************************************/

class ITS4YouQuickSearch_SaveAjax_Action extends Vtiger_IndexAjax_View
{

    public function __construct()
    {
        parent::__construct();
        $this->exposeMethod('save');
    }

    public function checkPermission(Vtiger_Request $request)
    {
        return true;
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    public function save(Vtiger_Request $request)
    {
        $params = $request->get('params');
        ITS4YouQuickSearch_Module_Model::save($params);
        $message = 'LBL_SAVE_CHANGES_LABEL';
        if ($params['name'] == 'turn_off') {
            $message = 'LBL_SAVE_CHANGES_SEARCHING';
        }
        $response = new Vtiger_Response();
        $response->setResult(array(
            'message' => vtranslate($message, $request->getModule(false))
        ));
        $response->emit();
    }

}
